/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.json.JsonPrintable;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.core.util.UserError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.MetaUtil;

public class TypeConfiguration
implements JsonPrintable {
    private final Map<String, ConfigurationType> types = new HashMap<String, ConfigurationType>();

    public ConfigurationType get(String qualifiedJavaName) {
        return this.types.get(qualifiedJavaName);
    }

    public ConfigurationType getByInternalName(String name) {
        return this.types.get(MetaUtil.internalNameToJava((String)name, (boolean)true, (boolean)false));
    }

    public void add(ConfigurationType type) {
        ConfigurationType previous = this.types.putIfAbsent(type.getQualifiedJavaName(), type);
        UserError.guarantee((previous == null || previous == type ? 1 : 0) != 0, (String)"Cannot replace existing type", (Object[])new Object[0]);
    }

    public ConfigurationType getOrCreateType(String qualifiedJavaName) {
        return this.types.computeIfAbsent(qualifiedJavaName, ConfigurationType::new);
    }

    @Override
    public void printJson(JsonWriter writer) throws IOException {
        writer.append('[');
        String prefix = "\n";
        ArrayList<ConfigurationType> list = new ArrayList<ConfigurationType>(this.types.values());
        list.sort(Comparator.comparing(ConfigurationType::getQualifiedJavaName));
        for (ConfigurationType value : list) {
            writer.append(prefix);
            value.printJson(writer);
            prefix = ",\n";
        }
        writer.newline().append(']').newline();
    }
}

