/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.configure.trace.TraceProcessor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TraceProcessorWriterAdapter
extends TraceWriter {
    private final TraceProcessor processor;

    TraceProcessorWriterAdapter(TraceProcessor processor) {
        this.processor = processor;
    }

    TraceProcessor getProcessor() {
        return this.processor;
    }

    @Override
    void traceEntry(Map<String, Object> entry) {
        this.processor.processEntry(this.arraysToLists(entry));
    }

    private Map<String, Object> arraysToLists(Map<String, Object> map) {
        for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
            if (!(mapEntry.getValue() instanceof Object[])) continue;
            mapEntry.setValue(this.arraysToLists((Object[])mapEntry.getValue()));
        }
        return map;
    }

    private List<?> arraysToLists(Object[] array) {
        Object[] newArray = Arrays.copyOf(array, array.length);
        for (int i = 0; i < newArray.length; ++i) {
            if (!(newArray[i] instanceof Object[])) continue;
            newArray[i] = this.arraysToLists((Object[])newArray[i]);
        }
        return Arrays.asList(newArray);
    }

    @Override
    public void close() {
    }
}

