/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.AgentIsolate;
import com.oracle.svm.agent.Support;
import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.agent.jvmti.JvmtiEnv;
import com.oracle.svm.agent.jvmti.JvmtiError;
import com.oracle.svm.agent.restrict.JniAccessVerifier;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIErrors;
import com.oracle.svm.jni.nativeapi.JNIFieldId;
import com.oracle.svm.jni.nativeapi.JNIFunctionPointerTypes;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNINativeInterface;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class JniCallInterceptor {
    private static TraceWriter traceWriter;
    private static JniAccessVerifier accessVerifier;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.DefineClassFunctionPointer> defineClassLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.FindClassFunctionPointer> findClassLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetMemberIDFunctionPointer> getMethodIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetMemberIDFunctionPointer> getStaticMethodIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetFieldIDFunctionPointer> getFieldIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.GetFieldIDFunctionPointer> getStaticFieldIDLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.ThrowNewFunctionPointer> throwNewLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.FromReflectedMethodFunctionPointer> fromReflectedMethodLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.FromReflectedFieldFunctionPointer> fromReflectedFieldLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.ToReflectedMethodFunctionPointer> toReflectedMethodLiteral;
    private static final CEntryPointLiteral<JNIFunctionPointerTypes.ToReflectedFieldFunctionPointer> toReflectedFieldLiteral;

    JniCallInterceptor() {
    }

    private static boolean shouldTrace() {
        return traceWriter != null;
    }

    private static void traceCall(JNIEnvironment env, String function, JNIObjectHandle clazz, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, Object result, Object ... args) {
        JNIObjectHandle pending = Support.jniFunctions().getExceptionOccurred().invoke(env);
        Support.clearException(env);
        traceWriter.traceCall("jni", function, Support.getClassNameOr(env, clazz, null, TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr(env, declaringClass, null, TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr(env, callerClass, null, TraceWriter.UNKNOWN_VALUE), result, args);
        Support.checkNoException(env);
        if (pending.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Support.checkJni(Support.jniFunctions().getThrow().invoke(env, pending));
        }
    }

    @CEntryPoint(name="DefineClass")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIObjectHandle defineClass(JNIEnvironment env, CCharPointer name, JNIObjectHandle loader, CCharPointer buf, int bufLen) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier == null || accessVerifier.verifyDefineClass(env, name, loader, buf, bufLen, callerClass)) {
            result = Support.jniFunctions().getDefineClass().invoke(env, name, loader, buf, bufLen);
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "DefineClass", (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), Support.fromCString(name));
        }
        return result;
    }

    private static JNIObjectHandle getCallerClass(JNIEnvironment env) {
        try {
            JNIObjectHandle jNIObjectHandle = Support.getCallerClass(0);
            return jNIObjectHandle;
        }
        finally {
            Support.checkNoException(env);
        }
    }

    @CEntryPoint(name="FindClass")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIObjectHandle findClass(JNIEnvironment env, CCharPointer name) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier == null || accessVerifier.verifyFindClass(env, name, callerClass)) {
            result = Support.jniFunctions().getFindClass().invoke(env, name);
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "FindClass", (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), Support.fromCString(name));
        }
        return result;
    }

    @CEntryPoint(name="GetMethodID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIMethodId getMethodID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIMethodId result = Support.jniFunctions().getGetMethodID().invoke(env, clazz, name, signature);
        if (result.isNonNull() && accessVerifier != null && !accessVerifier.verifyGetMethodID(env, clazz, name, signature, result, callerClass)) {
            result = (JNIMethodId)WordFactory.nullPointer();
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "GetMethodID", clazz, Support.getMethodDeclaringClass(result), callerClass, result.isNonNull(), Support.fromCString(name), Support.fromCString(signature));
        }
        return result;
    }

    @CEntryPoint(name="GetStaticMethodID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIMethodId getStaticMethodID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIMethodId result = Support.jniFunctions().getGetStaticMethodID().invoke(env, clazz, name, signature);
        if (result.isNonNull() && accessVerifier != null && !accessVerifier.verifyGetMethodID(env, clazz, name, signature, result, callerClass)) {
            result = (JNIMethodId)WordFactory.nullPointer();
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "GetStaticMethodID", clazz, Support.getMethodDeclaringClass(result), callerClass, result.isNonNull(), Support.fromCString(name), Support.fromCString(signature));
        }
        return result;
    }

    @CEntryPoint(name="GetFieldID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIFieldId getFieldID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIFieldId result = Support.jniFunctions().getGetFieldID().invoke(env, clazz, name, signature);
        if (result.isNonNull() && accessVerifier != null && !accessVerifier.verifyGetFieldID(env, clazz, name, signature, result, callerClass)) {
            result = (JNIFieldId)WordFactory.nullPointer();
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "GetFieldID", clazz, Support.getFieldDeclaringClass(clazz, result), callerClass, result.isNonNull(), Support.fromCString(name), Support.fromCString(signature));
        }
        return result;
    }

    @CEntryPoint(name="GetStaticFieldID")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIFieldId getStaticFieldID(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer name, CCharPointer signature) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIFieldId result = Support.jniFunctions().getGetStaticFieldID().invoke(env, clazz, name, signature);
        if (result.isNonNull() && accessVerifier != null && !accessVerifier.verifyGetFieldID(env, clazz, name, signature, result, callerClass)) {
            result = (JNIFieldId)WordFactory.nullPointer();
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "GetStaticFieldID", clazz, Support.getFieldDeclaringClass(clazz, result), callerClass, result.isNonNull(), Support.fromCString(name), Support.fromCString(signature));
        }
        return result;
    }

    @CEntryPoint(name="ThrowNew")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static int throwNew(JNIEnvironment env, JNIObjectHandle clazz, CCharPointer message) {
        int result;
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        if (accessVerifier == null || accessVerifier.verifyThrowNew(env, clazz, callerClass)) {
            result = Support.jniFunctions().getThrowNew().invoke(env, clazz, message);
        } else {
            try (CTypeConversion.CCharPointerHolder errorMessage = Support.toCString("native-image-agent: configuration does not permit access to method: " + Support.getClassNameOr(env, clazz, "(null)", "(?)") + "." + "<init>" + "(Ljava/lang/String;)V");){
                Support.jniFunctions().getThrowNew().invoke(env, Support.handles().javaLangNoSuchMethodError, errorMessage.get());
            }
            result = JNIErrors.JNI_ERR();
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "ThrowNew", clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, result == JNIErrors.JNI_OK(), TraceWriter.UNKNOWN_VALUE);
        }
        return result;
    }

    @CEntryPoint(name="FromReflectedMethod")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIMethodId fromReflectedMethod(JNIEnvironment env, JNIObjectHandle method) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIMethodId result = Support.jniFunctions().getFromReflectedMethod().invoke(env, method);
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String name = null;
        String signature = null;
        if (result.isNonNull()) {
            declaring = Support.getMethodDeclaringClass(result);
            CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
            CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
            if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), result, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                name = Support.fromCString(namePtr.read());
                signature = Support.fromCString(signaturePtr.read());
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
            }
            if (accessVerifier != null && !accessVerifier.verifyFromReflectedMethod(env, declaring, name, signature, result, callerClass)) {
                result = (JNIMethodId)WordFactory.nullPointer();
            }
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "FromReflectedMethod", declaring, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, result.isNonNull(), name, signature);
        }
        return result;
    }

    @CEntryPoint(name="FromReflectedField")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIFieldId fromReflectedField(JNIEnvironment env, JNIObjectHandle field) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIFieldId result = Support.jniFunctions().getFromReflectedField().invoke(env, field);
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String name = TraceWriter.EXPLICIT_NULL;
        if (result.isNonNull()) {
            declaring = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(env, field, Support.handles().javaLangReflectMemberGetDeclaringClass);
            name = Support.getFieldName(declaring, result);
            if (accessVerifier != null && !accessVerifier.verifyFromReflectedField(env, declaring, name, result, callerClass)) {
                result = (JNIFieldId)WordFactory.nullPointer();
            }
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "FromReflectedField", declaring, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, result.isNonNull(), name);
        }
        return result;
    }

    @CEntryPoint(name="ToReflectedMethod")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIObjectHandle toReflectedMethod(JNIEnvironment env, JNIObjectHandle clazz, JNIMethodId method, boolean isStatic) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIObjectHandle declaring = Support.getMethodDeclaringClass(method);
        String name = null;
        String signature = null;
        CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), method, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
            name = Support.fromCString(namePtr.read());
            signature = Support.fromCString(signaturePtr.read());
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
        }
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier == null || accessVerifier.verifyToReflectedMethod(env, clazz, declaring, method, name, signature, callerClass)) {
            result = Support.jniFunctions().getToReflectedMethod().invoke(env, clazz, method, isStatic);
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "ToReflectedMethod", clazz, declaring, callerClass, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name, signature);
        }
        return result;
    }

    @CEntryPoint(name="ToReflectedField")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static JNIObjectHandle toReflectedField(JNIEnvironment env, JNIObjectHandle clazz, JNIFieldId field, boolean isStatic) {
        JNIObjectHandle callerClass = JniCallInterceptor.getCallerClass(env);
        JNIObjectHandle declaring = Support.getFieldDeclaringClass(clazz, field);
        String name = Support.getFieldName(clazz, field);
        JNIObjectHandle result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier == null || accessVerifier.verifyToReflectedField(env, clazz, declaring, name, field, callerClass)) {
            result = Support.jniFunctions().getToReflectedField().invoke(env, clazz, field, isStatic);
        }
        if (JniCallInterceptor.shouldTrace()) {
            JniCallInterceptor.traceCall(env, "ToReflectedField", clazz, declaring, callerClass, result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name);
        }
        return result;
    }

    public static void onLoad(TraceWriter writer, JniAccessVerifier verifier) {
        accessVerifier = verifier;
        traceWriter = writer;
    }

    public static void onVMStart(JvmtiEnv jvmti) {
        WordPointer functionsPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check(jvmti.getFunctions().GetJNIFunctionTable().invoke(jvmti, functionsPtr));
        JNINativeInterface functions = (JNINativeInterface)functionsPtr.read();
        functions.setDefineClass((JNIFunctionPointerTypes.DefineClassFunctionPointer)defineClassLiteral.getFunctionPointer());
        functions.setFindClass((JNIFunctionPointerTypes.FindClassFunctionPointer)findClassLiteral.getFunctionPointer());
        functions.setGetMethodID((JNIFunctionPointerTypes.GetMemberIDFunctionPointer)getMethodIDLiteral.getFunctionPointer());
        functions.setGetStaticMethodID((JNIFunctionPointerTypes.GetMemberIDFunctionPointer)getStaticMethodIDLiteral.getFunctionPointer());
        functions.setGetFieldID((JNIFunctionPointerTypes.GetFieldIDFunctionPointer)getFieldIDLiteral.getFunctionPointer());
        functions.setGetStaticFieldID((JNIFunctionPointerTypes.GetFieldIDFunctionPointer)getStaticFieldIDLiteral.getFunctionPointer());
        functions.setThrowNew((JNIFunctionPointerTypes.ThrowNewFunctionPointer)throwNewLiteral.getFunctionPointer());
        functions.setFromReflectedMethod((JNIFunctionPointerTypes.FromReflectedMethodFunctionPointer)fromReflectedMethodLiteral.getFunctionPointer());
        functions.setToReflectedMethod((JNIFunctionPointerTypes.ToReflectedMethodFunctionPointer)toReflectedMethodLiteral.getFunctionPointer());
        functions.setFromReflectedField((JNIFunctionPointerTypes.FromReflectedFieldFunctionPointer)fromReflectedFieldLiteral.getFunctionPointer());
        functions.setToReflectedField((JNIFunctionPointerTypes.ToReflectedFieldFunctionPointer)toReflectedFieldLiteral.getFunctionPointer());
        Support.check(jvmti.getFunctions().SetJNIFunctionTable().invoke(jvmti, functions));
        Support.check(jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)functions));
    }

    public static void onUnload() {
        Support.jvmtiFunctions().SetJNIFunctionTable().invoke(Support.jvmtiEnv(), Support.jniFunctions());
        accessVerifier = null;
        traceWriter = null;
    }

    static {
        defineClassLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"defineClass", (Class[])new Class[]{JNIEnvironment.class, CCharPointer.class, JNIObjectHandle.class, CCharPointer.class, Integer.TYPE});
        findClassLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"findClass", (Class[])new Class[]{JNIEnvironment.class, CCharPointer.class});
        getMethodIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getMethodID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        getStaticMethodIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getStaticMethodID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        getFieldIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getFieldID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        getStaticFieldIDLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"getStaticFieldID", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class, CCharPointer.class});
        throwNewLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"throwNew", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, CCharPointer.class});
        fromReflectedMethodLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"fromReflectedMethod", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class});
        fromReflectedFieldLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"fromReflectedField", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class});
        toReflectedMethodLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"toReflectedMethod", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, Boolean.TYPE});
        toReflectedFieldLiteral = CEntryPointLiteral.create(JniCallInterceptor.class, (String)"toReflectedField", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIFieldId.class, Boolean.TYPE});
    }
}

