/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.AgentIsolate;
import com.oracle.svm.agent.Support;
import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.agent.jvmti.JvmtiCapabilities;
import com.oracle.svm.agent.jvmti.JvmtiEnv;
import com.oracle.svm.agent.jvmti.JvmtiError;
import com.oracle.svm.agent.jvmti.JvmtiEvent;
import com.oracle.svm.agent.jvmti.JvmtiEventCallbacks;
import com.oracle.svm.agent.jvmti.JvmtiEventMode;
import com.oracle.svm.agent.restrict.ProxyAccessVerifier;
import com.oracle.svm.agent.restrict.ReflectAccessVerifier;
import com.oracle.svm.agent.restrict.ResourceAccessVerifier;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIFunctionPointerTypes;
import com.oracle.svm.jni.nativeapi.JNIMethodId;
import com.oracle.svm.jni.nativeapi.JNINativeMethod;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class BreakpointInterceptor {
    private static TraceWriter traceWriter;
    private static ReflectAccessVerifier accessVerifier;
    private static ProxyAccessVerifier proxyVerifier;
    private static ResourceAccessVerifier resourceVerifier;
    private static Map<Long, Breakpoint> installedBreakpoints;
    private static Map<Long, Long> boundNativeMethods;
    private static Map<Long, NativeBreakpoint> nativeBreakpoints;
    private static final ReentrantLock nativeBreakpointsInitLock;
    private static final ThreadLocal<Boolean> recursive;
    private static final CEntryPointLiteral<ObjectFieldOffsetFunctionPointer> nativeObjectFieldOffsetLiteral;
    private static final NativeBreakpointSpecification NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC;
    private static final CEntryPointLiteral<CFunctionPointer> onBreakpointLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onNativeMethodBindLiteral;
    private static final BreakpointSpecification[] BREAKPOINT_SPECIFICATIONS;
    private static final NativeBreakpointSpecification[] NATIVE_BREAKPOINT_SPECIFICATIONS;

    private static void traceBreakpoint(JNIEnvironment env, JNIObjectHandle clazz, JNIObjectHandle declaringClass, JNIObjectHandle callerClass, String function, Object result, Object ... args) {
        if (traceWriter != null) {
            traceWriter.traceCall("reflect", function, Support.getClassNameOr(env, clazz, null, TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr(env, declaringClass, null, TraceWriter.UNKNOWN_VALUE), Support.getClassNameOr(env, callerClass, null, TraceWriter.UNKNOWN_VALUE), result, args);
            VMError.guarantee((!Support.testException(env) ? 1 : 0) != 0);
        }
    }

    private static boolean forName(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIObjectHandle name = Support.getObjectArgument(0);
        String className = Support.fromJniString(jni, name);
        boolean allowed = accessVerifier == null || accessVerifier.verifyForName(jni, callerClass, className);
        Object result = false;
        if (allowed) {
            boolean initializeValid = true;
            boolean classLoaderValid = true;
            CIntPointer initializePtr = (CIntPointer)StackValue.get(CIntPointer.class);
            WordPointer classLoaderPtr = (WordPointer)StackValue.get(WordPointer.class);
            if (bp.method == Support.handles().javaLangClassForName3) {
                initializeValid = Support.jvmtiFunctions().GetLocalInt().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, 1, (PointerBase)initializePtr) == JvmtiError.JVMTI_ERROR_NONE;
                classLoaderValid = Support.jvmtiFunctions().GetLocalObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), 0, 2, (PointerBase)classLoaderPtr) == JvmtiError.JVMTI_ERROR_NONE;
            } else {
                initializePtr.write(1);
                classLoaderPtr.write((WordBase)JNIObjectHandles.nullHandle());
                if (callerClass.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                    classLoaderValid = Support.jvmtiFunctions().GetClassLoader().invoke(Support.jvmtiEnv(), callerClass, (PointerBase)classLoaderPtr) == JvmtiError.JVMTI_ERROR_NONE;
                }
            }
            result = TraceWriter.UNKNOWN_VALUE;
            if (initializeValid && classLoaderValid) {
                result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)((JNIFunctionPointerTypes.CallObjectMethod3FunctionPointer)Support.jniFunctions().getCallStaticObjectMethod()).invoke(jni, bp.clazz, Support.handles().javaLangClassForName3, (WordBase)name, (WordBase)WordFactory.signed((int)initializePtr.read()), classLoaderPtr.read()));
                if (Support.clearException(jni)) {
                    result = false;
                }
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, bp.clazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, className);
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit access to class: " + className);){
                Support.jniFunctions().getThrowNew().invoke(jni, Support.handles().javaLangClassNotFoundException, message.get());
            }
        }
        return allowed;
    }

    private static boolean getFields(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetFields(jni, callerClass, bp, false);
    }

    private static boolean getDeclaredFields(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetFields(jni, callerClass, bp, true);
    }

    private static boolean handleGetFields(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier != null) {
            returnResult = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, self, bp.method);
            if (Support.clearException(jni)) {
                returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if (returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                returnResult = accessVerifier.filterGetFields(jni, self, returnResult, declaredOnly, callerClass);
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, new Object[0]);
        if (accessVerifier != null && returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), returnResult);
        }
        return true;
    }

    private static boolean getMethods(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, callerClass, bp, false, () -> Support.handles().getJavaLangReflectMethod(jni));
    }

    private static boolean getDeclaredMethods(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, callerClass, bp, true, () -> Support.handles().getJavaLangReflectMethod(jni));
    }

    private static boolean getConstructors(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, callerClass, bp, true, () -> Support.handles().getJavaLangReflectConstructor(jni));
    }

    private static boolean getDeclaredConstructors(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethods(jni, callerClass, bp, true, () -> Support.handles().getJavaLangReflectConstructor(jni));
    }

    private static boolean handleGetMethods(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp, boolean declaredOnly, Support.WordSupplier<JNIObjectHandle> elementClass) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (accessVerifier != null) {
            returnResult = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, self, bp.method);
            if (Support.clearException(jni)) {
                returnResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            if (returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                returnResult = accessVerifier.filterGetMethods(jni, self, returnResult, elementClass, declaredOnly, callerClass);
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, null, new Object[0]);
        if (accessVerifier != null && returnResult.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), returnResult);
        }
        return true;
    }

    private static boolean getField(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetField(jni, callerClass, bp, false);
    }

    private static boolean getDeclaredField(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetField(jni, callerClass, bp, true);
    }

    private static boolean handleGetField(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle name = Support.getObjectArgument(1);
        JNIObjectHandle result = ((JNIFunctionPointerTypes.CallObjectMethod1FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, self, bp.method, (WordBase)name);
        if (Support.clearException(jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, result, Support.handles().javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException(jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetField(jni, self, name, result, declaredOnly ? self : declaring, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), Support.fromJniString(jni, name));
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit access to field: " + Support.getClassNameOr(jni, self, "(null)", "(?)") + "." + Support.fromJniString(jni, name));){
                Support.jniFunctions().getThrowNew().invoke(jni, Support.handles().javaLangNoSuchFieldException, message.get());
            }
        }
        return allowed;
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    static long nativeObjectFieldOffset(JNIEnvironment jni, JNIObjectHandle self, JNIObjectHandle field) {
        VMError.guarantee((BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed != null && BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed.replacedFunction.isNonNull() ? 1 : 0) != 0, (String)"incompletely installed");
        ObjectFieldOffsetFunctionPointer original = (ObjectFieldOffsetFunctionPointer)BreakpointInterceptor.NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC.installed.replacedFunction;
        long result = original.invoke(jni, self, field);
        if (!Support.isInitialized()) {
            return result;
        }
        boolean validResult = !Support.clearException(jni);
        JNIMethodId currentMethod = Support.getCallerMethod(0);
        JNIObjectHandle callerClass = Support.getCallerClass(1);
        JNIObjectHandle name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (field.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            name = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, field, Support.handles().javaLangReflectMemberGetName);
            if (Support.clearException(jni)) {
                name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            declaring = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, field, Support.handles().javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException(jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        if (!BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, currentMethod, callerClass)) {
            return Long.MIN_VALUE;
        }
        if (!validResult) {
            return original.invoke(jni, self, field);
        }
        return result;
    }

    private static boolean objectFieldOffset(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle field = Support.getObjectArgument(1);
        ((JNIFunctionPointerTypes.CallLongMethod1FunctionPointer)Support.jniFunctions().getCallLongMethod()).invoke(jni, self, bp.method, (WordBase)field);
        boolean validResult = !Support.clearException(jni);
        JNIObjectHandle name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (field.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            name = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, field, Support.handles().javaLangReflectMemberGetName);
            if (Support.clearException(jni)) {
                name = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
            declaring = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, field, Support.handles().javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException(jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        return BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, bp.method, callerClass);
    }

    private static boolean verifyAndTraceObjectFieldOffset(JNIEnvironment jni, boolean validResult, JNIObjectHandle name, JNIObjectHandle declaring, JNIMethodId currentMethod, JNIObjectHandle callerClass) {
        JNIObjectHandle clazz = Support.getMethodDeclaringClass(currentMethod);
        boolean allowed = !validResult || accessVerifier == null || accessVerifier.verifyObjectFieldOffset(jni, name, declaring, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, clazz, declaring, callerClass, "objectFieldOffset", allowed && validResult, Support.fromJniString(jni, name));
        if (!allowed) {
            try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit unsafe access to field: " + Support.getClassNameOr(jni, declaring, "(null)", "(?)") + "." + Support.fromJniString(jni, name));){
                Support.jniFunctions().getThrowNew().invoke(jni, Support.handles().javaLangRuntimeException, message.get());
            }
            return false;
        }
        return true;
    }

    private static boolean objectFieldOffsetByName(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle declaring = Support.getObjectArgument(1);
        JNIObjectHandle name = Support.getObjectArgument(2);
        ((JNIFunctionPointerTypes.CallLongMethod2FunctionPointer)Support.jniFunctions().getCallLongMethod()).invoke(jni, self, bp.method, (WordBase)declaring, (WordBase)name);
        boolean validResult = !Support.clearException(jni);
        return BreakpointInterceptor.verifyAndTraceObjectFieldOffset(jni, validResult, name, declaring, bp.method, callerClass);
    }

    private static boolean getConstructor(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument(1);
        JNIObjectHandle result = ((JNIFunctionPointerTypes.CallObjectMethod1FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, self, bp.method, (WordBase)paramTypesHandle);
        if (Support.clearException(jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        Supplier<String> signature = () -> BreakpointInterceptor.asInternalSignature(paramTypes);
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetConstructor(jni, self, signature, result, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && JNIObjectHandles.nullHandle().notEqual((ComparableWord)result), paramTypes);
        if (!allowed) {
            BreakpointInterceptor.throwNoSuchMethodException(jni, self, "<init>", signature.get());
        }
        return allowed;
    }

    private static boolean getMethod(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethod(jni, callerClass, bp, false);
    }

    private static boolean getDeclaredMethod(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetMethod(jni, callerClass, bp, true);
    }

    private static boolean handleGetMethod(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp, boolean declaredOnly) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle nameHandle = Support.getObjectArgument(1);
        JNIObjectHandle paramTypesHandle = Support.getObjectArgument(2);
        JNIObjectHandle result = ((JNIFunctionPointerTypes.CallObjectMethod2FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, self, bp.method, (WordBase)nameHandle, (WordBase)paramTypesHandle);
        if (Support.clearException(jni)) {
            result = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        }
        JNIObjectHandle declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (!declaredOnly && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            declaring = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, result, Support.handles().javaLangReflectMemberGetDeclaringClass);
            if (Support.clearException(jni)) {
                declaring = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        String name = Support.fromJniString(jni, nameHandle);
        Object paramTypes = BreakpointInterceptor.getClassArrayNames(jni, paramTypesHandle);
        Supplier<String> signature = () -> BreakpointInterceptor.asInternalSignature(paramTypes);
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetMethod(jni, self, name, signature, result, declaredOnly ? self : declaring, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, declaring, callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), name, paramTypes);
        if (!allowed) {
            BreakpointInterceptor.throwNoSuchMethodException(jni, self, name, signature.get());
        }
        return allowed;
    }

    private static boolean getEnclosingMethod(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIObjectHandle self = Support.getObjectArgument(0);
        String result = TraceWriter.EXPLICIT_NULL;
        JNIObjectHandle enclosing = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, self, bp.method);
        JNIObjectHandle holder = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String name = null;
        String signature = null;
        if (!Support.clearException(jni) && enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            result = TraceWriter.UNKNOWN_VALUE;
            JNIMethodId enclosingID = Support.jniFunctions().getFromReflectedMethod().invoke(jni, enclosing);
            if (!Support.clearException(jni) && enclosingID.isNonNull()) {
                WordPointer holderPtr = (WordPointer)StackValue.get(WordPointer.class);
                if (Support.jvmtiFunctions().GetMethodDeclaringClass().invoke(Support.jvmtiEnv(), enclosingID, holderPtr) == JvmtiError.JVMTI_ERROR_NONE) {
                    holder = (JNIObjectHandle)holderPtr.read();
                    String holderName = Support.getClassNameOrNull(jni, (JNIObjectHandle)holderPtr.read());
                    if (holderName != null) {
                        CCharPointerPointer namePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                        CCharPointerPointer signaturePtr = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
                        if (Support.jvmtiFunctions().GetMethodName().invoke(Support.jvmtiEnv(), enclosingID, namePtr, signaturePtr, (CCharPointerPointer)WordFactory.nullPointer()) == JvmtiError.JVMTI_ERROR_NONE) {
                            name = Support.fromCString(namePtr.read());
                            signature = Support.fromCString(signaturePtr.read());
                            result = holderName + "." + name + signature;
                            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)namePtr.read());
                            Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)signaturePtr.read());
                        }
                    }
                }
            }
        }
        boolean allowed = enclosing.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyGetEnclosingMethod(jni, holder, name, signature, enclosing, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && enclosing.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) ? result : Boolean.valueOf(false), new Object[0]);
        if (!allowed) {
            Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle());
        }
        return allowed;
    }

    private static boolean newInstance(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIMethodId result = (JNIMethodId)WordFactory.nullPointer();
        String name = "<init>";
        String signature = "()V";
        JNIObjectHandle self = Support.getObjectArgument(0);
        if (self.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            try (CTypeConversion.CCharPointerHolder ctorName = Support.toCString(name);
                 CTypeConversion.CCharPointerHolder ctorSignature = Support.toCString(signature);){
                result = Support.jniFunctions().getGetMethodID().invoke(jni, self, ctorName.get(), ctorSignature.get());
            }
            if (Support.clearException(jni)) {
                result = (JNIMethodId)WordFactory.nullPointer();
            }
        }
        boolean allowed = result.equal((ComparableWord)JNIObjectHandles.nullHandle()) || accessVerifier == null || accessVerifier.verifyNewInstance(jni, self, name, signature, result, callerClass);
        BreakpointInterceptor.traceBreakpoint(jni, self, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, allowed && result.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), new Object[0]);
        if (!allowed) {
            BreakpointInterceptor.throwNoSuchMethodException(jni, self, name, signature);
        }
        return allowed;
    }

    private static void throwNoSuchMethodException(JNIEnvironment jni, JNIObjectHandle clazz, String name, String signature) {
        try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit access to method: " + Support.getClassNameOr(jni, clazz, "(null)", "(?)") + "." + name + signature);){
            Support.jniFunctions().getThrowNew().invoke(jni, Support.handles().javaLangNoSuchMethodException, message.get());
        }
    }

    private static boolean getResource(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetResources(jni, callerClass, bp, false);
    }

    private static boolean getResources(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetResources(jni, callerClass, bp, true);
    }

    private static boolean handleGetResources(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp, boolean returnsEnumeration) {
        boolean allowed;
        JNIObjectHandle self = Support.getObjectArgument(0);
        JNIObjectHandle name = Support.getObjectArgument(1);
        boolean result = false;
        boolean bl = allowed = resourceVerifier == null || resourceVerifier.verifyGetResources(jni, name, callerClass);
        if (allowed) {
            JNIObjectHandle returnValue = ((JNIFunctionPointerTypes.CallObjectMethod1FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(jni, self, bp.method, (WordBase)name);
            result = returnValue.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            if (Support.clearException(jni)) {
                result = false;
            }
            if (result && returnsEnumeration) {
                result = BreakpointInterceptor.hasEnumerationElements(jni, returnValue);
            }
        }
        JNIObjectHandle selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (self.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            selfClazz = Support.jniFunctions().getGetObjectClass().invoke(jni, self);
            if (Support.clearException(jni)) {
                selfClazz = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, selfClazz, (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, Support.fromJniString(jni, name));
        if (!allowed) {
            BreakpointInterceptor.forceGetResourceReturn(jni, returnsEnumeration);
        }
        return allowed;
    }

    private static boolean hasEnumerationElements(JNIEnvironment jni, JNIObjectHandle obj) {
        boolean hasElements = ((JNIFunctionPointerTypes.CallBooleanMethod0FunctionPointer)Support.jniFunctions().getCallBooleanMethod()).invoke(jni, obj, Support.handles().javaUtilEnumerationHasMoreElements);
        if (Support.clearException(jni)) {
            hasElements = false;
        }
        return hasElements;
    }

    private static void forceGetResourceReturn(JNIEnvironment env, boolean returnsEnumeration) {
        JNIObjectHandle newResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        if (returnsEnumeration) {
            JNIObjectHandle javaUtilCollections = Support.handles().getJavaUtilCollections(env);
            JNIMethodId emptyEnumeration = Support.handles().getJavaUtilCollectionsEmptyEnumeration(env);
            if (javaUtilCollections.notEqual((ComparableWord)JNIObjectHandles.nullHandle()) && emptyEnumeration.isNonNull()) {
                newResult = ((JNIFunctionPointerTypes.CallObjectMethod0FunctionPointer)Support.jniFunctions().getCallObjectMethod()).invoke(env, javaUtilCollections, emptyEnumeration);
                if (Support.clearException(env)) {
                    newResult = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                }
            }
        }
        Support.jvmtiFunctions().ForceEarlyReturnObject().invoke(Support.jvmtiEnv(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), newResult);
    }

    private static boolean getSystemResource(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetSystemResources(jni, callerClass, bp, false);
    }

    private static boolean getSystemResources(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        return BreakpointInterceptor.handleGetSystemResources(jni, callerClass, bp, true);
    }

    private static boolean handleGetSystemResources(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp, boolean returnsEnumeration) {
        JNIObjectHandle name = Support.getObjectArgument(0);
        boolean allowed = resourceVerifier == null || resourceVerifier.verifyGetSystemResources(jni, name, callerClass);
        boolean result = false;
        if (allowed) {
            JNIObjectHandle returnValue = ((JNIFunctionPointerTypes.CallObjectMethod1FunctionPointer)Support.jniFunctions().getCallStaticObjectMethod()).invoke(jni, bp.clazz, bp.method, (WordBase)name);
            result = returnValue.notEqual((ComparableWord)JNIObjectHandles.nullHandle());
            if (Support.clearException(jni)) {
                result = false;
            }
            if (result && returnsEnumeration) {
                result = BreakpointInterceptor.hasEnumerationElements(jni, returnValue);
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, Support.fromJniString(jni, name));
        if (!allowed) {
            BreakpointInterceptor.forceGetResourceReturn(jni, returnsEnumeration);
        }
        return allowed;
    }

    private static boolean newProxyInstance(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIObjectHandle classLoader = Support.getObjectArgument(0);
        JNIObjectHandle ifaces = Support.getObjectArgument(1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        boolean allowed = proxyVerifier == null || proxyVerifier.verifyNewProxyInstance(jni, ifaceNames, callerClass);
        boolean result = false;
        if (allowed) {
            JNIObjectHandle invokeHandler = Support.getObjectArgument(2);
            result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)((JNIFunctionPointerTypes.CallObjectMethod3FunctionPointer)Support.jniFunctions().getCallStaticObjectMethod()).invoke(jni, bp.clazz, bp.method, (WordBase)classLoader, (WordBase)ifaces, (WordBase)invokeHandler));
            if (Support.clearException(jni)) {
                result = false;
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, TraceWriter.UNKNOWN_VALUE, ifaceNames, TraceWriter.UNKNOWN_VALUE);
        if (!allowed) {
            BreakpointInterceptor.throwDeniedProxyException(jni, ifaceNames);
        }
        return allowed;
    }

    private static boolean getProxyClass(JNIEnvironment jni, JNIObjectHandle callerClass, Breakpoint bp) {
        JNIObjectHandle classLoader = Support.getObjectArgument(0);
        JNIObjectHandle ifaces = Support.getObjectArgument(1);
        Object ifaceNames = BreakpointInterceptor.getClassArrayNames(jni, ifaces);
        boolean allowed = proxyVerifier == null || proxyVerifier.verifyGetProxyClass(jni, ifaceNames, callerClass);
        boolean result = false;
        if (allowed) {
            result = JNIObjectHandles.nullHandle().notEqual((ComparableWord)((JNIFunctionPointerTypes.CallObjectMethod2FunctionPointer)Support.jniFunctions().getCallStaticObjectMethod()).invoke(jni, bp.clazz, bp.method, (WordBase)classLoader, (WordBase)ifaces));
            if (Support.clearException(jni)) {
                result = false;
            }
        }
        BreakpointInterceptor.traceBreakpoint(jni, (JNIObjectHandle)JNIObjectHandles.nullHandle(), (JNIObjectHandle)JNIObjectHandles.nullHandle(), callerClass, ((BreakpointSpecification)bp.specification).methodName, result, TraceWriter.UNKNOWN_VALUE, ifaceNames);
        if (!allowed) {
            BreakpointInterceptor.throwDeniedProxyException(jni, ifaceNames);
        }
        return allowed;
    }

    private static void throwDeniedProxyException(JNIEnvironment jni, Object ifaceNames) {
        String interfaceString = "(unknown)";
        if (ifaceNames instanceof Object[]) {
            interfaceString = Arrays.toString((Object[])ifaceNames);
        }
        try (CTypeConversion.CCharPointerHolder message = Support.toCString("native-image-agent: configuration does not permit proxy class for interfaces: " + interfaceString);){
            Support.jniFunctions().getThrowNew().invoke(jni, Support.handles().javaLangSecurityException, message.get());
        }
    }

    private static Object getClassArrayNames(JNIEnvironment jni, JNIObjectHandle classArray) {
        String[] classNames = TraceWriter.EXPLICIT_NULL;
        if (classArray.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
            classNames = TraceWriter.UNKNOWN_VALUE;
            int length = Support.jniFunctions().getGetArrayLength().invoke(jni, classArray);
            if (!Support.clearException(jni) && length >= 0) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    JNIObjectHandle clazz = Support.jniFunctions().getGetObjectArrayElement().invoke(jni, classArray, i);
                    if (!Support.clearException(jni)) {
                        list.add(Support.getClassNameOr(jni, clazz, TraceWriter.EXPLICIT_NULL, TraceWriter.UNKNOWN_VALUE));
                        continue;
                    }
                    list.add(TraceWriter.UNKNOWN_VALUE);
                }
                classNames = list.toArray(new String[0]);
            }
        }
        return classNames;
    }

    private static String asInternalSignature(Object paramTypesArray) {
        if (paramTypesArray instanceof Object[]) {
            StringBuilder sb = new StringBuilder("(");
            for (Object paramType : (Object[])paramTypesArray) {
                sb.append(MetaUtil.toInternalName((String)paramType.toString()));
            }
            return sb.append(')').toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static void onBreakpoint(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, long location) {
        if (recursive.get().booleanValue()) {
            return;
        }
        recursive.set(true);
        try {
            JNIObjectHandle callerClass = Support.getCallerClass(1);
            Breakpoint bp = installedBreakpoints.get(method.rawValue());
            if (((BreakpointSpecification)bp.specification).handler.dispatch(jni, callerClass, bp)) {
                VMError.guarantee((!Support.testException(jni) ? 1 : 0) != 0);
            }
        }
        catch (Throwable t) {
            VMError.shouldNotReachHere((Throwable)t);
        }
        finally {
            recursive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    private static void onNativeMethodBind(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, CodePointer address, WordPointer newAddressPtr) {
        if (recursive.get().booleanValue()) {
            return;
        }
        nativeBreakpointsInitLock.lock();
        try {
            if (nativeBreakpoints != null) {
                NativeBreakpoint bp = nativeBreakpoints.get(method.rawValue());
                if (bp != null) {
                    BreakpointInterceptor.bindNativeBreakpoint(jni, bp, address, newAddressPtr);
                }
            } else {
                boundNativeMethods.put(method.rawValue(), address.rawValue());
            }
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
    }

    public static void onLoad(JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, TraceWriter writer, ReflectAccessVerifier verifier, ProxyAccessVerifier prverifier, ResourceAccessVerifier resverifier) {
        JvmtiCapabilities capabilities = (JvmtiCapabilities)UnmanagedMemory.calloc((int)SizeOf.get(JvmtiCapabilities.class));
        Support.check(jvmti.getFunctions().GetCapabilities().invoke(jvmti, capabilities));
        capabilities.setCanGenerateBreakpointEvents(1);
        capabilities.setCanAccessLocalVariables(1);
        capabilities.setCanForceEarlyReturn(1);
        capabilities.setCanGenerateNativeMethodBindEvents(1);
        Support.check(jvmti.getFunctions().AddCapabilities().invoke(jvmti, capabilities));
        UnmanagedMemory.free((PointerBase)capabilities);
        callbacks.setBreakpoint(onBreakpointLiteral.getFunctionPointer());
        callbacks.setNativeMethodBind(onNativeMethodBindLiteral.getFunctionPointer());
        traceWriter = writer;
        accessVerifier = verifier;
        proxyVerifier = prverifier;
        resourceVerifier = resverifier;
        boundNativeMethods = Collections.synchronizedMap(new HashMap());
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_NATIVE_METHOD_BIND, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVMInit(JvmtiEnv jvmti, JNIEnvironment jni) {
        JNIMethodId method;
        JNIObjectHandle clazz;
        HashMap<Long, Breakpoint> breakpoints = new HashMap<Long, Breakpoint>(BREAKPOINT_SPECIFICATIONS.length);
        JNIObjectHandle lastClass = (JNIObjectHandle)JNIObjectHandles.nullHandle();
        String lastClassName = null;
        for (BreakpointSpecification breakpointSpecification : BREAKPOINT_SPECIFICATIONS) {
            if (lastClassName != null && lastClassName.equals(breakpointSpecification.className)) {
                clazz = lastClass;
            } else {
                lastClass = clazz = BreakpointInterceptor.resolveBreakpointClass(jni, breakpointSpecification.className, breakpointSpecification.optional);
                lastClassName = breakpointSpecification.className;
            }
            method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, breakpointSpecification.methodName, breakpointSpecification.signature, breakpointSpecification.optional);
            JvmtiError result = Support.jvmtiFunctions().SetBreakpoint().invoke(jvmti, method, 0L);
            if (result == JvmtiError.JVMTI_ERROR_NONE) {
                breakpoints.put(method.rawValue(), new Breakpoint(breakpointSpecification, clazz, method));
                continue;
            }
            VMError.guarantee((boolean)breakpointSpecification.optional, (String)"Setting breakpoint failed");
        }
        installedBreakpoints = breakpoints;
        nativeBreakpointsInitLock.lock();
        try {
            nativeBreakpoints = new HashMap<Long, NativeBreakpoint>(NATIVE_BREAKPOINT_SPECIFICATIONS.length);
            for (AbstractBreakpointSpecification abstractBreakpointSpecification : NATIVE_BREAKPOINT_SPECIFICATIONS) {
                if (lastClassName != null && lastClassName.equals(((NativeBreakpointSpecification)abstractBreakpointSpecification).className)) {
                    clazz = lastClass;
                } else {
                    lastClass = clazz = BreakpointInterceptor.resolveBreakpointClass(jni, ((NativeBreakpointSpecification)abstractBreakpointSpecification).className, ((NativeBreakpointSpecification)abstractBreakpointSpecification).optional);
                    lastClassName = ((NativeBreakpointSpecification)abstractBreakpointSpecification).className;
                }
                method = BreakpointInterceptor.resolveBreakpointMethod(jni, clazz, ((NativeBreakpointSpecification)abstractBreakpointSpecification).methodName, ((NativeBreakpointSpecification)abstractBreakpointSpecification).signature, ((NativeBreakpointSpecification)abstractBreakpointSpecification).optional);
                if (!method.isNonNull()) continue;
                NativeBreakpoint bp = new NativeBreakpoint((NativeBreakpointSpecification)abstractBreakpointSpecification, clazz, method);
                nativeBreakpoints.put(method.rawValue(), bp);
                Long original = boundNativeMethods.get(method.rawValue());
                if (original == null) continue;
                BreakpointInterceptor.bindNativeBreakpoint(jni, bp, (CodePointer)WordFactory.pointer((long)original), (WordPointer)WordFactory.nullPointer());
            }
            boundNativeMethods = null;
        }
        finally {
            nativeBreakpointsInitLock.unlock();
        }
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_BREAKPOINT, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
    }

    private static JNIObjectHandle resolveBreakpointClass(JNIEnvironment jni, String className, boolean optional) {
        JNIObjectHandle clazz;
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString(className);){
            clazz = Support.jniFunctions().getFindClass().invoke(jni, cname.get());
            if (optional && (Support.clearException(jni) || clazz.equal((ComparableWord)JNIObjectHandles.nullHandle()))) {
                JNIObjectHandle jNIObjectHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                return jNIObjectHandle;
            }
            Support.checkNoException(jni);
        }
        clazz = Support.jniFunctions().getNewGlobalRef().invoke(jni, clazz);
        Support.checkNoException(jni);
        return clazz;
    }

    private static JNIMethodId resolveBreakpointMethod(JNIEnvironment jni, JNIObjectHandle clazz, String methodName, String signature, boolean optional) {
        JNIMethodId method;
        if (optional && clazz.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return (JNIMethodId)WordFactory.nullPointer();
        }
        VMError.guarantee((boolean)clazz.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString(methodName);
             CTypeConversion.CCharPointerHolder csignature = Support.toCString(signature);){
            method = Support.jniFunctions().getGetMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            if (method.isNull()) {
                Support.clearException(jni);
                method = Support.jniFunctions().getGetStaticMethodID().invoke(jni, clazz, cname.get(), csignature.get());
            }
        }
        if (optional && (Support.clearException(jni) || method.isNull())) {
            return (JNIMethodId)WordFactory.nullPointer();
        }
        VMError.guarantee((!Support.testException(jni) && method.isNonNull() ? 1 : 0) != 0);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindNativeBreakpoint(JNIEnvironment jni, NativeBreakpoint bp, CodePointer originalAddress, WordPointer newAddressPtr) {
        assert (!recursive.get().booleanValue());
        bp.replacedFunction = originalAddress;
        CFunctionPointer breakpointMethod = ((NativeBreakpointSpecification)bp.specification).handlerLiteral.getFunctionPointer();
        if (newAddressPtr.isNonNull()) {
            newAddressPtr.write((WordBase)breakpointMethod);
        } else {
            recursive.set(true);
            try (CTypeConversion.CCharPointerHolder cname = Support.toCString(((NativeBreakpointSpecification)bp.specification).methodName);
                 CTypeConversion.CCharPointerHolder csignature = Support.toCString(((NativeBreakpointSpecification)bp.specification).signature);){
                JNINativeMethod nativeMethod = (JNINativeMethod)StackValue.get(JNINativeMethod.class);
                nativeMethod.setName(cname.get());
                nativeMethod.setSignature(csignature.get());
                nativeMethod.setFnPtr(breakpointMethod);
                Support.checkJni(jni.getFunctions().getRegisterNatives().invoke(jni, bp.clazz, nativeMethod, 1));
            }
            finally {
                recursive.set(false);
            }
        }
    }

    public static void onUnload(JNIEnvironment env) {
        installedBreakpoints.values().stream().map(bp -> bp.clazz.rawValue()).distinct().forEach(ref -> Support.jniFunctions().getDeleteGlobalRef().invoke(env, (JNIObjectHandle)WordFactory.pointer((long)ref)));
        installedBreakpoints = null;
        nativeBreakpoints = null;
        accessVerifier = null;
        proxyVerifier = null;
        resourceVerifier = null;
        traceWriter = null;
    }

    private static BreakpointSpecification brk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, false);
    }

    private static BreakpointSpecification optionalBrk(String className, String methodName, String signature, BreakpointHandler handler) {
        return new BreakpointSpecification(className, methodName, signature, handler, true);
    }

    private BreakpointInterceptor() {
    }

    static {
        nativeBreakpointsInitLock = new ReentrantLock();
        recursive = ThreadLocal.withInitial(() -> Boolean.FALSE);
        nativeObjectFieldOffsetLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"nativeObjectFieldOffset", (Class[])new Class[]{JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
        NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC = new NativeBreakpointSpecification("sun/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", nativeObjectFieldOffsetLiteral);
        onBreakpointLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onBreakpoint", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, Long.TYPE});
        onNativeMethodBindLiteral = CEntryPointLiteral.create(BreakpointInterceptor.class, (String)"onNativeMethodBind", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, CodePointer.class, WordPointer.class});
        BREAKPOINT_SPECIFICATIONS = new BreakpointSpecification[]{BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", BreakpointInterceptor::forName), BreakpointInterceptor.brk("java/lang/Class", "getFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getFields), BreakpointInterceptor.brk("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethods), BreakpointInterceptor.brk("java/lang/Class", "getConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructors), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredFields", "()[Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredFields), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethods", "()[Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethods), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getDeclaredConstructors), BreakpointInterceptor.brk("java/lang/Class", "getField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getField), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;", BreakpointInterceptor::getDeclaredField), BreakpointInterceptor.brk("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getMethod), BreakpointInterceptor.brk("java/lang/Class", "getConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", BreakpointInterceptor::getDeclaredMethod), BreakpointInterceptor.brk("java/lang/Class", "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getConstructor), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingMethod", "()Ljava/lang/reflect/Method;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "getEnclosingConstructor", "()Ljava/lang/reflect/Constructor;", BreakpointInterceptor::getEnclosingMethod), BreakpointInterceptor.brk("java/lang/Class", "newInstance", "()Ljava/lang/Object;", BreakpointInterceptor::newInstance), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getResources), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResource", "(Ljava/lang/String;)Ljava/net/URL;", BreakpointInterceptor::getSystemResource), BreakpointInterceptor.brk("java/lang/ClassLoader", "getSystemResources", "(Ljava/lang/String;)Ljava/util/Enumeration;", BreakpointInterceptor::getSystemResources), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "getProxyClass", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;)Ljava/lang/Class;", BreakpointInterceptor::getProxyClass), BreakpointInterceptor.brk("java/lang/reflect/Proxy", "newProxyInstance", "(Ljava/lang/ClassLoader;[Ljava/lang/Class;Ljava/lang/reflect/InvocationHandler;)Ljava/lang/Object;", BreakpointInterceptor::newProxyInstance), BreakpointInterceptor.optionalBrk("sun/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", BreakpointInterceptor::objectFieldOffset), BreakpointInterceptor.optionalBrk("jdk/internal/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/reflect/Field;)J", BreakpointInterceptor::objectFieldOffset), BreakpointInterceptor.optionalBrk("jdk/internal/misc/Unsafe", "objectFieldOffset", "(Ljava/lang/Class;Ljava/lang/String;)J", BreakpointInterceptor::objectFieldOffsetByName)};
        NATIVE_BREAKPOINT_SPECIFICATIONS = new NativeBreakpointSpecification[]{NATIVE_OBJECTFIELDOFFSET_BREAKPOINT_SPEC};
    }

    private static final class NativeBreakpoint
    extends AbstractBreakpoint<NativeBreakpointSpecification> {
        CodePointer replacedFunction;

        NativeBreakpoint(NativeBreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
            assert (specification.installed == null) : "must be installed exactly once";
            specification.installed = this;
        }
    }

    private static final class Breakpoint
    extends AbstractBreakpoint<BreakpointSpecification> {
        Breakpoint(BreakpointSpecification specification, JNIObjectHandle clazz, JNIMethodId method) {
            super(specification, clazz, method);
        }
    }

    private static abstract class AbstractBreakpoint<T extends AbstractBreakpointSpecification> {
        final T specification;
        final JNIObjectHandle clazz;
        final JNIMethodId method;

        AbstractBreakpoint(T specification, JNIObjectHandle clazz, JNIMethodId method) {
            this.specification = specification;
            this.clazz = clazz;
            this.method = method;
        }
    }

    private static class NativeBreakpointSpecification
    extends AbstractBreakpointSpecification {
        final CEntryPointLiteral<?> handlerLiteral;
        NativeBreakpoint installed;

        NativeBreakpointSpecification(String className, String methodName, String signature, CEntryPointLiteral<?> handlerLiteral) {
            super(className, methodName, signature, true);
            this.handlerLiteral = handlerLiteral;
        }
    }

    private static class BreakpointSpecification
    extends AbstractBreakpointSpecification {
        final BreakpointHandler handler;

        BreakpointSpecification(String className, String methodName, String signature, BreakpointHandler handler, boolean optional) {
            super(className, methodName, signature, optional);
            this.handler = handler;
        }
    }

    private static abstract class AbstractBreakpointSpecification {
        final String className;
        final String methodName;
        final String signature;
        final boolean optional;

        AbstractBreakpointSpecification(String className, String methodName, String signature, boolean optional) {
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.optional = optional;
        }
    }

    private static interface BreakpointHandler {
        public boolean dispatch(JNIEnvironment var1, JNIObjectHandle var2, Breakpoint var3);
    }

    private static interface ObjectFieldOffsetFunctionPointer
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public long invoke(JNIEnvironment var1, JNIObjectHandle var2, JNIObjectHandle var3);
    }
}

