/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.common.option.CommonOptionParser;
import com.oracle.svm.common.option.UnsupportedOptionClassException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsContainer;
import org.graalvm.collections.EconomicMap;

public final class PointsToOptionParser {
    private static PointsToOptionParser instance = new PointsToOptionParser();
    private OptionValues optionValues = null;
    private EconomicMap<OptionKey<?>, Object> analysisValues = OptionValues.newOptionMap();
    private EconomicMap<String, OptionDescriptor> allAnalysisOptions = EconomicMap.create();

    public static PointsToOptionParser getInstance() {
        return instance;
    }

    private PointsToOptionParser() {
        ClassLoader appClassLoader = PointsToOptionParser.class.getClassLoader();
        Iterable optionDescriptors = OptionsContainer.getDiscoverableOptions((ClassLoader)appClassLoader);
        CommonOptionParser.collectOptions((Iterable)optionDescriptors, descriptor -> {
            OptionDescriptor existing;
            String name = descriptor.getName();
            if (descriptor.getOptionKey() != null && (existing = (OptionDescriptor)this.allAnalysisOptions.put((Object)name, descriptor)) != null) {
                AnalysisError.shouldNotReachHere("Option name \"" + name + "\" has multiple definitions: " + existing.getLocation() + " and " + descriptor.getLocation());
            }
        });
    }

    public OptionValues parse(String[] args) {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        HashSet<String> errors = new HashSet<String>();
        this.analysisValues.clear();
        for (String arg : args) {
            boolean isAnalysisOption = false;
            if (isAnalysisOption |= PointsToOptionParser.parseOption("-H:", this.allAnalysisOptions, this.analysisValues, CommonOptionParser.BooleanOptionFormat.PLUS_MINUS, errors, arg, System.out)) continue;
            remainingArgs.add(arg);
        }
        this.optionValues = new OptionValues(this.analysisValues);
        if (!remainingArgs.isEmpty()) {
            AnalysisError.interruptAnalysis(String.format("Unknown options: %s", Arrays.toString(remainingArgs.toArray(new String[0]))));
        }
        if (!errors.isEmpty()) {
            StringBuilder errMsg = new StringBuilder("Option format error:");
            errMsg.append(System.lineSeparator());
            for (String err : errors) {
                errMsg.append(err).append(System.lineSeparator());
            }
            AnalysisError.interruptAnalysis(errMsg.toString());
        }
        return this.optionValues;
    }

    private static boolean parseOption(String optionPrefix, EconomicMap<String, OptionDescriptor> options, EconomicMap<OptionKey<?>, Object> valuesMap, CommonOptionParser.BooleanOptionFormat booleanOptionFormat, Set<String> errors, String arg, PrintStream out) {
        if (!arg.startsWith(optionPrefix)) {
            return false;
        }
        try {
            Predicate<OptionKey> optionKeyPredicate = optionKey -> {
                Class<?> clazz = optionKey.getClass();
                if (clazz.getName().startsWith("com.oracle.graal.pointsto.api.PointstoOptions")) {
                    return false;
                }
                return !clazz.equals(OptionKey.class) && OptionKey.class.isAssignableFrom(clazz);
            };
            CommonOptionParser.OptionParseResult optionParseResult = CommonOptionParser.parseOption(options, optionKeyPredicate, (String)arg.substring(optionPrefix.length()), valuesMap, (String)optionPrefix, (CommonOptionParser.BooleanOptionFormat)booleanOptionFormat);
            if (optionParseResult.printFlags() || optionParseResult.printFlagsWithExtraHelp()) {
                CommonOptionParser.printFlags(d -> optionParseResult.matchesFlags(d, true), options, (String)optionPrefix, (PrintStream)out, (boolean)optionParseResult.printFlagsWithExtraHelp());
                System.out.println("Abort analysis due to print flags are requested");
                System.exit(1);
            }
            if (!optionParseResult.isValid()) {
                errors.add(optionParseResult.getError());
            }
        }
        catch (UnsupportedOptionClassException e) {
            AnalysisError.shouldNotReachHere(e);
        }
        return true;
    }
}

