/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class AnalysisFuture<V>
extends FutureTask<V> {
    public AnalysisFuture(Callable<V> callable) {
        super(callable);
    }

    public AnalysisFuture(Runnable runnable) {
        super(runnable, null);
    }

    public AnalysisFuture(Runnable runnable, V result) {
        super(runnable, result);
    }

    @Override
    protected void setException(Throwable t) {
        super.setException(t);
        if (t instanceof AnalysisError) {
            AnalysisError ae = (AnalysisError)t;
            throw ae;
        }
        throw new AnalysisError(t);
    }

    public V ensureDone() {
        try {
            this.run();
            return this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw AnalysisError.shouldNotReachHere(e);
        }
    }

    public V guardedGet() {
        try {
            return this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw AnalysisError.shouldNotReachHere(e);
        }
    }
}

