/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;

public final class AnalysisHeapHistogramPrinter
extends ObjectScanner {
    public static void print(BigBang bb, String reportsPath, String reportName) {
        ReportUtils.report("analysis heap histogram", reportsPath, "analysis_heap_histogram_" + reportName, "txt", writer -> AnalysisHeapHistogramPrinter.doPrint(writer, bb));
    }

    private static void doPrint(PrintWriter out, BigBang bb) {
        HashMap<AnalysisType, Integer> histogram = new HashMap<AnalysisType, Integer>();
        AnalysisHeapHistogramPrinter printer = new AnalysisHeapHistogramPrinter(bb, histogram);
        printer.scanBootImageHeapRoots(ReportUtils.fieldComparator, ReportUtils.reasonComparator);
        AnalysisHeapHistogramPrinter.printHistogram(out, histogram);
    }

    private static void printHistogram(PrintWriter out, Map<AnalysisType, Integer> histogram) {
        out.println("Heap histogram");
        out.format("%8s %s %n", "Count", "Class");
        histogram.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> out.format("%8d %8s %n", entry.getValue(), ((AnalysisType)entry.getKey()).toJavaName()));
    }

    private AnalysisHeapHistogramPrinter(BigBang bb, Map<AnalysisType, Integer> histogram) {
        super(bb, null, new ObjectScanner.ReusableSet(), new ScanningObserver(bb, histogram));
    }

    private static final class ScanningObserver
    implements ObjectScanningObserver {
        private final BigBang bb;
        private final Map<AnalysisType, Integer> histogram;

        private ScanningObserver(BigBang bb, Map<AnalysisType, Integer> histogram) {
            this.bb = bb;
            this.histogram = histogram;
        }

        @Override
        public void forScannedConstant(JavaConstant scannedValue, ObjectScanner.ScanReason reason) {
            AnalysisType type = ObjectScanner.constantType(this.bb, scannedValue);
            int count = this.histogram.getOrDefault(type, 0);
            this.histogram.put(type, count + 1);
        }

        @Override
        public boolean forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            return false;
        }

        @Override
        public boolean forNullFieldValue(JavaConstant receiver, AnalysisField field, ObjectScanner.ScanReason reason) {
            return false;
        }

        @Override
        public boolean forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
            return false;
        }

        @Override
        public boolean forNullArrayElement(JavaConstant array, AnalysisType arrayType, int index, ObjectScanner.ScanReason reason) {
            return false;
        }

        @Override
        public boolean forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int index, ObjectScanner.ScanReason reason) {
            return false;
        }
    }
}

