/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.vm.ci.meta.JavaConstant;

public class ImageHeap {
    private final ConcurrentHashMap<JavaConstant, Object> objectsCache = new ConcurrentHashMap();
    private final Map<AnalysisType, Set<ImageHeapConstant>> reachableObjects = new ConcurrentHashMap<AnalysisType, Set<ImageHeapConstant>>();

    public Object getSnapshot(JavaConstant constant) {
        JavaConstant uncompressed = CompressibleConstant.uncompress((JavaConstant)constant);
        if (uncompressed instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)uncompressed;
            assert (imageHeapConstant.getHostedObject() == null || imageHeapConstant.isInBaseLayer() || this.objectsCache.get(imageHeapConstant.getHostedObject()).equals(imageHeapConstant));
            return imageHeapConstant;
        }
        return this.objectsCache.get(uncompressed);
    }

    public Object setTask(JavaConstant constant, AnalysisFuture<ImageHeapConstant> task) {
        assert (!(constant instanceof ImageHeapConstant)) : constant;
        return this.objectsCache.putIfAbsent(CompressibleConstant.uncompress((JavaConstant)constant), task);
    }

    public void setValue(JavaConstant constant, ImageHeapConstant value) {
        assert (!(constant instanceof ImageHeapConstant)) : constant;
        Object previous = this.objectsCache.put(CompressibleConstant.uncompress((JavaConstant)constant), value);
        AnalysisError.guarantee(!(previous instanceof ImageHeapConstant) || previous == value, "An ImageHeapConstant: %s is already registered for hosted JavaConstant: %s.", previous, constant);
    }

    public Set<ImageHeapConstant> getReachableObjects(AnalysisType type) {
        return this.reachableObjects.getOrDefault(type, Collections.emptySet());
    }

    public Map<AnalysisType, Set<ImageHeapConstant>> getReachableObjects() {
        return this.reachableObjects;
    }

    public boolean addReachableObject(AnalysisType type, ImageHeapConstant heapObj) {
        assert (heapObj.isReachable()) : heapObj;
        Set objectSet = this.reachableObjects.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet());
        return objectSet.add(heapObj);
    }
}

