/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.PrimitiveComparison;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public abstract class PrimitiveFilterTypeFlow
extends TypeFlow<BytecodePosition> {
    protected final TypeFlow<?> left;
    protected final PrimitiveComparison comparison;
    protected final boolean isUnsigned;

    private PrimitiveFilterTypeFlow(BytecodePosition position, AnalysisType declaredType, TypeFlow<?> left, PrimitiveComparison comparison, boolean isUnsigned) {
        super(position, declaredType);
        this.left = left;
        this.comparison = comparison;
        this.isUnsigned = isUnsigned;
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        this.addState(bb, TypeState.forEmpty());
    }

    public abstract TypeState getRightState(PointsToAnalysis var1);

    @Override
    protected TypeState processInputState(PointsToAnalysis bb, TypeState newState) {
        TypeState leftState = this.left.getOutputState(bb);
        TypeState rightState = this.getRightState(bb);
        assert (leftState.isPrimitive() || leftState.isEmpty()) : this.left;
        assert (rightState.isPrimitive() || rightState.isEmpty()) : this;
        return TypeState.filter(leftState, this.comparison, rightState, this.isUnsigned);
    }

    public PrimitiveComparison getComparison() {
        return this.comparison;
    }

    public TypeFlow<?> getLeft() {
        return this.left;
    }

    public static class VariableFilter
    extends PrimitiveFilterTypeFlow {
        private final TypeFlow<?> right;

        public VariableFilter(BytecodePosition position, AnalysisType declaredType, TypeFlow<?> left, TypeFlow<?> right, PrimitiveComparison comparison, boolean isUnsigned) {
            super(position, declaredType, left, comparison, isUnsigned);
            this.right = right;
        }

        @Override
        public TypeState getRightState(PointsToAnalysis bb) {
            return this.right.getOutputState(bb);
        }
    }

    public static class ConstantFilter
    extends PrimitiveFilterTypeFlow {
        private final TypeState rightState;

        public ConstantFilter(BytecodePosition position, AnalysisType declaredType, TypeFlow<?> left, TypeState rightState, PrimitiveComparison comparison, boolean isUnsigned) {
            super(position, declaredType, left, comparison, isUnsigned);
            this.rightState = rightState;
        }

        @Override
        public TypeState getRightState(PointsToAnalysis bb) {
            return this.rightState;
        }
    }
}

