/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaKind;

public class FormalReturnTypeFlow
extends TypeFlow<BytecodePosition> {
    public FormalReturnTypeFlow(BytecodePosition source, AnalysisType declaredType) {
        super(source, FormalReturnTypeFlow.filterUncheckedInterface(declaredType));
    }

    public FormalReturnTypeFlow(FormalReturnTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
    }

    @Override
    protected TypeState processInputState(PointsToAnalysis bb, TypeState newState) {
        if (this.declaredType.getJavaKind() == JavaKind.Void) {
            return newState.isEmpty() ? TypeState.forEmpty() : TypeState.anyPrimitiveState();
        }
        return this.declaredTypeFilter(bb, newState, false);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new FormalReturnTypeFlow(this, methodFlows);
    }

    @Override
    public String format(boolean withState, boolean withSource) {
        return "Formal return from " + this.method().format("%H.%n(%p)") + (String)(withSource ? " at " + this.formatSource() : "") + (String)(withState ? " with state <" + this.getStateDescription() + ">" : "");
    }
}

