/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.graal.pointsto.infrastructure.ConstantPoolPatch;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.BootstrapMethodIntrospection;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.serviceprovider.BootstrapMethodIntrospectionImpl;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WrappedConstantPool
implements ConstantPool,
ConstantPoolPatch {
    protected final Universe universe;
    protected final ConstantPool wrapped;
    private final ResolvedJavaType defaultAccessingClass;
    private static final Method cpLookupBootstrapMethodInvocation = ReflectionUtil.lookupMethod((boolean)true, ConstantPool.class, (String)"lookupBootstrapMethodInvocation", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
    private static final Method lookupMethodWithCaller = ReflectionUtil.lookupMethod((boolean)true, ConstantPool.class, (String)"lookupMethod", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, ResolvedJavaMethod.class});

    public WrappedConstantPool(Universe universe, ConstantPool wrapped, ResolvedJavaType defaultAccessingClass) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.defaultAccessingClass = defaultAccessingClass;
    }

    public int length() {
        return this.wrapped.length();
    }

    private JavaConstant lookupConstant(JavaConstant constant) {
        return this.universe.lookup(this.extractResolvedType(constant));
    }

    public JavaConstant extractResolvedType(JavaConstant constant) {
        SnippetReflectionProvider snippetReflection;
        Object object;
        if (constant != null && constant.getJavaKind().isObject() && !constant.isNull() && (object = (snippetReflection = GraalAccess.getOriginalSnippetReflection()).asObject(Object.class, constant)) instanceof ResolvedJavaType) {
            ResolvedJavaType resolvedJavaType = (ResolvedJavaType)object;
            return snippetReflection.forObject(OriginalClassProvider.getJavaClass((JavaType)resolvedJavaType));
        }
        return constant;
    }

    public void loadReferencedType(int cpi, int opcode, boolean initialize) {
        GraalError.guarantee((!initialize ? 1 : 0) != 0, (String)"Must not initialize classes");
        try {
            this.wrapped.loadReferencedType(cpi, opcode, initialize);
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (cause instanceof BootstrapMethodError && cause.getCause() != null) {
                cause = cause.getCause();
            } else if (cause instanceof ExceptionInInitializerError && cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public void loadReferencedType(int cpi, int opcode) {
        this.loadReferencedType(cpi, opcode, false);
    }

    public JavaField lookupField(int cpi, ResolvedJavaMethod method, int opcode) {
        ResolvedJavaMethod substMethod = this.universe.resolveSubstitution(((WrappedJavaMethod)method).getWrapped());
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupField(cpi, substMethod, opcode));
    }

    public JavaMethod lookupMethod(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupMethod(cpi, opcode));
    }

    @Override
    public JavaMethod lookupMethod(int cpi, int opcode, ResolvedJavaMethod caller) {
        if (lookupMethodWithCaller == null) {
            return this.lookupMethod(cpi, opcode);
        }
        try {
            ResolvedJavaMethod substCaller = this.universe.resolveSubstitution(((WrappedJavaMethod)caller).getWrapped());
            return this.universe.lookupAllowUnresolved((JavaMethod)lookupMethodWithCaller.invoke((Object)this.wrapped, cpi, opcode, substCaller));
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                cause = ex.getCause();
            } else if (ex instanceof ExceptionInInitializerError && ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public JavaType lookupType(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupType(cpi, opcode));
    }

    public ResolvedSignature<?> lookupSignature(int cpi) {
        return this.universe.lookup(this.wrapped.lookupSignature(cpi), this.defaultAccessingClass);
    }

    public JavaConstant lookupAppendix(int cpi, int opcode) {
        return this.lookupConstant(this.wrapped.lookupAppendix(cpi, opcode));
    }

    public String lookupUtf8(int cpi) {
        return this.wrapped.lookupUtf8(cpi);
    }

    public Object lookupConstant(int cpi) {
        return this.lookupConstant(cpi, true);
    }

    @Override
    public Object lookupConstant(int cpi, boolean resolve) {
        Object con = GraalServices.lookupConstant((ConstantPool)this.wrapped, (int)cpi, (boolean)resolve);
        if (con instanceof JavaType) {
            if (con instanceof ResolvedJavaType) {
                return this.universe.lookup((JavaType)((ResolvedJavaType)con));
            }
            return con;
        }
        if (con instanceof JavaConstant) {
            return this.lookupConstant((JavaConstant)con);
        }
        if (con == null && !resolve) {
            return null;
        }
        throw JVMCIError.unimplemented();
    }

    public JavaType lookupReferencedType(int index, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupReferencedType(index, opcode));
    }

    public BootstrapMethodIntrospection lookupBootstrapMethodIntrospection(int cpi, int opcode) {
        if (cpLookupBootstrapMethodInvocation != null) {
            try {
                Object bootstrapMethodInvocation = cpLookupBootstrapMethodInvocation.invoke((Object)this.wrapped, cpi, opcode);
                if (bootstrapMethodInvocation != null) {
                    return new WrappedBootstrapMethodInvocation(bootstrapMethodInvocation);
                }
            }
            catch (InvocationTargetException ex) {
                throw WrappedConstantPool.rethrow(ex.getCause());
            }
            catch (IllegalAccessException e) {
                throw GraalError.shouldNotReachHere((Throwable)e, (String)"The method lookupBootstrapMethodInvocation should be accessible.");
            }
        }
        return null;
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public class WrappedBootstrapMethodInvocation
    extends BootstrapMethodIntrospectionImpl {
        public WrappedBootstrapMethodInvocation(Object wrapped) {
            super(wrapped);
        }

        public ResolvedJavaMethod getMethod() {
            return WrappedConstantPool.this.universe.lookup((JavaMethod)super.getMethod());
        }

        public JavaConstant getType() {
            return WrappedConstantPool.this.lookupConstant(super.getType());
        }

        public List<JavaConstant> getStaticArguments() {
            return super.getStaticArguments().stream().map(WrappedConstantPool.this::lookupConstant).collect(Collectors.toList());
        }
    }
}

