/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

public final class ImageHeapObjectArray
extends ImageHeapArray {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    private static final VarHandle elementsHandle = ReflectionUtil.unreflectField(ArrayData.class, (String)"arrayElementValues", (MethodHandles.Lookup)MethodHandles.lookup());

    ImageHeapObjectArray(AnalysisType type, JavaConstant object, int length) {
        super(new ArrayData(type, object, ImageHeapObjectArray.createIdentityHashCode(object), length), false);
    }

    ImageHeapObjectArray(AnalysisType type, int length) {
        this(type, null, new Object[length], length);
    }

    ImageHeapObjectArray(AnalysisType type, JavaConstant object, Object[] arrayElementValues, int length) {
        this(type, object, ImageHeapObjectArray.createIdentityHashCode(object), arrayElementValues, length, false);
    }

    private ImageHeapObjectArray(AnalysisType type, JavaConstant object, int identityHashCode, Object[] arrayElementValues, int length, boolean compressed) {
        super(new ArrayData(type, object, identityHashCode, arrayElementValues, length), compressed);
    }

    ImageHeapObjectArray(ImageHeapConstant.ConstantData data, boolean compressed) {
        super(data, compressed);
    }

    @Override
    public ArrayData getConstantData() {
        return (ArrayData)super.getConstantData();
    }

    void setElementValues(Object[] elementValues) {
        boolean success = elementsHandle.compareAndSet(this.constantData, null, elementValues);
        AnalysisError.guarantee(success, "Unexpected field values reference for constant %s", this);
    }

    private Object[] getElementValues() {
        AnalysisError.guarantee(this.isReaderInstalled());
        Object[] arrayElements = this.getConstantData().arrayElementValues;
        AnalysisError.guarantee(arrayElements != null);
        return arrayElements;
    }

    @Override
    public Object getElement(int idx) {
        return arrayHandle.getVolatile(this.getElementValues(), idx);
    }

    @Override
    public JavaConstant readElementValue(int index) {
        Object value = this.getElement(index);
        return value instanceof JavaConstant ? (JavaConstant)value : (JavaConstant)((AnalysisFuture)value).ensureDone();
    }

    @Override
    public void setElement(int idx, JavaConstant value) {
        arrayHandle.setVolatile(this.getElementValues(), idx, value);
    }

    void setElementTask(int idx, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.getElementValues(), idx, task);
    }

    @Override
    public int getLength() {
        return this.getConstantData().length;
    }

    public JavaConstant compress() {
        assert (!this.compressed) : this;
        return new ImageHeapObjectArray(this.constantData, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed) : this;
        return new ImageHeapObjectArray(this.constantData, false);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        assert (this.constantData.type.isCloneableWithAllocation()) : "all arrays implement Cloneable";
        Object[] arrayElements = this.getElementValues();
        Objects.requireNonNull(arrayElements, "Cannot clone an array before the element values are set.");
        Object[] newArrayElementValues = Arrays.copyOf(arrayElements, arrayElements.length);
        JavaConstant newObject = null;
        return new ImageHeapObjectArray(this.constantData.type, newObject, ImageHeapObjectArray.createIdentityHashCode(newObject), newArrayElementValues, arrayElements.length, this.compressed);
    }

    public static class ArrayData
    extends ImageHeapConstant.ConstantData {
        private Object[] arrayElementValues;
        final int length;

        public ArrayData(AnalysisType type, JavaConstant object, int identityHashCode, int length) {
            super(type, object, identityHashCode);
            this.length = length;
        }

        public ArrayData(AnalysisType type, JavaConstant object, int identityHashCode, Object[] arrayElementValues, int length) {
            super(type, object, identityHashCode);
            this.arrayElementValues = arrayElementValues;
            this.length = length;
        }
    }
}

