/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapPrimitiveArray;
import com.oracle.graal.pointsto.meta.AnalysisType;
import jdk.vm.ci.meta.JavaConstant;

public abstract class ImageHeapArray
extends ImageHeapConstant {
    public static ImageHeapArray create(AnalysisType type, int length) {
        assert (type.isArray()) : type;
        return type.getComponentType().getStorageKind().isPrimitive() ? new ImageHeapPrimitiveArray(type, length) : new ImageHeapObjectArray(type, length);
    }

    protected ImageHeapArray(ImageHeapConstant.ConstantData constantData, boolean compressed) {
        super(constantData, compressed);
        assert (constantData.type.isArray()) : constantData.type;
    }

    public abstract Object getElement(int var1);

    public abstract JavaConstant readElementValue(int var1);

    public abstract void setElement(int var1, JavaConstant var2);

    public abstract int getLength();
}

