/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnsafeWriteSinkTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestore.ArrayElementsTypeStore;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class AnalysisObject
implements Comparable<AnalysisObject> {
    public static final Comparator<AnalysisObject> objectsTypeComparator = Comparator.comparingInt(o -> o.getTypeId());
    public static final AnalysisObject[] EMPTY_ARRAY = new AnalysisObject[0];
    private static final AtomicInteger nextObjectId = new AtomicInteger();
    protected final long id;
    protected final AnalysisType type;
    protected final AnalysisObjectKind kind;
    protected volatile boolean merged;
    private static final AtomicReferenceFieldUpdater<AnalysisObject, AtomicReferenceArray> INSTANCE_FIELD_TYPE_STORE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisObject.class, AtomicReferenceArray.class, "instanceFieldsTypeStore");
    protected final ArrayElementsTypeStore arrayElementsTypeStore;
    protected volatile AtomicReferenceArray<FieldTypeStore> instanceFieldsTypeStore;

    public AnalysisObject(AnalysisUniverse universe, AnalysisType type) {
        this(universe, type, AnalysisObjectKind.ContextInsensitive);
    }

    protected AnalysisObject(AnalysisUniverse universe, AnalysisType type, AnalysisObjectKind kind) {
        this.id = AnalysisObject.createId(type.getId());
        this.type = type;
        this.kind = kind;
        this.merged = false;
        this.arrayElementsTypeStore = universe.analysisPolicy().createArrayElementsTypeStore(this, universe);
    }

    private static long createId(int typeId) {
        long resultId = typeId;
        long objectId = nextObjectId.incrementAndGet();
        resultId = resultId << 32 ^ objectId;
        return resultId;
    }

    public int getTypeId() {
        return (int)(this.id >> 32);
    }

    public AnalysisType type() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public void noteMerge(PointsToAnalysis bb) {
        this.merged = true;
    }

    public String prefix() {
        return this.kind.prefix;
    }

    public final boolean isContextInsensitiveObject() {
        return this.kind == AnalysisObjectKind.ContextInsensitive;
    }

    public final boolean isAllocationContextSensitiveObject() {
        return this.kind == AnalysisObjectKind.AllocationContextSensitive;
    }

    public JavaConstant asConstant() {
        return null;
    }

    public ArrayElementsTypeStore getArrayElementsTypeStore() {
        return this.arrayElementsTypeStore;
    }

    public ArrayElementsTypeFlow getArrayElementsFlow(PointsToAnalysis bb, boolean isStore) {
        assert (this.isObjectArray()) : this;
        this.arrayElementsTypeStore.init(bb);
        return isStore ? this.arrayElementsTypeStore.writeFlow() : this.arrayElementsTypeStore.readFlow();
    }

    public FieldFilterTypeFlow getInstanceFieldFilterFlow(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers()) && field.isUnsafeAccessed()) : field;
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, objectFlow, context, field);
        return fieldTypeStore.writeFlow().filterFlow(bb);
    }

    public UnsafeWriteSinkTypeFlow getUnsafeWriteSinkFrozenFilterFlow(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers()) && field.hasUnsafeFrozenTypeState()) : field;
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, objectFlow, context, field);
        return fieldTypeStore.unsafeWriteSinkFlow(bb);
    }

    public FieldTypeFlow getInstanceFieldFlow(PointsToAnalysis bb, AnalysisField field, boolean isStore) {
        return this.getInstanceFieldFlow(bb, null, null, field, isStore);
    }

    public FieldTypeFlow getInstanceFieldFlow(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field, boolean isStore) {
        assert (!Modifier.isStatic(field.getModifiers())) : field;
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, objectFlow, context, field);
        return isStore ? fieldTypeStore.writeFlow() : fieldTypeStore.readFlow();
    }

    final FieldTypeStore getInstanceFieldTypeStore(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers())) : field;
        assert (bb != null && !bb.getUniverse().sealed()) : "universe is sealed";
        this.checkField(bb, objectFlow, context, field);
        if (this.instanceFieldsTypeStore == null) {
            INSTANCE_FIELD_TYPE_STORE_UPDATER.compareAndSet(this, null, new AtomicReferenceArray(this.type.getInstanceFields(true).length));
        }
        AnalysisError.guarantee(field.getPosition() >= 0 && field.getPosition() < this.instanceFieldsTypeStore.length(), "Field %s.%s has invalid position %d.", field.getDeclaringClass().toJavaName(), field.getName(), field.getPosition());
        FieldTypeStore fieldStore = this.instanceFieldsTypeStore.get(field.getPosition());
        if (fieldStore == null) {
            fieldStore = bb.analysisPolicy().createFieldTypeStore(bb, this, field, bb.getUniverse());
            boolean result = this.instanceFieldsTypeStore.compareAndSet(field.getPosition(), null, fieldStore);
            if (result) {
                fieldStore.init(bb);
                this.linkFieldFlows(bb, field, fieldStore);
            } else {
                fieldStore = this.instanceFieldsTypeStore.get(field.getPosition());
            }
        }
        return fieldStore;
    }

    private void checkField(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field) {
        if (!field.getDeclaringClass().getAssignableTypes(false).containsType(this.type)) {
            throw AnalysisError.fieldNotPresentError(bb, objectFlow, context, field, this.type);
        }
    }

    protected void linkFieldFlows(PointsToAnalysis bb, AnalysisField field, FieldTypeStore fieldStore) {
        field.getInitialInstanceFieldFlow().addUse(bb, fieldStore.writeFlow());
        fieldStore.readFlow().addUse(bb, field.getInstanceFieldFlow());
    }

    public boolean isEmptyObjectArrayConstant(PointsToAnalysis bb) {
        return false;
    }

    public boolean isPrimitiveArray() {
        return this.type().isArray() && this.type().getComponentType().getJavaKind() != JavaKind.Object;
    }

    public boolean isObjectArray() {
        return this.type().isArray() && this.type().getComponentType().getJavaKind() == JavaKind.Object;
    }

    public static boolean isEmptyObjectArrayConstant(PointsToAnalysis bb, JavaConstant constant) {
        assert (constant.getJavaKind() == JavaKind.Object) : constant;
        Integer length = bb.getConstantReflectionProvider().readArrayLength(constant);
        return length != null && length == 0;
    }

    public String toString() {
        return String.format("0x%016X", this.id) + ":" + this.kind.prefix + ":" + (this.merged ? "M" : "") + ":" + (this.type != null ? this.type.toJavaName(false) : "");
    }

    @Override
    public int compareTo(AnalysisObject other) {
        return Long.compare(this.getId(), other.getId());
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return (int)(this.id & 0xFFFFFFFFFFFFFFFFL);
    }

    protected static enum AnalysisObjectKind {
        ContextInsensitive("!S"),
        ConstantObject("C"),
        AllocationContextSensitive("AS"),
        ConstantContextSensitive("CS");

        protected final String prefix;

        private AnalysisObjectKind(String prefix) {
            this.prefix = prefix;
        }
    }
}

