/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.api;

import jdk.graal.compiler.options.OptionKey;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.collections.EconomicMap;

public class PointstoOptions {
    public static final OptionKey<Boolean> TrackPrimitiveValues = new OptionKey((Object)false);
    public static final OptionKey<Boolean> UseExperimentalReachabilityAnalysis = new OptionKey((Object)false);
    public static final OptionKey<Boolean> UseReachabilityMethodSummaries = new OptionKey((Object)false);
    public static final OptionKey<Boolean> HybridStaticContext = new OptionKey((Object)false);
    public static final OptionKey<Boolean> AllocationSiteSensitiveHeap = new OptionKey((Object)false);
    public static final OptionKey<Integer> MinHeapContextDepth = new OptionKey((Object)0);
    public static final OptionKey<Integer> MaxHeapContextDepth = new OptionKey((Object)0);
    public static final OptionKey<Integer> MaxHeapContextWidth = new OptionKey((Object)0);
    public static final OptionKey<Integer> MinCallingContextDepth = new OptionKey((Object)0);
    public static final OptionKey<Integer> MaxCallingContextDepth = new OptionKey((Object)0);
    public static final OptionKey<Integer> MaxCallingContextWidth = new OptionKey((Object)0);
    public static final OptionKey<Boolean> LimitObjectArrayLength = new OptionKey((Object)false);
    public static final OptionKey<Integer> MaxObjectSetSize = new OptionKey((Object)100);
    public static final OptionKey<Integer> MaxConstantObjectsPerType = new OptionKey((Object)0);
    public static final OptionKey<Boolean> ProfileAnalysisOperations = new OptionKey((Object)false);
    public static final OptionKey<Boolean> ProfileConstantObjects = new OptionKey((Object)false);
    public static final OptionKey<Boolean> PrintSynchronizedAnalysis = new OptionKey((Object)false);
    public static final OptionKey<Boolean> OptimizeReturnedParameter = new OptionKey((Object)true);
    public static final OptionKey<Boolean> ExtendedAsserts = new OptionKey((Object)false);
    public static final OptionKey<Boolean> TrackAccessChain = new OptionKey((Object)false);
    public static final OptionKey<Integer> ParsingContextMaxDepth = new OptionKey((Object)100);
    public static final OptionKey<Boolean> TrackInputFlows = new OptionKey((Object)false);
    public static final OptionKey<Integer> AnalysisSizeCutoff = new OptionKey((Object)8);
    public static final OptionKey<Integer> TypeFlowSaturationCutoff = new OptionKey((Object)20);
    public static final OptionKey<Boolean> RemoveSaturatedTypeFlows = new OptionKey<Boolean>(Boolean.valueOf(true)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                AliasArrayTypeFlows.update(values, (Object)true);
            }
        }
    };
    public static final OptionKey<Boolean> AliasArrayTypeFlows = new OptionKey<Boolean>(Boolean.valueOf(true)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                RelaxTypeFlowStateConstraints.update(values, (Object)true);
            }
        }
    };
    public static final OptionKey<Boolean> RelaxTypeFlowStateConstraints = new OptionKey((Object)true);
    static final OptionKey<Boolean> UnresolvedIsError = new OptionKey((Object)true);
    public static final OptionKey<Boolean> PrintPointsToStatistics = new OptionKey((Object)false);
    public static final OptionKey<String> InspectServerContentPath = new OptionKey((Object)"inspect");
    public static final OptionKey<Boolean> ScanObjectsParallel = new OptionKey((Object)true);
    public static final OptionKey<Boolean> EscapeAnalysisBeforeAnalysis = new OptionKey((Object)true);
    public static final OptionKey<Boolean> ConditionalEliminationBeforeAnalysis = new OptionKey((Object)true);
    public static final OptionKey<String> AnalysisContextSensitivity = new OptionKey<String>("insens"){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
            switch (newValue.toLowerCase()) {
                case "insens": {
                    AllocationSiteSensitiveHeap.update(values, (Object)false);
                    MinHeapContextDepth.update(values, (Object)0);
                    MaxHeapContextDepth.update(values, (Object)0);
                    MinCallingContextDepth.update(values, (Object)0);
                    MaxCallingContextDepth.update(values, (Object)0);
                    break;
                }
                case "allocsens": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)0);
                    MaxHeapContextDepth.update(values, (Object)0);
                    MinCallingContextDepth.update(values, (Object)0);
                    MaxCallingContextDepth.update(values, (Object)0);
                    break;
                }
                case "_1obj": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)0);
                    MaxHeapContextDepth.update(values, (Object)0);
                    MinCallingContextDepth.update(values, (Object)1);
                    MaxCallingContextDepth.update(values, (Object)1);
                    break;
                }
                case "_2obj1h": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)1);
                    MaxHeapContextDepth.update(values, (Object)1);
                    MinCallingContextDepth.update(values, (Object)2);
                    MaxCallingContextDepth.update(values, (Object)2);
                    break;
                }
                case "_3obj2h": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)2);
                    MaxHeapContextDepth.update(values, (Object)2);
                    MinCallingContextDepth.update(values, (Object)3);
                    MaxCallingContextDepth.update(values, (Object)3);
                    break;
                }
                case "_4obj3h": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)3);
                    MaxHeapContextDepth.update(values, (Object)3);
                    MinCallingContextDepth.update(values, (Object)4);
                    MaxCallingContextDepth.update(values, (Object)4);
                    break;
                }
                default: {
                    throw JVMCIError.shouldNotReachHere((String)("Unknown context sensitivity setting:" + newValue));
                }
            }
        }
    };

    public static enum ContextSensitivity {
        insens("insens"),
        allocsens("allocsens"),
        _1obj("_1obj"),
        _2obj1h("_2obj1h"),
        _3obj2h("_3obj2h"),
        _4obj3h("_4obj3h");

        private String value;

        private ContextSensitivity(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

