/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.LightImmutableCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.code.BytecodePosition;

final class BytecodeSensitiveSpecialInvokeTypeFlow
extends AbstractSpecialInvokeTypeFlow {
    private final Set<MethodFlowsGraph> calleesFlows = new ConcurrentHashMap(4, 0.75f, 1).keySet(Boolean.TRUE);
    private AnalysisContext callerContext;

    BytecodeSensitiveSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
    }

    private BytecodeSensitiveSpecialInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveSpecialInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callerContext = ((MethodFlowsGraphClone)methodFlows).context();
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BytecodeSensitiveSpecialInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        TypeState receiverState = this.filterReceiverState(bb, this.getReceiver().getState());
        if (this.seenReceiverTypes.equals(receiverState)) {
            return;
        }
        this.seenReceiverTypes = receiverState;
        if (receiverState.isNull()) {
            return;
        }
        this.initializeCallees(bb);
        for (AnalysisObject receiverObject : receiverState.objects(bb)) {
            LightImmutableCollection.forEach(this, CALLEES_ACCESSOR, callee -> {
                BytecodeAnalysisContext calleeContext;
                CallSiteSensitiveMethodTypeFlow calleeTypeFlow = (CallSiteSensitiveMethodTypeFlow)callee.getTypeFlow();
                MethodFlowsGraphInfo calleeFlows = calleeTypeFlow.addContext(bb, calleeContext = BytecodeSensitiveAnalysisPolicy.contextPolicy(bb).calleeContext(bb, receiverObject, (BytecodeAnalysisContext)this.callerContext, (MethodTypeFlow)calleeTypeFlow), this);
                if (this.calleesFlows.add((MethodFlowsGraph)calleeFlows)) {
                    this.linkCallee(bb, false, calleeFlows);
                }
                this.updateReceiver(bb, calleeFlows, receiverObject);
            });
        }
    }

    @Override
    protected Collection<MethodFlowsGraph> getAllCalleesFlows(PointsToAnalysis bb) {
        return this.calleesFlows;
    }
}

