/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import java.util.Arrays;
import jdk.vm.ci.code.BytecodePosition;

public final class BytecodeAnalysisContext
extends AnalysisContext {
    public static final BytecodePosition[] emptyLabelList = new BytecodePosition[0];
    protected final BytecodePosition[] labels;

    protected BytecodeAnalysisContext(BytecodePosition[] labelList) {
        this.labels = labelList;
    }

    public int getLength() {
        return this.labels.length;
    }

    public BytecodePosition[] labels() {
        return this.labels;
    }

    @Override
    protected boolean valueEquals(AnalysisContext obj) {
        if (obj instanceof BytecodeAnalysisContext) {
            BytecodeAnalysisContext that = (BytecodeAnalysisContext)obj;
            return Arrays.equals(this.labels, that.labels);
        }
        return false;
    }

    @Override
    protected int valueHashCode() {
        int result = 42;
        for (BytecodePosition l : this.labels) {
            result ^= l.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String separator = " ";
        for (BytecodePosition bytecode : this.labels) {
            result.append(separator).append(bytecode);
            separator = "\t";
        }
        return result.toString();
    }
}

