/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.word.WordBase;

public class ObjectScanner {
    private static final String INDENTATION_AFTER_NEWLINE = "    ";
    protected final BigBang bb;
    private final ReusableSet scannedObjects;
    private final CompletionExecutor executor;
    private final Deque<WorklistEntry> worklist;
    private final ObjectScanningObserver scanningObserver;
    static final String indent = "  ";

    public ObjectScanner(BigBang bb, CompletionExecutor executor, ReusableSet scannedObjects, ObjectScanningObserver scanningObserver) {
        this.bb = bb;
        this.scanningObserver = scanningObserver;
        if (executor != null) {
            this.executor = executor;
            this.worklist = null;
        } else {
            this.executor = null;
            this.worklist = new ConcurrentLinkedDeque<WorklistEntry>();
        }
        this.scannedObjects = scannedObjects;
    }

    public void scanBootImageHeapRoots() {
        this.scanBootImageHeapRoots(null, null);
    }

    public void scanBootImageHeapRoots(Comparator<AnalysisField> fieldComparator, Comparator<BytecodePosition> embeddedRootComparator) {
        Object fieldsList;
        Object fields = this.bb.getUniverse().getFields();
        if (fieldComparator != null) {
            fieldsList = new ArrayList<AnalysisField>((Collection<AnalysisField>)fields);
            ((ArrayList)fieldsList).sort(fieldComparator);
            fields = fieldsList;
        }
        fieldsList = fields.iterator();
        while (fieldsList.hasNext()) {
            AnalysisField field = (AnalysisField)fieldsList.next();
            if (!Modifier.isStatic(field.getModifiers()) || field.getJavaKind() != JavaKind.Object || !field.isRead()) continue;
            this.execute(() -> this.scanRootField(field));
        }
        Map<JavaConstant, BytecodePosition> embeddedRoots = this.bb.getUniverse().getEmbeddedRoots();
        if (embeddedRootComparator != null) {
            embeddedRoots.entrySet().stream().sorted(Map.Entry.comparingByValue(embeddedRootComparator)).forEach(entry -> this.execute(() -> this.scanEmbeddedRoot((JavaConstant)entry.getKey(), (BytecodePosition)entry.getValue())));
        } else {
            embeddedRoots.forEach((key, value) -> this.execute(() -> this.scanEmbeddedRoot((JavaConstant)key, (BytecodePosition)value)));
        }
        this.finish();
    }

    private void execute(Runnable runnable) {
        if (this.executor != null) {
            this.executor.execute((DebugContext debug) -> runnable.run());
        } else {
            runnable.run();
        }
    }

    protected void scanEmbeddedRoot(JavaConstant root, BytecodePosition position) {
        try {
            EmbeddedRootScan reason = new EmbeddedRootScan(position, root);
            this.scanningObserver.forEmbeddedRoot(root, reason);
            this.scanConstant(root, reason);
        }
        catch (UnsupportedFeatureException ex) {
            AnalysisMethod method = (AnalysisMethod)position.getMethod();
            this.bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, ex.getMessage(), null, ex);
        }
    }

    protected final void scanRootField(AnalysisField field) {
        this.scanField(field, null, null);
    }

    protected void scanField(AnalysisField field, JavaConstant receiver, ScanReason prevReason) {
        FieldScan reason = new FieldScan(field, receiver, prevReason);
        try {
            if (!this.bb.getUniverse().getHeapScanner().isValueAvailable(field)) {
                return;
            }
            JavaConstant fieldValue = this.bb.getUniverse().getHeapScanner().readFieldValue(field, receiver);
            if (fieldValue == null) {
                StringBuilder backtrace = new StringBuilder();
                ObjectScanner.buildObjectBacktrace(this.bb, reason, backtrace);
                throw AnalysisError.shouldNotReachHere("Could not find field " + field.format("%H.%n") + (String)(receiver == null ? "" : " on " + ObjectScanner.constantType(this.bb, receiver).toJavaName()) + System.lineSeparator() + backtrace);
            }
            if (fieldValue.getJavaKind() == JavaKind.Object && this.bb.getHostVM().isRelocatedPointer(this.bb.getMetaAccess(), fieldValue)) {
                this.scanningObserver.forRelocatedPointerFieldValue(receiver, field, fieldValue, reason);
            } else if (fieldValue.isNull()) {
                this.scanningObserver.forNullFieldValue(receiver, field, reason);
            } else if (fieldValue.getJavaKind() == JavaKind.Object) {
                this.scanningObserver.forNonNullFieldValue(receiver, field, fieldValue, reason);
                this.scanConstant(fieldValue, reason);
            }
        }
        catch (UnsupportedFeatureException ex) {
            ObjectScanner.unsupportedFeatureDuringFieldScan(this.bb, field, receiver, ex, reason);
        }
        catch (AnalysisError analysisError) {
            Throwable throwable = analysisError.getCause();
            if (throwable instanceof UnsupportedFeatureException) {
                UnsupportedFeatureException ex = (UnsupportedFeatureException)throwable;
                ObjectScanner.unsupportedFeatureDuringFieldScan(this.bb, field, receiver, ex, reason);
            }
            throw analysisError;
        }
    }

    protected final void scanArray(JavaConstant array, ScanReason prevReason) {
        block7: {
            ArrayScan reason;
            AnalysisType arrayType;
            block6: {
                arrayType = this.bb.getMetaAccess().lookupJavaType(array);
                reason = new ArrayScan(arrayType, array, prevReason);
                if (!(array instanceof ImageHeapConstant)) break block6;
                if (arrayType.getComponentType().isPrimitive()) break block7;
                ImageHeapArray heapArray = (ImageHeapArray)array;
                for (int idx = 0; idx < heapArray.getLength(); ++idx) {
                    JavaConstant element = heapArray.readElementValue(idx);
                    if (element.isNull()) {
                        this.scanningObserver.forNullArrayElement(array, arrayType, idx, reason);
                        continue;
                    }
                    this.scanArrayElement(array, arrayType, reason, idx, element);
                }
                break block7;
            }
            Object[] arrayObject = (Object[])ObjectScanner.constantAsObject(this.bb, array);
            for (int idx = 0; idx < arrayObject.length; ++idx) {
                Object e = arrayObject[idx];
                if (e == null) {
                    this.scanningObserver.forNullArrayElement(array, arrayType, idx, reason);
                    continue;
                }
                try {
                    JavaConstant element = this.bb.getSnippetReflectionProvider().forObject(this.bb.getUniverse().replaceObject(e));
                    this.scanArrayElement(array, arrayType, reason, idx, element);
                    continue;
                }
                catch (UnsupportedFeatureException ex) {
                    ObjectScanner.unsupportedFeatureDuringConstantScan(this.bb, this.bb.getSnippetReflectionProvider().forObject(e), ex, reason);
                }
            }
        }
    }

    private void scanArrayElement(JavaConstant array, AnalysisType arrayType, ScanReason reason, int idx, JavaConstant elementConstant) {
        AnalysisType elementType = this.bb.getMetaAccess().lookupJavaType(elementConstant);
        this.scanningObserver.forNonNullArrayElement(array, arrayType, elementConstant, elementType, idx, reason);
        this.scanConstant(elementConstant, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanConstant(JavaConstant value, ScanReason reason) {
        JavaConstant valueObj;
        if (value.isNull() || this.bb.getMetaAccess().isInstanceOf(value, WordBase.class)) {
            return;
        }
        if (!this.bb.scanningPolicy().scanConstant(this.bb, value)) {
            this.bb.registerTypeAsInHeap(this.bb.getMetaAccess().lookupJavaType(value), reason);
            return;
        }
        Object object = valueObj = value instanceof ImageHeapConstant ? value : ObjectScanner.constantAsObject(this.bb, value);
        if (this.scannedObjects.putAndAcquire(valueObj) == null) {
            try {
                this.scanningObserver.forScannedConstant(value, reason);
            }
            finally {
                this.scannedObjects.release(valueObj);
                WorklistEntry worklistEntry = new WorklistEntry(value, reason);
                if (this.executor != null) {
                    this.executor.execute((DebugContext debug) -> this.doScan(worklistEntry));
                } else {
                    this.worklist.push(worklistEntry);
                }
            }
        }
    }

    public static void unsupportedFeatureDuringConstantScan(BigBang bb, JavaConstant constant, UnsupportedFeatureException e, ScanReason reason) {
        ObjectScanner.unsupportedFeature(bb, String.valueOf(ObjectScanner.receiverHashCode(constant)), e.getMessage(), reason);
    }

    public static void unsupportedFeatureDuringFieldScan(BigBang bb, AnalysisField field, JavaConstant receiver, UnsupportedFeatureException e, ScanReason reason) {
        ObjectScanner.unsupportedFeature(bb, (String)(receiver != null ? ObjectScanner.receiverHashCode(receiver) + "_" : "") + field.format("%H.%n"), e.getMessage(), reason);
    }

    public static void unsupportedFeatureDuringFieldFolding(BigBang bb, AnalysisField field, JavaConstant receiver, UnsupportedFeatureException e, AnalysisMethod parsedMethod, int bci) {
        FieldConstantFold reason = new FieldConstantFold(field, parsedMethod, bci, receiver, new MethodParsing(parsedMethod));
        ObjectScanner.unsupportedFeature(bb, (String)(receiver != null ? ObjectScanner.receiverHashCode(receiver) + "_" : "") + field.format("%H.%n"), e.getMessage(), reason);
    }

    private static int receiverHashCode(JavaConstant receiver) {
        JavaConstant hostedObject;
        if (receiver instanceof ImageHeapConstant && (hostedObject = ((ImageHeapConstant)receiver).getHostedObject()) != null) {
            return hostedObject.hashCode();
        }
        return receiver.hashCode();
    }

    public static void unsupportedFeature(BigBang bb, String key, String message, ScanReason reason) {
        StringBuilder objectBacktrace = new StringBuilder();
        AnalysisMethod method = ObjectScanner.buildObjectBacktrace(bb, reason, objectBacktrace);
        bb.getUnsupportedFeatures().addMessage(key, method, message, objectBacktrace.toString());
    }

    public static AnalysisMethod buildObjectBacktrace(BigBang bb, ScanReason reason, StringBuilder objectBacktrace) {
        return ObjectScanner.buildObjectBacktrace(bb, reason, objectBacktrace, "Object was reached by");
    }

    public static AnalysisMethod buildObjectBacktrace(BigBang bb, ScanReason reason, StringBuilder objectBacktrace, String header) {
        ScanReason cur = reason;
        objectBacktrace.append(header);
        objectBacktrace.append(System.lineSeparator()).append(indent).append(cur.toString(bb));
        ScanReason rootReason = cur;
        cur = cur.previous;
        while (cur != null) {
            objectBacktrace.append(System.lineSeparator()).append(indent).append(cur.toString(bb));
            rootReason = cur.previous;
            cur = cur.previous;
        }
        if (rootReason instanceof EmbeddedRootScan) {
            return ((EmbeddedRootScan)rootReason).getMethod();
        }
        return null;
    }

    public static String asString(BigBang bb, JavaConstant constant) {
        return ObjectScanner.asString(bb, constant, true);
    }

    public static String asString(BigBang bb, JavaConstant constant, boolean appendToString) {
        if (constant == null || constant.isNull()) {
            return "null";
        }
        AnalysisType type = bb.getMetaAccess().lookupJavaType(constant);
        if (constant instanceof ImageHeapConstant) {
            return constant.getClass().getSimpleName() + "<" + type.toJavaName() + ">";
        }
        Object obj = ObjectScanner.constantAsObject(bb, constant);
        String str = type.toJavaName() + "@" + Integer.toHexString(System.identityHashCode(obj));
        if (appendToString) {
            try {
                str = str + ": " + ObjectScanner.limit(obj.toString(), 80).replace(System.lineSeparator(), "");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return str;
    }

    public static String limit(String value, int length) {
        StringBuilder buf = new StringBuilder(value);
        if (buf.length() > length) {
            buf.setLength(length);
            buf.append("...");
        }
        return buf.toString();
    }

    private void doScan(WorklistEntry entry) {
        try {
            AnalysisType type = this.bb.getMetaAccess().lookupJavaType(entry.constant);
            type.registerAsReachable(entry.reason);
            if (type.isInstanceClass()) {
                for (ResolvedJavaField javaField : type.getInstanceFields(true)) {
                    AnalysisField field = (AnalysisField)javaField;
                    if (field.getJavaKind() != JavaKind.Object || !field.isRead()) continue;
                    assert (!Modifier.isStatic(field.getModifiers()));
                    this.scanField(field, entry.constant, entry.reason);
                }
            } else if (type.isArray() && this.bb.getWordTypes().asKind((JavaType)type.getComponentType()) == JavaKind.Object) {
                this.scanArray(entry.constant, entry.reason);
            }
        }
        catch (UnsupportedFeatureException ex) {
            ObjectScanner.unsupportedFeatureDuringConstantScan(this.bb, entry.constant, ex, entry.reason);
        }
    }

    protected void finish() {
        if (this.executor == null) {
            while (!this.worklist.isEmpty()) {
                int size = this.worklist.size();
                for (int i = 0; i < size; ++i) {
                    this.doScan(this.worklist.remove());
                }
            }
        }
    }

    public static AnalysisType constantType(BigBang bb, JavaConstant constant) {
        return bb.getMetaAccess().lookupJavaType(constant);
    }

    public static Object constantAsObject(BigBang bb, JavaConstant constant) {
        return bb.getSnippetReflectionProvider().asObject(Object.class, constant);
    }

    public static final class ReusableSet {
        private final IdentityHashMap<Object, AtomicInteger> store = new IdentityHashMap(65536);
        private int sequence = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object putAndAcquire(Object object) {
            IdentityHashMap<Object, AtomicInteger> map = this.store;
            AtomicInteger i = map.get(object);
            int seq = this.sequence;
            int inflightSequence = seq - 1;
            while (true) {
                if (i != null) {
                    int current = i.get();
                    if (current == seq) {
                        return object;
                    }
                    if (current != inflightSequence && i.compareAndSet(current, inflightSequence)) {
                        return null;
                    }
                    while (i.get() != seq) {
                        Thread.yield();
                    }
                    return object;
                }
                AtomicInteger newSequence = new AtomicInteger(inflightSequence);
                IdentityHashMap<Object, AtomicInteger> identityHashMap = map;
                synchronized (identityHashMap) {
                    i = map.putIfAbsent(object, newSequence);
                    if (i == null) {
                        return null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Object o) {
            IdentityHashMap<Object, AtomicInteger> map = this.store;
            AtomicInteger i = map.get(o);
            if (i == null) {
                IdentityHashMap<Object, AtomicInteger> identityHashMap = map;
                synchronized (identityHashMap) {
                    i = map.get(o);
                }
            }
            i.set(this.sequence);
        }

        public void reset() {
            this.sequence += 2;
        }
    }

    public static class EmbeddedRootScan
    extends ScanReason {
        final BytecodePosition position;

        public EmbeddedRootScan(BytecodePosition nodeSourcePosition, JavaConstant root) {
            this(nodeSourcePosition, root, new MethodParsing((AnalysisMethod)nodeSourcePosition.getMethod()));
        }

        public EmbeddedRootScan(BytecodePosition nodeSourcePosition, JavaConstant root, ScanReason previous) {
            super(previous, root);
            this.position = nodeSourcePosition;
        }

        public AnalysisMethod getMethod() {
            return (AnalysisMethod)this.position.getMethod();
        }

        @Override
        public String toString(BigBang bb) {
            return "scanning root " + ObjectScanner.asString(bb, this.constant) + " embedded in " + System.lineSeparator() + ObjectScanner.INDENTATION_AFTER_NEWLINE + this.position.getMethod().asStackTraceElement(this.position.getBCI());
        }

        public String toString() {
            return this.position.getMethod().asStackTraceElement(this.position.getBCI()).toString();
        }
    }

    public static abstract class ScanReason {
        final ScanReason previous;
        final JavaConstant constant;

        protected ScanReason(ScanReason previous, JavaConstant constant) {
            this.previous = previous;
            this.constant = constant;
        }

        public ScanReason getPrevious() {
            return this.previous;
        }

        public String toString(BigBang bb) {
            return this.toString();
        }
    }

    public static class FieldScan
    extends ScanReason {
        final AnalysisField field;

        private static ScanReason previous(AnalysisField field) {
            Object readBy = field.getReadBy();
            if (readBy instanceof BytecodePosition) {
                ResolvedJavaMethod readingMethod = ((BytecodePosition)readBy).getMethod();
                return new MethodParsing((AnalysisMethod)readingMethod);
            }
            if (readBy instanceof AnalysisMethod) {
                return new MethodParsing((AnalysisMethod)readBy);
            }
            return new OtherReason("registered as read because: " + readBy);
        }

        public FieldScan(AnalysisField field) {
            this(field, null, FieldScan.previous(field));
        }

        public FieldScan(AnalysisField field, JavaConstant receiver, ScanReason previous) {
            super(previous, receiver);
            this.field = field;
        }

        public AnalysisField getField() {
            return this.field;
        }

        public String location() {
            Object readBy = this.field.getReadBy();
            if (readBy instanceof BytecodePosition) {
                BytecodePosition position = (BytecodePosition)readBy;
                return position.getMethod().asStackTraceElement(position.getBCI()).toString();
            }
            if (readBy instanceof AnalysisMethod) {
                return ((AnalysisMethod)readBy).asStackTraceElement(0).toString();
            }
            return "<unknown-location>";
        }

        @Override
        public String toString(BigBang bb) {
            if (this.field.isStatic()) {
                return "reading static field " + this.field.format("%H.%n") + System.lineSeparator() + "    at " + this.location();
            }
            return "reading field " + this.field.format("%H.%n") + " of constant " + System.lineSeparator() + ObjectScanner.INDENTATION_AFTER_NEWLINE + ObjectScanner.asString(bb, this.constant);
        }

        public String toString() {
            return this.field.format("%H.%n");
        }
    }

    public static class ArrayScan
    extends ScanReason {
        final AnalysisType arrayType;

        public ArrayScan(AnalysisType arrayType, JavaConstant array, ScanReason previous) {
            super(previous, array);
            this.arrayType = arrayType;
        }

        @Override
        public String toString(BigBang bb) {
            return "indexing into array " + ObjectScanner.asString(bb, this.constant);
        }

        public String toString() {
            return this.arrayType.toJavaName(true);
        }
    }

    static class WorklistEntry {
        private final JavaConstant constant;
        private final ScanReason reason;

        WorklistEntry(JavaConstant constant, ScanReason reason) {
            this.constant = constant;
            this.reason = reason;
        }

        public ScanReason getReason() {
            return this.reason;
        }
    }

    public static class FieldConstantFold
    extends ScanReason {
        final AnalysisField field;
        private final AnalysisMethod parsedMethod;
        private final int bci;

        public FieldConstantFold(AnalysisField field, AnalysisMethod parsedMethod, int bci, JavaConstant receiver, ScanReason previous) {
            super(previous, receiver);
            this.field = field;
            this.parsedMethod = parsedMethod;
            this.bci = bci;
        }

        @Override
        public String toString(BigBang bb) {
            StackTraceElement location = this.parsedMethod.asStackTraceElement(this.bci);
            if (this.field.isStatic()) {
                return "trying to constant fold static field " + this.field.format("%H.%n") + System.lineSeparator() + "    at " + location;
            }
            return "trying to constant fold field " + this.field.format("%H.%n") + " of constant " + System.lineSeparator() + ObjectScanner.INDENTATION_AFTER_NEWLINE + ObjectScanner.asString(bb, this.constant) + System.lineSeparator() + "    at " + location;
        }

        public String toString() {
            return this.field.format("%H.%n");
        }
    }

    public static class MethodParsing
    extends ScanReason {
        final AnalysisMethod method;

        public MethodParsing(AnalysisMethod method) {
            this(method, null);
        }

        public MethodParsing(AnalysisMethod method, ScanReason previous) {
            super(previous, null);
            this.method = method;
        }

        public AnalysisMethod getMethod() {
            return this.method;
        }

        public String toString() {
            Object str = String.format("parsing method %s reachable via the parsing context", this.method.asStackTraceElement(0));
            str = (String)str + ReportUtils.parsingContext(this.method, ObjectScanner.INDENTATION_AFTER_NEWLINE);
            return str;
        }
    }

    public static class OtherReason
    extends ScanReason {
        public static final ScanReason RESCAN = new OtherReason("manually triggered rescan");
        public static final ScanReason HUB = new OtherReason("scanning a class constant");
        final String reason;

        public OtherReason(String reason) {
            super(null, null);
            this.reason = reason;
        }

        public String toString() {
            return this.reason;
        }
    }
}

