/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.HeapScanningPolicy;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.word.WordTypes;

public abstract class AbstractAnalysisEngine
implements BigBang {
    protected final AnalysisUniverse universe;
    protected final AnalysisMetaAccess metaAccess;
    protected final AnalysisPolicy analysisPolicy;
    private final HeapScanningPolicy heapScanningPolicy;
    protected final Boolean extendedAsserts;
    protected final int maxConstantObjectsPerType;
    protected final boolean profileConstantObjects;
    protected final boolean optimizeReturnedParameter;
    protected final OptionValues options;
    protected final DebugContext debug;
    private final List<DebugHandlersFactory> debugHandlerFactories;
    protected final HostVM hostVM;
    protected final UnsupportedFeatures unsupportedFeatures;
    private final SnippetReflectionProvider snippetReflectionProvider;
    private final ConstantReflectionProvider constantReflectionProvider;
    private final WordTypes wordTypes;
    protected final CompletionExecutor executor;
    private final Runnable heartbeatCallback;
    protected final Timer processFeaturesTimer;
    protected final Timer analysisTimer;
    protected final Timer verifyHeapTimer;

    public AbstractAnalysisEngine(OptionValues options, AnalysisUniverse universe, HostVM hostVM, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, ForkJoinPool executorService, Runnable heartbeatCallback, UnsupportedFeatures unsupportedFeatures, TimerCollection timerCollection) {
        this.options = options;
        this.universe = universe;
        this.debugHandlerFactories = Collections.singletonList(new GraalDebugHandlersFactory(snippetReflectionProvider));
        this.debug = new DebugContext.Builder(options, this.debugHandlerFactories).build();
        this.metaAccess = metaAccess;
        this.analysisPolicy = universe.analysisPolicy();
        this.hostVM = hostVM;
        this.executor = new CompletionExecutor(this, executorService, heartbeatCallback);
        this.heartbeatCallback = heartbeatCallback;
        this.unsupportedFeatures = unsupportedFeatures;
        this.processFeaturesTimer = timerCollection.get(TimerCollection.Registry.FEATURES);
        this.verifyHeapTimer = timerCollection.get(TimerCollection.Registry.VERIFY_HEAP);
        this.analysisTimer = timerCollection.get(TimerCollection.Registry.ANALYSIS);
        this.extendedAsserts = (Boolean)PointstoOptions.ExtendedAsserts.getValue(options);
        this.maxConstantObjectsPerType = (Integer)PointstoOptions.MaxConstantObjectsPerType.getValue(options);
        this.profileConstantObjects = (Boolean)PointstoOptions.ProfileConstantObjects.getValue(options);
        this.optimizeReturnedParameter = (Boolean)PointstoOptions.OptimizeReturnedParameter.getValue(options);
        this.heapScanningPolicy = (Boolean)PointstoOptions.ExhaustiveHeapScan.getValue(options) != false ? HeapScanningPolicy.scanAll() : HeapScanningPolicy.skipTypes(this.skippedHeapTypes());
        this.snippetReflectionProvider = snippetReflectionProvider;
        this.constantReflectionProvider = constantReflectionProvider;
        this.wordTypes = wordTypes;
    }

    @Override
    public void runAnalysis(DebugContext debugContext, Function<AnalysisUniverse, Boolean> analysisEndCondition) throws InterruptedException {
        int numIterations = 0;
        while (true) {
            Indent indent2 = debugContext.logAndIndent("new analysis iteration");
            try {
                boolean pendingOperations;
                boolean analysisChanged = this.finish();
                if (++numIterations > 1000) {
                    throw AnalysisError.shouldNotReachHere(String.format("Static analysis did not reach a fix point after %d iterations because a Feature keeps requesting new analysis iterations. The analysis itself %s find a change in type states in the last iteration.", numIterations, analysisChanged ? "DID" : "DID NOT"));
                }
                int numTypes = this.universe.getTypes().size();
                int numMethods = this.universe.getMethods().size();
                int numFields = this.universe.getFields().size();
                if (!analysisEndCondition.apply(this.universe).booleanValue()) continue;
                if (numTypes != this.universe.getTypes().size() || numMethods != this.universe.getMethods().size() || numFields != this.universe.getFields().size()) {
                    throw AnalysisError.shouldNotReachHere("When a feature makes more types, methods, or fields reachable, it must require another analysis iteration via DuringAnalysisAccess.requireAnalysisIteration()");
                }
                boolean bl = pendingOperations = this.executor.getPostedOperations() > 0L;
                if (pendingOperations) {
                    System.out.println("Found pending operations, continuing analysis.");
                    continue;
                }
                if (this.analysisModified()) continue;
                return;
            }
            finally {
                if (indent2 == null) continue;
                indent2.close();
                continue;
            }
            break;
        }
    }

    protected abstract CompletionExecutor.Timing getTiming();

    private boolean analysisModified() throws InterruptedException {
        boolean analysisModified;
        try (Timer.StopTimer ignored = this.verifyHeapTimer.start();){
            analysisModified = this.universe.getHeapVerifier().requireAnalysisIteration(this.executor);
        }
        this.executor.init(this.getTiming());
        return analysisModified;
    }

    @Override
    public void cleanupAfterAnalysis() {
        this.universe.getTypes().forEach(AnalysisType::cleanupAfterAnalysis);
        this.universe.getFields().forEach(AnalysisField::cleanupAfterAnalysis);
        this.universe.getMethods().forEach(AnalysisMethod::cleanupAfterAnalysis);
        this.universe.getHeapScanner().cleanupAfterAnalysis();
        this.universe.getHeapVerifier().cleanupAfterAnalysis();
    }

    @Override
    public void printTimerStatistics(PrintWriter out) {
        StatisticsPrinter.print(out, "features_time_ms", this.processFeaturesTimer.getTotalTime());
        StatisticsPrinter.print(out, "total_analysis_time_ms", this.analysisTimer.getTotalTime());
        StatisticsPrinter.printLast(out, "total_memory_bytes", this.analysisTimer.getTotalMemory());
    }

    @Override
    public AnalysisType[] skippedHeapTypes() {
        return new AnalysisType[]{this.metaAccess.lookupJavaType((Class)String.class)};
    }

    @Override
    public boolean extendedAsserts() {
        return this.extendedAsserts;
    }

    public int maxConstantObjectsPerType() {
        return this.maxConstantObjectsPerType;
    }

    public boolean optimizeReturnedParameter() {
        return this.optimizeReturnedParameter;
    }

    public void profileConstantObject(AnalysisType type) {
        if (this.profileConstantObjects) {
            PointsToAnalysis.ConstantObjectsProfiler.registerConstant(type);
            PointsToAnalysis.ConstantObjectsProfiler.maybeDumpConstantHistogram();
        }
    }

    @Override
    public OptionValues getOptions() {
        return this.options;
    }

    @Override
    public Runnable getHeartbeatCallback() {
        return this.heartbeatCallback;
    }

    @Override
    public DebugContext getDebug() {
        return this.debug;
    }

    @Override
    public List<DebugHandlersFactory> getDebugHandlerFactories() {
        return this.debugHandlerFactories;
    }

    @Override
    public AnalysisPolicy analysisPolicy() {
        return this.universe.analysisPolicy();
    }

    @Override
    public AnalysisUniverse getUniverse() {
        return this.universe;
    }

    @Override
    public final HostedProviders getProviders(MultiMethod.MultiMethodKey key) {
        return this.getHostVM().getProviders(key);
    }

    @Override
    public AnalysisMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    @Override
    public UnsupportedFeatures getUnsupportedFeatures() {
        return this.unsupportedFeatures;
    }

    @Override
    public final SnippetReflectionProvider getSnippetReflectionProvider() {
        return this.snippetReflectionProvider;
    }

    @Override
    public final ConstantReflectionProvider getConstantReflectionProvider() {
        return this.constantReflectionProvider;
    }

    @Override
    public WordTypes getWordTypes() {
        return this.wordTypes;
    }

    @Override
    public HeapScanningPolicy scanningPolicy() {
        return this.heapScanningPolicy;
    }

    @Override
    public HostVM getHostVM() {
        return this.hostVM;
    }

    protected void schedule(Runnable task) {
        this.executor.execute(d -> task.run());
    }

    @Override
    public final void postTask(CompletionExecutor.DebugContextRunnable task) {
        this.executor.execute(task);
    }

    public void postTask(final Runnable task) {
        this.executor.execute(new CompletionExecutor.DebugContextRunnable(){

            @Override
            public void run(DebugContext ignore) {
                task.run();
            }

            @Override
            public DebugContext getDebug(OptionValues opts, List<DebugHandlersFactory> factories) {
                assert (opts == AbstractAnalysisEngine.this.getOptions());
                return DebugContext.disabled((OptionValues)opts);
            }
        });
    }

    @Override
    public final boolean executorIsStarted() {
        return this.executor.isStarted();
    }

    public static BytecodePosition sourcePosition(ValueNode node) {
        NodeSourcePosition position = node.getNodeSourcePosition();
        if (position == null) {
            position = AbstractAnalysisEngine.syntheticSourcePosition((Node)node, node.graph().method());
        }
        return position;
    }

    public static BytecodePosition syntheticSourcePosition(Node node, ResolvedJavaMethod method) {
        StateSplit stateSplit;
        FrameState frameState;
        int bci = -5;
        if (node instanceof DeoptBciSupplier) {
            bci = ((DeoptBciSupplier)node).bci();
        }
        if (node instanceof StateSplit && (frameState = (stateSplit = (StateSplit)node).stateAfter()) != null) {
            if (frameState.outerFrameState() != null) {
                FrameState current = frameState;
                while (current.outerFrameState() != null) {
                    current = current.outerFrameState();
                }
                assert (method.equals(current.getMethod()));
                bci = current.bci;
            } else if (bci == -5) {
                bci = frameState.bci;
            }
        }
        return new BytecodePosition(null, method, bci);
    }
}

