/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ImageHeapArray
extends ImageHeapConstant {
    private final JavaConstant[] arrayElementValues;

    public ImageHeapArray(ResolvedJavaType type, int length) {
        this(type, null, new JavaConstant[length]);
    }

    public ImageHeapArray(ResolvedJavaType type, JavaConstant object, int length) {
        this(type, object, new JavaConstant[length]);
    }

    ImageHeapArray(ResolvedJavaType type, JavaConstant object, JavaConstant[] arrayElementValues) {
        this(type, object, arrayElementValues, ImageHeapArray.createIdentityHashCode(object), false);
    }

    private ImageHeapArray(ResolvedJavaType type, JavaConstant object, JavaConstant[] arrayElementValues, int identityHashCode, boolean compressed) {
        super(type, object, identityHashCode, compressed);
        assert (type.isArray());
        this.arrayElementValues = arrayElementValues;
    }

    public JavaConstant getElement(int idx) {
        return this.arrayElementValues[idx];
    }

    public void setElement(int idx, JavaConstant value) {
        this.arrayElementValues[idx] = value;
    }

    public int getLength() {
        return this.arrayElementValues.length;
    }

    public JavaConstant compress() {
        assert (!this.compressed);
        return new ImageHeapArray(this.type, this.hostedObject, this.arrayElementValues, this.identityHashCode, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed);
        return new ImageHeapArray(this.type, this.hostedObject, this.arrayElementValues, this.identityHashCode, false);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ImageHeapArray) {
            return super.equals(o) && this.arrayElementValues == ((ImageHeapArray)o).arrayElementValues;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + System.identityHashCode(this.arrayElementValues);
        return result;
    }
}

