/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.common.JVMCIError;

public class ArrayElementsTypeFlow
extends TypeFlow<AnalysisType> {
    private final AnalysisObject object;

    public ArrayElementsTypeFlow(AnalysisObject sourceObject) {
        super(sourceObject.type(), sourceObject.type().getComponentType());
        this.object = sourceObject;
    }

    @Override
    public TypeFlow<AnalysisType> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        throw JVMCIError.shouldNotReachHere((String)"The mixed elements flow should not be cloned. Use Load/StoreFlows.");
    }

    @Override
    public boolean canSaturate() {
        return false;
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        this.getDeclaredType().getTypeFlow(bb, true).addUse(bb, this);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState update) {
        if (this.declaredType.equals(bb.getObjectType())) {
            return update;
        }
        return TypeState.forIntersection(bb, update, this.declaredType.getAssignableTypes(true));
    }

    public AnalysisObject object() {
        return this.object;
    }

    @Override
    public String toString() {
        return "MixedElementsFlow<" + ((AnalysisType)this.source).getName() + "\n" + this.getState() + ">";
    }
}

