/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ImageGeneratorThreadMarker;
import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.stream.StreamSupport;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.WordTypes;

public abstract class PointsToAnalysis
extends AbstractAnalysisEngine {
    private final AnalysisType objectType;
    private TypeFlow<?> allSynchronizedTypeFlow;
    protected final boolean trackTypeFlowInputs;
    protected final boolean reportAnalysisStatistics;
    private ConcurrentMap<OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow, Boolean> unsafeLoads;
    private ConcurrentMap<OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow, Boolean> unsafeStores;
    public final AtomicLong numParsedGraphs = new AtomicLong();
    private final CompletionExecutor.Timing timing;
    public final Timer typeFlowTimer;
    private final boolean strengthenGraalGraphs;

    public PointsToAnalysis(OptionValues options, AnalysisUniverse universe, HostVM hostVM, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, ForkJoinPool executorService, Runnable heartbeatCallback, UnsupportedFeatures unsupportedFeatures, TimerCollection timerCollection, boolean strengthenGraalGraphs) {
        super(options, universe, hostVM, metaAccess, snippetReflectionProvider, constantReflectionProvider, wordTypes, executorService, heartbeatCallback, unsupportedFeatures, timerCollection);
        this.typeFlowTimer = timerCollection.createTimer("(typeflow)");
        this.strengthenGraalGraphs = strengthenGraalGraphs;
        this.objectType = metaAccess.lookupJavaType((Class)Object.class);
        this.objectType.getTypeFlow(this, true);
        this.allSynchronizedTypeFlow = new AllSynchronizedTypeFlow();
        this.trackTypeFlowInputs = (Boolean)PointstoOptions.TrackInputFlows.getValue(options);
        this.reportAnalysisStatistics = (Boolean)PointstoOptions.PrintPointsToStatistics.getValue(options);
        if (this.reportAnalysisStatistics) {
            PointsToStats.init(this);
        }
        this.unsafeLoads = new ConcurrentHashMap<OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow, Boolean>();
        this.unsafeStores = new ConcurrentHashMap<OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow, Boolean>();
        this.timing = (Boolean)PointstoOptions.ProfileAnalysisOperations.getValue(options) != false ? new AnalysisTiming() : null;
        this.executor.init(this.timing);
    }

    @Override
    protected CompletionExecutor.Timing getTiming() {
        return this.timing;
    }

    @Override
    public void printTimerStatistics(PrintWriter out) {
        StatisticsPrinter.print(out, "typeflow_time_ms", this.typeFlowTimer.getTotalTime());
        StatisticsPrinter.print(out, "verify_time_ms", this.verifyHeapTimer.getTotalTime());
        StatisticsPrinter.print(out, "features_time_ms", this.processFeaturesTimer.getTotalTime());
        StatisticsPrinter.print(out, "total_analysis_time_ms", this.analysisTimer.getTotalTime());
        StatisticsPrinter.printLast(out, "total_memory_bytes", this.analysisTimer.getTotalMemory());
    }

    @Override
    public boolean strengthenGraalGraphs() {
        return this.strengthenGraalGraphs;
    }

    public boolean trackTypeFlowInputs() {
        return this.trackTypeFlowInputs;
    }

    public boolean reportAnalysisStatistics() {
        return this.reportAnalysisStatistics;
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        return new MethodTypeFlowBuilder(bb, method, flowsGraph, graphKind);
    }

    public void registerUnsafeLoad(OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow unsafeLoad) {
        this.unsafeLoads.putIfAbsent(unsafeLoad, true);
    }

    public void registerUnsafeStore(OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow unsafeStore) {
        this.unsafeStores.putIfAbsent(unsafeStore, true);
    }

    @Override
    public void forceUnsafeUpdate(AnalysisField field) {
        for (OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow unsafeLoad : this.unsafeLoads.keySet()) {
            unsafeLoad.forceUpdate(this);
            this.postFlow(unsafeLoad.receiver());
        }
        for (OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow unsafeStore : this.unsafeStores.keySet()) {
            unsafeStore.forceUpdate(this);
            this.postFlow(unsafeStore.receiver());
        }
    }

    @Override
    public void registerAsJNIAccessed(AnalysisField field, boolean writable) {
        AllInstantiatedTypeFlow declaredTypeFlow = field.getType().getTypeFlow(this, true);
        if (field.isStatic()) {
            declaredTypeFlow.addUse(this, field.getStaticFieldFlow());
        } else {
            FieldTypeFlow instanceFieldFlow = field.getDeclaringClass().getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, writable);
            declaredTypeFlow.addUse(this, instanceFieldFlow);
        }
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        return true;
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.allSynchronizedTypeFlow = null;
        this.unsafeLoads = null;
        this.unsafeStores = null;
        ConstantObjectsProfiler.constantTypes.clear();
    }

    public AnalysisType lookup(JavaType type) {
        return this.universe.lookup(type);
    }

    public AnalysisType getObjectType() {
        return this.metaAccess.lookupJavaType((Class)Object.class);
    }

    public AnalysisType getObjectArrayType() {
        return this.metaAccess.lookupJavaType((Class)Object[].class);
    }

    public AnalysisType getGraalNodeType() {
        return this.metaAccess.lookupJavaType((Class)Node.class);
    }

    public AnalysisType getGraalNodeListType() {
        return this.metaAccess.lookupJavaType((Class)NodeList.class);
    }

    public TypeFlow<?> getAllInstantiatedTypeFlow() {
        return this.objectType.getTypeFlow(this, true);
    }

    @Override
    public Iterable<AnalysisType> getAllInstantiatedTypes() {
        return this.getAllInstantiatedTypeFlow().getState().types(this);
    }

    public TypeFlow<?> getAllSynchronizedTypeFlow() {
        return this.allSynchronizedTypeFlow;
    }

    @Override
    public Iterable<AnalysisType> getAllSynchronizedTypes() {
        if (this.allSynchronizedTypeFlow.isSaturated()) {
            return this.getAllInstantiatedTypes();
        }
        return this.allSynchronizedTypeFlow.getState().types(this);
    }

    @Override
    public AnalysisMethod addRootMethod(Executable method, boolean invokeSpecial) {
        return this.addRootMethod(this.metaAccess.lookupJavaMethod(method), invokeSpecial);
    }

    @Override
    public AnalysisMethod addRootMethod(AnalysisMethod aMethod, boolean invokeSpecial) {
        assert (aMethod.isOriginalMethod());
        assert (!this.universe.sealed()) : "Cannot register root methods after analysis universe is sealed.";
        AnalysisType declaringClass = aMethod.getDeclaringClass();
        boolean isStatic = aMethod.isStatic();
        WrappedSignature signature = aMethod.getSignature();
        int paramCount = signature.getParameterCount(!isStatic);
        PointsToAnalysisMethod pointsToMethod = PointsToAnalysis.assertPointsToAnalysisMethod(aMethod);
        if (isStatic) {
            this.postTask(() -> {
                pointsToMethod.registerAsDirectRootMethod();
                pointsToMethod.registerAsImplementationInvoked("root method");
                MethodFlowsGraphInfo flowInfo = this.analysisPolicy.staticRootMethodGraph(this, pointsToMethod);
                for (int idx = 0; idx < paramCount; ++idx) {
                    AnalysisType declaredParamType = (AnalysisType)signature.getParameterType(idx, declaringClass);
                    FormalParamTypeFlow parameter = flowInfo.getParameter(idx);
                    if (declaredParamType.getJavaKind() != JavaKind.Object || parameter == null) continue;
                    AllInstantiatedTypeFlow initialParameterFlow = declaredParamType.getTypeFlow(this, true);
                    initialParameterFlow.addUse(this, parameter);
                }
            });
        } else {
            if (invokeSpecial && pointsToMethod.isAbstract()) {
                throw AnalysisError.userError("Abstract methods cannot be registered as special invoke entry point.");
            }
            this.postTask(() -> {
                if (invokeSpecial) {
                    pointsToMethod.registerAsDirectRootMethod();
                } else {
                    pointsToMethod.registerAsVirtualRootMethod();
                }
                InvokeTypeFlow invoke = pointsToMethod.initAndGetContextInsensitiveInvoke(this, null, invokeSpecial, pointsToMethod.getMultiMethodKey());
                for (int idx = 1; idx < paramCount; ++idx) {
                    AnalysisType declaredParamType = (AnalysisType)signature.getParameterType(idx - 1, declaringClass);
                    TypeFlow<?> actualParameterFlow = invoke.getActualParameter(idx);
                    if (declaredParamType.getJavaKind() != JavaKind.Object || actualParameterFlow == null) continue;
                    AllInstantiatedTypeFlow initialParameterFlow = declaredParamType.getTypeFlow(this, true);
                    initialParameterFlow.addUse(this, actualParameterFlow);
                }
            });
        }
        return aMethod;
    }

    public static PointsToAnalysisMethod assertPointsToAnalysisMethod(AnalysisMethod aMethod) {
        assert (aMethod instanceof PointsToAnalysisMethod) : "Only points-to analysis methods are supported";
        return (PointsToAnalysisMethod)aMethod;
    }

    @Override
    public AnalysisType addRootClass(Class<?> clazz, boolean addFields, boolean addArrayClass) {
        ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)clazz);
        return this.addRootClass((AnalysisType)type, addFields, addArrayClass);
    }

    @Override
    public AnalysisType addRootClass(AnalysisType type, boolean addFields, boolean addArrayClass) {
        type.registerAsReachable("root class");
        for (ResolvedJavaField javaField : type.getInstanceFields(false)) {
            AnalysisField field = (AnalysisField)javaField;
            if (addFields) {
                field.registerAsAccessed("field of root class");
            }
            AllInstantiatedTypeFlow fieldDeclaredTypeFlow = field.getType().getTypeFlow(this, true);
            fieldDeclaredTypeFlow.addUse(this, type.getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, true));
        }
        if (type.getSuperclass() != null) {
            this.addRootClass(type.getSuperclass(), addFields, addArrayClass);
        }
        if (addArrayClass) {
            this.addRootClass(type.getArrayClass(), false, false);
        }
        return type;
    }

    @Override
    public AnalysisType addRootField(Class<?> clazz, String fieldName) {
        AnalysisType type = this.addRootClass(clazz, false, false);
        for (ResolvedJavaField javaField : type.getInstanceFields(true)) {
            AnalysisField field = (AnalysisField)javaField;
            if (!field.getName().equals(fieldName)) continue;
            field.registerAsAccessed("root field");
            AllInstantiatedTypeFlow fieldDeclaredTypeFlow = field.getType().getTypeFlow(this, true);
            fieldDeclaredTypeFlow.addUse(this, type.getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, true));
            return field.getType();
        }
        throw JVMCIError.shouldNotReachHere((String)("field not found: " + fieldName));
    }

    public AnalysisType addRootStaticField(Class<?> clazz, String fieldName) {
        this.addRootClass(clazz, false, false);
        try {
            Field reflectField = clazz.getField(fieldName);
            AnalysisField field = this.metaAccess.lookupJavaField(reflectField);
            field.registerAsAccessed("static root field");
            AllInstantiatedTypeFlow fieldFlow = field.getType().getTypeFlow(this, true);
            fieldFlow.addUse(this, field.getStaticFieldFlow());
            return field.getType();
        }
        catch (NoSuchFieldException e) {
            throw JVMCIError.shouldNotReachHere((String)("field not found: " + fieldName));
        }
    }

    @Override
    public void checkUserLimitations() {
    }

    public void postFlow(final TypeFlow<?> operation) {
        if (operation.inQueue) {
            return;
        }
        operation.inQueue = true;
        this.executor.execute(new TypeFlowRunnable(){

            @Override
            public void run(DebugContext ignored) {
                PointsToStats.registerTypeFlowQueuedUpdate(PointsToAnalysis.this, operation);
                operation.inQueue = false;
                operation.update(PointsToAnalysis.this);
            }

            public String toString() {
                return "Operation: " + operation.toString();
            }

            @Override
            public TypeFlow<?> getTypeFlow() {
                return operation;
            }
        });
    }

    public void postTask(final Runnable task) {
        this.executor.execute(new CompletionExecutor.DebugContextRunnable(){

            @Override
            public void run(DebugContext ignore) {
                task.run();
            }

            @Override
            public DebugContext getDebug(OptionValues opts, List<DebugHandlersFactory> factories) {
                assert (opts == PointsToAnalysis.this.getOptions());
                return DebugContext.disabled((OptionValues)opts);
            }
        });
    }

    @Override
    public boolean finish() throws InterruptedException {
        try (Indent indent = this.debug.logAndIndent("starting analysis in BigBang.finish");){
            this.universe.setAnalysisDataValid(false);
            boolean didSomeWork = this.doTypeflow();
            assert (this.executor.getPostedOperations() == 0L);
            this.universe.setAnalysisDataValid(true);
            boolean bl = didSomeWork;
            return bl;
        }
    }

    public boolean doTypeflow() throws InterruptedException {
        boolean didSomeWork;
        try (Timer.StopTimer ignored = this.typeFlowTimer.start();){
            this.executor.start();
            this.executor.complete();
            didSomeWork = this.executor.getPostedOperations() > 0L;
            this.executor.shutdown();
        }
        this.executor.init(this.timing);
        return didSomeWork;
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="ForkJoinPool does support null for the exception handler.")
    public static ForkJoinPool createExecutor(DebugContext debug, int numberOfThreads) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = PointsToAnalysis.debugThreadFactory((DebugContext)(debug.areScopesEnabled() || debug.areMetricsEnabled() ? debug : null));
        return new ForkJoinPool(numberOfThreads, factory, null, false);
    }

    private static ForkJoinPool.ForkJoinWorkerThreadFactory debugThreadFactory(DebugContext debug) {
        return pool -> new SubstrateWorkerThread(pool, debug);
    }

    @Override
    public void onTypeInstantiated(AnalysisType type, AnalysisType.UsageKind usageKind) {
        assert (type.isAllocated() || type.isInHeap());
        AnalysisError.guarantee(type.isArray() || type.isInstanceClass() && !type.isAbstract());
        this.universe.hostVM().checkForbidden(type, usageKind);
        SingleTypeState typeState = TypeState.forExactType(this, type, true);
        SingleTypeState typeStateNonNull = TypeState.forExactType(this, type, false);
        type.forAllSuperTypes(t -> {
            t.instantiatedTypes.addState(this, typeState);
            t.instantiatedTypesNonNull.addState(this, typeStateNonNull);
        });
    }

    protected class AnalysisTiming
    extends BucketTiming {
        protected AnalysisTiming() {
        }

        @Override
        public void printHeader() {
            System.out.format("%5s %5s %5s  |", "graphs", "types", "nid");
            super.printHeader();
            System.out.println();
        }

        @Override
        public void print() {
            System.out.format("%5d %5d %5d  |", PointsToAnalysis.this.numParsedGraphs.get(), StreamSupport.stream(PointsToAnalysis.this.getAllInstantiatedTypes().spliterator(), false).count(), PointsToAnalysis.this.universe.getNextTypeId());
            super.print();
            System.out.println();
        }
    }

    public static class ConstantObjectsProfiler {
        static final ConcurrentHashMap<AnalysisType, MyInteger> constantTypes = new ConcurrentHashMap(2000);
        static final int PROCESSED_CONSTANTS_DUMP_THRESHOLD = 100000;
        static final int CONSTANT_COUNTER_DUMP_THRESHOLD = 1000;
        static int processedConstants;
        static final ConstantCounterEntryComparator CONSTANT_COUNTER_COMPARATOR;

        public static void registerConstant(AnalysisType type) {
            ++processedConstants;
            MyInteger counter = constantTypes.get(type);
            if (counter == null) {
                MyInteger newValue = new MyInteger();
                MyInteger oldValue = constantTypes.putIfAbsent(type, newValue);
                counter = oldValue != null ? oldValue : newValue;
            }
            counter.increment();
        }

        public static void maybeDumpConstantHistogram() {
            if (processedConstants > 100000) {
                processedConstants = 0;
                ArrayList<ConstantCounterEntry> constantCounters = new ArrayList<ConstantCounterEntry>();
                for (Map.Entry<AnalysisType, MyInteger> entry : constantTypes.entrySet()) {
                    AnalysisType type = entry.getKey();
                    Integer counter = entry.getValue().value();
                    if (counter <= 1000) continue;
                    constantCounters.add(new ConstantCounterEntry(type, counter));
                }
                Collections.sort(constantCounters, CONSTANT_COUNTER_COMPARATOR);
                System.out.println(" - - - - - - - - - - - - - - - - - - - - - - - -  ");
                System.out.println("              CONSTANT HISTOGRAM                  ");
                for (ConstantCounterEntry constantCounter : constantCounters) {
                    System.out.format("%d : %s %n", constantCounter.counter, constantCounter.type.getName());
                }
                System.out.println(" - - - - - - - - - - - - - - - - - - - - - - - -  ");
            }
        }

        static {
            CONSTANT_COUNTER_COMPARATOR = new ConstantCounterEntryComparator();
        }

        static class MyInteger {
            int myInt = 0;

            MyInteger() {
            }

            protected void increment() {
                ++this.myInt;
            }

            protected int value() {
                return this.myInt;
            }

            public String toString() {
                return "" + this.myInt;
            }
        }

        static class ConstantCounterEntry {
            protected AnalysisType type;
            protected int counter;

            ConstantCounterEntry(AnalysisType type, int counter) {
                this.type = type;
                this.counter = counter;
            }
        }

        static class ConstantCounterEntryComparator
        implements Comparator<ConstantCounterEntry> {
            ConstantCounterEntryComparator() {
            }

            @Override
            public int compare(ConstantCounterEntry o1, ConstantCounterEntry o2) {
                return Integer.compare(o2.counter, o1.counter);
            }
        }
    }

    private static class SubstrateWorkerThread
    extends ForkJoinWorkerThread
    implements ImageGeneratorThreadMarker {
        private final DebugContext debug;

        SubstrateWorkerThread(ForkJoinPool pool, DebugContext debug) {
            super(pool);
            this.debug = debug;
        }

        @Override
        protected void onTermination(Throwable exception) {
            if (this.debug != null) {
                this.debug.closeDumpHandlers(true);
            }
        }
    }

    protected static abstract class BucketTiming
    implements CompletionExecutor.Timing {
        private static final int NUM_BUCKETS = 10;
        private final AtomicLong numOperations = new AtomicLong();
        private final AtomicLong numAdded = new AtomicLong();
        private final AtomicLong numDone = new AtomicLong();
        private final AtomicLong numInQueue = new AtomicLong();
        private final AtomicLong totalTime = new AtomicLong();
        private final AtomicLongArray timeBuckets = new AtomicLongArray(10);

        protected BucketTiming() {
        }

        @Override
        public long getPrintIntervalNanos() {
            return 1000000000L;
        }

        @Override
        public void addScheduled(CompletionExecutor.DebugContextRunnable r) {
            this.numOperations.incrementAndGet();
            this.numInQueue.incrementAndGet();
            this.numAdded.incrementAndGet();
        }

        @Override
        public void addCompleted(CompletionExecutor.DebugContextRunnable r, long nanos) {
            this.numInQueue.decrementAndGet();
            this.numDone.incrementAndGet();
            this.totalTime.addAndGet(nanos);
            int bucket = 0;
            for (long bucketTime = nanos / 1000L; bucketTime != 0L && bucket < 9; bucketTime /= 10L, ++bucket) {
            }
            this.timeBuckets.incrementAndGet(bucket);
            if (nanos > 500000000L && r instanceof TypeFlowRunnable) {
                TypeFlow<?> tf = ((TypeFlowRunnable)r).getTypeFlow();
                String source = String.valueOf(tf.getSource());
                System.out.format("LONG RUNNING  %.2f  %s %x %s  state %s %x  uses %d observers %d%n", (double)nanos / 1.0E9, ClassUtil.getUnqualifiedName(tf.getClass()), System.identityHashCode(tf), source, PointsToStats.asString(tf.getState()), System.identityHashCode(tf.getState()), tf.getUses().size(), tf.getObservers().size());
            }
        }

        @Override
        public void printHeader() {
            System.out.format("%9s %6s %6s %6s %10s %8s  %5s %5s %5s %5s %5s %5s %5s %5s %5s %5s  |", "total", "qlen", "added", "done", "total us", "avg us", "<1us", ">1us", "10", "100", ">1ms", "10", "100", ">1s", "10", "100");
        }

        @Override
        public void print() {
            int i;
            long operations = this.numOperations.get();
            long queued = this.numInQueue.get();
            long scheduled = this.numAdded.getAndSet(0L);
            long completed = this.numDone.getAndSet(0L);
            long time = this.totalTime.getAndSet(0L);
            long[] buckets = new long[10];
            for (i = 0; i < 10; ++i) {
                buckets[i] = this.timeBuckets.getAndSet(i, 0L);
            }
            System.out.format("%9d %6d %6d %6d %10d %8d  ", operations, queued, scheduled, completed, time / 1000L, completed != 0L ? time / 1000L / completed : 0L);
            for (i = 0; i < 10; ++i) {
                System.out.format("%5d ", buckets[i]);
            }
            System.out.print(" |");
        }
    }

    public static interface TypeFlowRunnable
    extends CompletionExecutor.DebugContextRunnable {
        public TypeFlow<?> getTypeFlow();
    }
}

