/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.typestate.DefaultAnalysisContext;
import jdk.vm.ci.code.BytecodePosition;

public class DefaultAnalysisContextPolicy
extends AnalysisContextPolicy<DefaultAnalysisContext> {
    public DefaultAnalysisContextPolicy() {
        super(DefaultAnalysisContextPolicy.getEmptyContext());
    }

    private static DefaultAnalysisContext getEmptyContext() {
        return new DefaultAnalysisContext();
    }

    @Override
    public DefaultAnalysisContext peel(DefaultAnalysisContext context, int maxDepth) {
        assert (context.equals(this.emptyContext()));
        return context;
    }

    @Override
    public DefaultAnalysisContext calleeContext(PointsToAnalysis bb, AnalysisObject receiverObject, DefaultAnalysisContext callerContext, MethodTypeFlow callee) {
        assert (callerContext.equals(this.emptyContext()));
        assert (receiverObject.isContextInsensitiveObject());
        return callerContext;
    }

    @Override
    public DefaultAnalysisContext staticCalleeContext(PointsToAnalysis bb, BytecodePosition invokeLocation, DefaultAnalysisContext callerContext, MethodTypeFlow callee) {
        assert (callerContext.equals(this.emptyContext()));
        return callerContext;
    }

    @Override
    public DefaultAnalysisContext allocationContext(DefaultAnalysisContext context, int maxHeapContextDepth) {
        return this.peel(context, maxHeapContextDepth);
    }

    public DefaultAnalysisContext getContext(BytecodePosition bcl) {
        return this.getContext(new BytecodePosition[]{bcl});
    }

    public DefaultAnalysisContext getContext(BytecodePosition[] positions) {
        return this.lookupContext(positions);
    }

    private DefaultAnalysisContext lookupContext(BytecodePosition[] positions) {
        assert (positions.length == 0);
        return (DefaultAnalysisContext)this.emptyContext();
    }
}

