/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import jdk.vm.ci.meta.JavaConstant;

final class ImageHeapInstance
extends ImageHeapObject {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    private final Object[] values;

    ImageHeapInstance(JavaConstant object, int length) {
        super(object);
        this.values = new Object[length];
    }

    public void setFieldTask(AnalysisField field, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.values, field.getPosition(), task);
    }

    public void setFieldValue(AnalysisField field, JavaConstant value) {
        arrayHandle.setVolatile(this.values, field.getPosition(), value);
    }

    public Object getFieldValue(AnalysisField field) {
        return arrayHandle.getVolatile(this.values, field.getPosition());
    }
}

