/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.DirectInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;

final class BytecodeSensitiveStaticInvokeTypeFlow
extends AbstractStaticInvokeTypeFlow {
    private AnalysisContext calleeContext;
    private AnalysisContext callerContext;

    BytecodeSensitiveStaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn);
        this.calleeContext = null;
    }

    private BytecodeSensitiveStaticInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveStaticInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callerContext = ((MethodFlowsGraphClone)methodFlows).context();
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BytecodeSensitiveStaticInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        assert (this.isClone());
        JVMCIError.guarantee((this.callee == null ? 1 : 0) != 0, (String)"static invoke updated multiple times!", (Object[])new Object[0]);
        if (!this.targetMethod.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        ((DirectInvokeTypeFlow)this.originalInvoke).callee = this.callee = this.targetMethod.getTypeFlow();
        this.calleeContext = BytecodeSensitiveAnalysisPolicy.contextPolicy(bb).staticCalleeContext(bb, (BytecodePosition)this.source, (BytecodeAnalysisContext)this.callerContext, this.callee);
        MethodFlowsGraph calleeFlows = ((CallSiteSensitiveMethodTypeFlow)this.callee).addContext(bb, this.calleeContext, this);
        this.linkCallee(bb, true, calleeFlows);
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
        if (this.callee == null || this.calleeContext == null) {
            return Collections.emptyList();
        }
        MethodFlowsGraph methodFlows = ((CallSiteSensitiveMethodTypeFlow)this.callee).getFlows(this.calleeContext);
        return Collections.singletonList(methodFlows);
    }
}

