/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.EmptyTypeState;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.typestate.TypeStateUtils;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;

public class MultiTypeState
extends TypeState {
    protected final PointsToAnalysis bb;
    protected final AnalysisObject[] objects;
    protected int[] objectTypeIds;
    final BitSet typesBitSet;
    private final int typesCount;
    protected final boolean canBeNull;
    protected boolean merged;

    MultiTypeState(PointsToAnalysis bb, boolean canBeNull, int properties, BitSet typesBitSet, AnalysisObject ... objects) {
        super(properties);
        this.bb = bb;
        this.objects = objects;
        TypeStateUtils.trimBitSetToSize(typesBitSet);
        this.typesBitSet = typesBitSet;
        long cardinality = typesBitSet.cardinality();
        assert (cardinality < Integer.MAX_VALUE) : "We don't expect so much types.";
        this.typesCount = (int)cardinality;
        this.canBeNull = canBeNull;
        this.merged = false;
        assert (this.typesCount > 1) : "Multi type state with single type.";
        assert (objects.length > 1) : "Multi type state with single object.";
        assert (!bb.extendedAsserts() || this.checkObjects());
        PointsToStats.registerTypeState(bb, this);
    }

    private MultiTypeState(PointsToAnalysis bb, boolean canBeNull, MultiTypeState other) {
        super(other.properties);
        this.bb = bb;
        this.objects = other.objects;
        this.typesBitSet = other.typesBitSet;
        this.typesCount = other.typesCount;
        this.canBeNull = canBeNull;
        this.merged = other.merged;
        PointsToStats.registerTypeState(bb, this);
    }

    public int[] getObjectTypeIds() {
        if (this.objectTypeIds == null) {
            int[] result = new int[this.objects.length + 1];
            for (int i = 0; i < this.objects.length; ++i) {
                result[i] = this.objects[i].getTypeId();
            }
            this.objectTypeIds = result;
        }
        return this.objectTypeIds;
    }

    private boolean checkObjects() {
        assert (this.bb.extendedAsserts());
        for (int idx = 0; idx < this.objects.length - 1; ++idx) {
            AnalysisObject o0 = this.objects[idx];
            AnalysisObject o1 = this.objects[idx + 1];
            assert (o0 != null && o1 != null) : "Object state must contain non null elements.";
            assert (o0.type().equals(o1.type()) && o0.getId() < o1.getId() || o0.type().getId() < o1.type().getId()) : "Analysis objects must be sorted by type ID and ID.";
            assert (this.typesBitSet.get(o0.type().getId()));
            assert (this.typesBitSet.get(o1.type().getId()));
        }
        return true;
    }

    @Override
    public int objectsCount() {
        return this.objects.length;
    }

    @Override
    public final AnalysisObject[] objects() {
        return this.objects;
    }

    @Override
    public boolean hasExactTypes(BitSet inputTypesBitSet) {
        return this.typesBitSet.equals(inputTypesBitSet);
    }

    @Override
    public AnalysisType exactType() {
        return this.typesCount == 1 ? this.objects[0].type() : null;
    }

    @Override
    public int typesCount() {
        return this.typesCount;
    }

    AnalysisType firstType() {
        return this.objects[0].type();
    }

    AnalysisType lastType() {
        return this.objects[this.objects.length - 1].type();
    }

    @Override
    public Iterator<AnalysisType> typesIterator() {
        return new Iterator<AnalysisType>(){
            private int currentTypeId;
            {
                this.currentTypeId = MultiTypeState.this.typesBitSet.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.currentTypeId >= 0;
            }

            @Override
            public AnalysisType next() {
                AnalysisType next = MultiTypeState.this.bb.getUniverse().getType(this.currentTypeId);
                this.currentTypeId = MultiTypeState.this.typesBitSet.nextSetBit(this.currentTypeId + 1);
                return next;
            }
        };
    }

    @Override
    public boolean containsType(AnalysisType exactType) {
        return this.typesBitSet.get(exactType.getId());
    }

    @Override
    public TypeState exactTypeState(PointsToAnalysis unused, AnalysisType exactType) {
        if (this.containsType(exactType)) {
            AnalysisObject[] resultObjects = this.objectsArray(exactType);
            return new SingleTypeState(this.bb, this.canBeNull, this.bb.analysisPolicy().makeProperties(this.bb, resultObjects), resultObjects);
        }
        return EmptyTypeState.SINGLETON;
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis unused, boolean resultCanBeNull) {
        if (resultCanBeNull == this.canBeNull()) {
            return this;
        }
        return new MultiTypeState(this.bb, resultCanBeNull, this);
    }

    Range findTypeRange(AnalysisType type) {
        int lastIdx;
        int firstIdx;
        if (!this.containsType(type)) {
            return Range.EMPTY;
        }
        int someIdx = Arrays.binarySearch(this.objects, type.getContextInsensitiveAnalysisObject(), AnalysisObject.objectsTypeComparator);
        assert (someIdx >= 0) : "The inquired type must be in the array.";
        for (firstIdx = someIdx; firstIdx >= 0 && this.objects[firstIdx].getTypeId() == type.getId(); --firstIdx) {
        }
        for (lastIdx = someIdx; lastIdx < this.objects.length && this.objects[lastIdx].getTypeId() == type.getId(); ++lastIdx) {
        }
        return Range.range(firstIdx + 1, lastIdx);
    }

    @Override
    public AnalysisObject[] objectsArray(AnalysisType type) {
        Range typeRange = this.findTypeRange(type);
        return Arrays.copyOfRange(this.objects, typeRange.left, typeRange.right);
    }

    AnalysisObject[] objectsArray(Range typeRange) {
        return Arrays.copyOfRange(this.objects, typeRange.left, typeRange.right);
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(final AnalysisType exactType) {
        return new Iterator<AnalysisObject>(){
            private Range typeRange;
            private int idx;
            {
                this.typeRange = MultiTypeState.this.findTypeRange(exactType);
                this.idx = this.typeRange.left;
            }

            @Override
            public boolean hasNext() {
                return this.idx < this.typeRange.right;
            }

            @Override
            public AnalysisObject next() {
                return MultiTypeState.this.objects[this.idx++];
            }
        };
    }

    @Override
    public final boolean canBeNull() {
        return this.canBeNull;
    }

    @Override
    public void noteMerge(PointsToAnalysis unused) {
        assert (this.bb.analysisPolicy().isMergingEnabled());
        if (!this.merged) {
            for (AnalysisObject obj : this.objects) {
                obj.noteMerge(this.bb);
            }
            this.merged = true;
        }
    }

    @Override
    public boolean closeToAllInstantiated(BigBang unused) {
        if (this.typesCount > 200) {
            MultiTypeState allInstState = (MultiTypeState)this.bb.getAllInstantiatedTypes();
            return (long)this.typesCount * 100L / (long)allInstState.typesCount > 75L;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.objects);
        result = 31 * result + (this.canBeNull ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTypeState that = (MultiTypeState)o;
        return this.canBeNull == that.canBeNull && this.typesCount == that.typesCount && this.typesBitSet.equals(that.typesBitSet) && Arrays.equals(this.objects, that.objects);
    }

    public String toString() {
        return "MTypeMObject<" + this.objects.length + ":" + (this.canBeNull ? "null," : "") + Arrays.toString(this.objects) + ">";
    }

    public static class Range {
        static final Range EMPTY = new Range(0, 0);
        final int left;
        protected final int right;

        protected static Range range(int up, int low) {
            return new Range(up, low);
        }

        Range(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return "[" + this.left + ", " + this.right + ")";
        }
    }
}

