/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InitialParamTypeFlow;
import com.oracle.graal.pointsto.flow.InitialReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;

public class MethodTypeFlow
extends TypeFlow<AnalysisMethod> {
    protected MethodFlowsGraph originalMethodFlows;
    protected final ConcurrentMap<AnalysisContext, MethodFlowsGraph> clonedMethodFlows;
    private int localCallingContextDepth;
    private final AnalysisMethod method;
    private volatile boolean typeFlowCreated;
    private InvokeTypeFlow parsingReason;
    private ParameterNode returnedParameter;

    public MethodTypeFlow(OptionValues options, AnalysisMethod method) {
        super(method, null);
        this.method = method;
        this.localCallingContextDepth = (Integer)PointstoOptions.MaxCallingContextDepth.getValue(options);
        this.originalMethodFlows = new MethodFlowsGraph(method);
        this.clonedMethodFlows = new ConcurrentHashMap<AnalysisContext, MethodFlowsGraph>(4, 0.75f, 1);
    }

    public AnalysisMethod getMethod() {
        return this.method;
    }

    public InvokeTypeFlow getParsingReason() {
        return this.parsingReason;
    }

    public StackTraceElement[] getParsingContext() {
        ArrayList<StackTraceElement> parsingContext = new ArrayList<StackTraceElement>();
        InvokeTypeFlow invokeFlow = this.parsingReason;
        while (invokeFlow != null) {
            parsingContext.add(((BytecodePosition)invokeFlow.getSource()).getMethod().asStackTraceElement(((BytecodePosition)invokeFlow.getSource()).getBCI()));
            invokeFlow = ((AnalysisMethod)((BytecodePosition)invokeFlow.getSource()).getMethod()).getTypeFlow().parsingReason;
        }
        return parsingContext.toArray(new StackTraceElement[parsingContext.size()]);
    }

    public MethodFlowsGraph addContext(PointsToAnalysis bb, AnalysisContext calleeContext, InvokeTypeFlow reason) {
        this.ensureTypeFlowCreated(bb, reason);
        AnalysisContext newContext = bb.contextPolicy().peel(calleeContext, this.localCallingContextDepth);
        MethodFlowsGraph methodFlows = (MethodFlowsGraph)this.clonedMethodFlows.get(newContext);
        if (methodFlows == null) {
            MethodFlowsGraph newFlows = new MethodFlowsGraph(this.method, newContext);
            newFlows.cloneOriginalFlows(bb);
            MethodFlowsGraph oldFlows = this.clonedMethodFlows.putIfAbsent(newContext, newFlows);
            MethodFlowsGraph methodFlowsGraph = methodFlows = oldFlows != null ? oldFlows : newFlows;
            if (oldFlows == null) {
                methodFlows.linkClones(bb);
            }
        }
        return methodFlows;
    }

    public AnalysisContext[] getContexts() {
        Set contexts = this.clonedMethodFlows.keySet();
        return contexts.toArray(new AnalysisContext[contexts.size()]);
    }

    public int getLocalCallingContextDepth() {
        return this.localCallingContextDepth;
    }

    public Map<AnalysisContext, MethodFlowsGraph> getMethodContextFlows() {
        return this.clonedMethodFlows;
    }

    public Collection<MethodFlowsGraph> getFlows() {
        return this.clonedMethodFlows.values();
    }

    public MethodFlowsGraph getFlows(AnalysisContext calleeContext) {
        return (MethodFlowsGraph)this.clonedMethodFlows.get(calleeContext);
    }

    public void setResult(FormalReturnTypeFlow result) {
        this.originalMethodFlows.setResult(result);
    }

    public void setParameter(int index, FormalParamTypeFlow parameter) {
        this.originalMethodFlows.setParameter(index, parameter);
    }

    public void setInitialReceiverFlow(PointsToAnalysis bb, AnalysisType declaringType) {
        AllInstantiatedTypeFlow declaringTypeFlow = declaringType.getTypeFlow(bb, false);
        InitialReceiverTypeFlow initialReceiverFlow = new InitialReceiverTypeFlow(this.method, declaringType);
        declaringTypeFlow.addUse(bb, initialReceiverFlow);
        this.originalMethodFlows.setInitialParameterFlow(initialReceiverFlow, 0);
    }

    public void setInitialParameterFlow(PointsToAnalysis bb, AnalysisType declaredType, int i) {
        AllInstantiatedTypeFlow declaredTypeFlow = declaredType.getTypeFlow(bb, true);
        InitialParamTypeFlow initialParameterFlow = new InitialParamTypeFlow(this.method, declaredType, i);
        declaredTypeFlow.addUse(bb, initialParameterFlow);
        this.originalMethodFlows.setInitialParameterFlow(initialParameterFlow, i);
    }

    protected void addInstanceOf(Object key, InstanceOfTypeFlow instanceOf) {
        this.originalMethodFlows.addInstanceOf(key, instanceOf);
    }

    public void addNodeFlow(PointsToAnalysis bb, Node node, TypeFlow<?> input) {
        if (bb.strengthenGraalGraphs()) {
            this.originalMethodFlows.addNodeFlow(node, input);
        } else {
            this.originalMethodFlows.addMiscEntryFlow(input);
        }
    }

    public void addMiscEntry(TypeFlow<?> input) {
        this.originalMethodFlows.addMiscEntryFlow(input);
    }

    protected void addInvoke(Object key, InvokeTypeFlow invokeTypeFlow) {
        this.originalMethodFlows.addInvoke(key, invokeTypeFlow);
    }

    public MethodFlowsGraph getOriginalMethodFlows() {
        return this.originalMethodFlows;
    }

    public TypeState foldTypeFlow(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        if (originalTypeFlow == null) {
            return null;
        }
        TypeState result = TypeState.forEmpty();
        for (MethodFlowsGraph methodFlows : this.clonedMethodFlows.values()) {
            TypeFlow<?> clonedTypeFlow = methodFlows.lookupCloneOf(bb, originalTypeFlow);
            TypeState cloneState = clonedTypeFlow.getState();
            TypeState cloneStateCopy = TypeState.forContextInsensitiveTypeState(bb, cloneState);
            result = TypeState.forUnion(bb, result, cloneStateCopy);
        }
        return result;
    }

    public boolean isSaturated(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        boolean saturated = false;
        for (MethodFlowsGraph methodFlows : this.clonedMethodFlows.values()) {
            TypeFlow<?> clonedTypeFlow = methodFlows.lookupCloneOf(bb, originalTypeFlow);
            saturated |= clonedTypeFlow.isSaturated();
        }
        return saturated;
    }

    public FormalParamTypeFlow getParameterFlow(int idx) {
        return this.originalMethodFlows.getParameter(idx);
    }

    public TypeState getParameterTypeState(PointsToAnalysis bb, int parameter) {
        return this.foldTypeFlow(bb, this.originalMethodFlows.getParameter(parameter));
    }

    protected FormalReturnTypeFlow getResultFlow() {
        return this.originalMethodFlows.getResult();
    }

    public Collection<InvokeTypeFlow> getInvokes() {
        return this.originalMethodFlows.getInvokeFlows();
    }

    private static ParameterNode computeReturnedParameter(StructuredGraph graph) {
        if (graph == null) {
            return null;
        }
        ParameterNode retParam = null;
        for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
            if (!(param.stamp(NodeView.DEFAULT) instanceof ObjectStamp)) continue;
            boolean returnsParameter = true;
            NodeIterable retIterable = graph.getNodes(ReturnNode.TYPE);
            returnsParameter &= retIterable.count() > 0;
            for (ReturnNode ret : retIterable) {
                returnsParameter &= ret.result() == param;
            }
            if (!returnsParameter) continue;
            retParam = param;
        }
        return retParam;
    }

    public ParameterNode getReturnedParameter() {
        return this.returnedParameter;
    }

    public void ensureTypeFlowCreated(PointsToAnalysis bb, InvokeTypeFlow reason) {
        if (!this.typeFlowCreated) {
            this.createTypeFlow(bb, reason);
        }
    }

    private synchronized void createTypeFlow(PointsToAnalysis bb, InvokeTypeFlow reason) {
        if (!this.typeFlowCreated) {
            this.parsingReason = reason;
            StructuredGraph graph = null;
            try {
                MethodTypeFlowBuilder builder = bb.createMethodTypeFlowBuilder(bb, this);
                builder.apply();
                graph = builder.graph;
            }
            catch (BytecodeParser.BytecodeParserError ex) {
                if (ex.getCause() instanceof UnsupportedFeatureException) {
                    Throwable cause = ex;
                    if (ex.getCause().getCause() != null) {
                        cause = ex.getCause();
                    }
                    String message = cause.getMessage();
                    bb.getUnsupportedFeatures().addMessage(this.method.format("%H.%n(%p)"), this.method, message, ex.context(), cause.getCause());
                }
                throw AnalysisError.parsingError(this.method, ex);
            }
            catch (Throwable t) {
                throw AnalysisError.parsingError(this.method, t);
            }
            this.originalMethodFlows.linearizeGraph();
            bb.numParsedGraphs.incrementAndGet();
            this.returnedParameter = MethodTypeFlow.computeReturnedParameter(graph);
            this.typeFlowCreated = true;
        }
    }

    @Override
    public void update(PointsToAnalysis bb) {
        JVMCIError.shouldNotReachHere();
    }

    @Override
    public String toString() {
        return "MethodTypeFlow<" + this.method + ">";
    }
}

