/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnalysisObjectScanner
extends ObjectScanner {
    public AnalysisObjectScanner(BigBang bb, CompletionExecutor executor, ObjectScanner.ReusableSet scannedObjects) {
        super(bb, executor, scannedObjects);
    }

    @Override
    public void forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
        if (!field.isWritten()) {
            field.registerAsWritten(null);
        }
    }

    @Override
    public void forNullFieldValue(JavaConstant receiver, AnalysisField field) {
        FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
        if (!fieldTypeFlow.getState().canBeNull()) {
            fieldTypeFlow.addState(this.getAnalysis(), TypeState.forNull());
        }
    }

    @Override
    public void forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
        PointsToAnalysis analysis = this.getAnalysis();
        ResolvedJavaType fieldType = analysis.getMetaAccess().lookupJavaType((Class)analysis.getSnippetReflectionProvider().asObject(Object.class, fieldValue).getClass());
        assert (fieldType.isInstantiated()) : fieldType;
        FieldTypeFlow fieldTypeFlow = this.getFieldTypeFlow(field, receiver);
        AnalysisObject constantObject = this.bb.analysisPolicy().createConstantObject(analysis, fieldValue, (AnalysisType)fieldType);
        if (!fieldTypeFlow.getState().containsObject(constantObject)) {
            TypeState constantTypeState = TypeState.forNonNullObject(analysis, constantObject);
            fieldTypeFlow.addState(analysis, constantTypeState);
        }
    }

    private FieldTypeFlow getFieldTypeFlow(AnalysisField field, JavaConstant receiver) {
        if (field.isStatic()) {
            return field.getStaticFieldFlow();
        }
        PointsToAnalysis analysis = this.getAnalysis();
        ResolvedJavaType receiverType = analysis.getMetaAccess().lookupJavaType((Class)analysis.getSnippetReflectionProvider().asObject(Object.class, receiver).getClass());
        AnalysisObject constantReceiverObj = analysis.analysisPolicy().createConstantObject(analysis, receiver, (AnalysisType)receiverType);
        return constantReceiverObj.getInstanceFieldFlow(analysis, field, true);
    }

    @Override
    public void forNullArrayElement(JavaConstant array, AnalysisType arrayType, int elementIndex) {
        ArrayElementsTypeFlow arrayObjElementsFlow = this.getArrayElementsFlow(array, arrayType);
        if (!arrayObjElementsFlow.getState().canBeNull()) {
            arrayObjElementsFlow.addState(this.getAnalysis(), TypeState.forNull());
        }
    }

    @Override
    public void forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int elementIndex) {
        assert (elementType.isInstantiated()) : elementType;
        ArrayElementsTypeFlow arrayObjElementsFlow = this.getArrayElementsFlow(array, arrayType);
        PointsToAnalysis analysis = this.getAnalysis();
        AnalysisObject constantObject = this.bb.analysisPolicy().createConstantObject(analysis, elementConstant, elementType);
        if (!arrayObjElementsFlow.getState().containsObject(constantObject)) {
            TypeState elementTypeState = TypeState.forNonNullObject(analysis, constantObject);
            arrayObjElementsFlow.addState(analysis, elementTypeState);
        }
    }

    private ArrayElementsTypeFlow getArrayElementsFlow(JavaConstant array, AnalysisType arrayType) {
        PointsToAnalysis analysis = this.getAnalysis();
        AnalysisObject arrayObjConstant = analysis.analysisPolicy().createConstantObject(analysis, array, arrayType);
        return arrayObjConstant.getArrayElementsFlow(analysis, true);
    }

    @Override
    protected void forScannedConstant(JavaConstant value, ObjectScanner.ScanReason reason) {
        PointsToAnalysis analysis = this.getAnalysis();
        Object valueObj = analysis.getSnippetReflectionProvider().asObject(Object.class, value);
        ResolvedJavaType type = this.bb.getMetaAccess().lookupJavaType((Class)valueObj.getClass());
        type.registerAsInHeap();
    }

    private PointsToAnalysis getAnalysis() {
        return (PointsToAnalysis)this.bb;
    }
}

