/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.plugins;

import com.oracle.graal.pointsto.nodes.AnalysisArraysCopyOfNode;
import com.oracle.graal.pointsto.nodes.AnalysisObjectCloneNode;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.replacements.nodes.BasicArrayCopyNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;

public class PointstoGraphBuilderPlugins {
    public static void registerArraysPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Arrays.class).setAllowOverwrite(true);
        r.register2("copyOf", Object[].class, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode original, ValueNode newLength) {
                b.addPush(JavaKind.Object, (ValueNode)new AnalysisArraysCopyOfNode(b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp(), original, newLength));
                return true;
            }
        });
        r.register3("copyOf", Object[].class, Integer.TYPE, Class.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode original, ValueNode newLength, ValueNode newObjectElementType) {
                if (newObjectElementType instanceof GetClassNode || newObjectElementType.isConstant()) {
                    b.addPush(JavaKind.Object, (ValueNode)new AnalysisArraysCopyOfNode(b.getInvokeReturnStamp(b.getAssumptions()).getTrustedStamp(), original, newLength, newObjectElementType));
                    return true;
                }
                return false;
            }
        });
    }

    public static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, System.class).setAllowOverwrite(true);
        r.register5("arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length) {
                b.add((ValueNode)new BasicArrayCopyNode(BasicArrayCopyNode.TYPE, src, srcPos, dest, destPos, length, null, b.bci()));
                return true;
            }
        });
    }

    public static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Object.class);
        r.register1("clone", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, (ValueNode)new AnalysisObjectCloneNode(MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[]{object})));
                return true;
            }
        });
    }
}

