/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public interface OriginalFieldProvider {
    public static Field getJavaField(SnippetReflectionProvider reflectionProvider, ResolvedJavaField field) {
        if (field instanceof OriginalFieldProvider) {
            return ((OriginalFieldProvider)field).getJavaField();
        }
        try {
            Class<?> declaringClass = OriginalClassProvider.getJavaClass(reflectionProvider, field.getDeclaringClass());
            return declaringClass.getDeclaredField(field.getName());
        }
        catch (NoSuchFieldException e) {
            throw AnalysisError.shouldNotReachHere();
        }
    }

    public Field getJavaField();
}

