/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnknownTypeFlow;
import com.oracle.graal.pointsto.typestate.TypeState;
import org.graalvm.compiler.graph.Node;

public class ProxyTypeFlow
extends TypeFlow<Node> {
    protected TypeFlow<?> input;

    public ProxyTypeFlow(Node source, TypeFlow<?> input) {
        super(source, null);
        assert (input instanceof AllInstantiatedTypeFlow || input instanceof UnknownTypeFlow);
        this.input = input;
    }

    public ProxyTypeFlow(ProxyTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.input = original.input;
    }

    @Override
    public TypeFlow<Node> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return new ProxyTypeFlow(this, methodFlows);
    }

    @Override
    public void initClone(BigBang bb) {
        assert (this.isClone());
        this.input.addUse(bb, this);
    }

    @Override
    public boolean addState(BigBang bb, TypeState add) {
        assert (this.isClone());
        bb.postFlow(this);
        return true;
    }

    @Override
    public void update(BigBang bb) {
        TypeState curState = this.input.getState();
        for (TypeFlow<?> use : this.getUses()) {
            use.addState(bb, curState);
        }
        this.notifyObservers(bb);
    }

    @Override
    public boolean addUse(BigBang bb, TypeFlow<?> use) {
        assert (use != null);
        if (this.doAddUse(bb, use, false)) {
            use.addState(bb, this.input.getState());
            return true;
        }
        return false;
    }

    @Override
    public TypeState getState() {
        return this.input.getState();
    }

    public TypeFlow<?> getInput() {
        return this.input;
    }

    @Override
    public String toString() {
        return "ProxyTypeFlow<" + this.input + ">";
    }
}

