/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.SectionName;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVLineRecord;
import com.oracle.objectfile.pecoff.cv.CVLineRecordBuilder;
import com.oracle.objectfile.pecoff.cv.CVNames;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubrecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubsection;
import java.lang.reflect.Modifier;

final class CVSymbolSubsectionBuilder {
    private final CVDebugInfo cvDebugInfo;
    private final CVSymbolSubsection cvSymbolSubsection;
    private final CVLineRecordBuilder lineRecordBuilder;
    private final String heapName;
    private final short heapRegister;

    CVSymbolSubsectionBuilder(CVDebugInfo cvDebugInfo) {
        this.cvDebugInfo = cvDebugInfo;
        this.cvSymbolSubsection = new CVSymbolSubsection(cvDebugInfo);
        this.lineRecordBuilder = new CVLineRecordBuilder(cvDebugInfo);
        this.heapName = SectionName.SVM_HEAP.getFormatDependentName(cvDebugInfo.getCVSymbolSection().getOwner().getFormat());
        assert (8 <= cvDebugInfo.getHeapbaseRegister() && cvDebugInfo.getHeapbaseRegister() <= 15);
        this.heapRegister = (short)(336 + cvDebugInfo.getHeapbaseRegister() - 8);
    }

    void build() {
        for (TypeEntry typeEntry : this.cvDebugInfo.getTypes()) {
            if (typeEntry.isClass()) {
                this.buildClass((ClassEntry)typeEntry);
                continue;
            }
            this.addTypeRecords(typeEntry);
        }
        this.cvDebugInfo.getCVSymbolSection().addRecord(this.cvSymbolSubsection);
    }

    private void buildClass(ClassEntry classEntry) {
        classEntry.compiledEntries().forEach(this::buildFunction);
        this.addTypeRecords(classEntry);
        classEntry.fields().filter(CVSymbolSubsectionBuilder::isManifestedStaticField).forEach(f -> {
            int typeIndex = this.cvDebugInfo.getCVTypeSection().getIndexForPointer(f.getValueType());
            String displayName = CVNames.fieldNameToCodeViewName(f);
            if (this.cvDebugInfo.useHeapBase()) {
                this.addSymbolRecord(new CVSymbolSubrecord.CVSymbolRegRel32Record(this.cvDebugInfo, displayName, typeIndex, f.getOffset(), this.heapRegister));
            } else {
                this.addSymbolRecord(new CVSymbolSubrecord.CVSymbolGData32Record(this.cvDebugInfo, this.heapName, displayName, typeIndex, f.getOffset(), 0));
            }
        });
    }

    private static boolean isManifestedStaticField(FieldEntry fieldEntry) {
        return Modifier.isStatic(fieldEntry.getModifiers()) && fieldEntry.getOffset() >= 0;
    }

    private void buildFunction(CompiledMethodEntry compiledEntry) {
        PrimaryRange primaryRange = compiledEntry.getPrimary();
        String debuggerName = CVNames.methodNameToCodeViewName(primaryRange.getMethodEntry());
        String externalName = primaryRange.getSymbolName();
        int functionTypeIndex = this.addTypeRecords(compiledEntry);
        byte funcFlags = 0;
        CVSymbolSubrecord.CVSymbolGProc32Record proc32 = new CVSymbolSubrecord.CVSymbolGProc32Record(this.cvDebugInfo, externalName, debuggerName, 0, 0, 0, primaryRange.getHi() - primaryRange.getLo(), 0, 0, functionTypeIndex, 0, funcFlags);
        this.addSymbolRecord(proc32);
        int asynceh = 512;
        int localBP = 16384;
        int paramBP = 65536;
        int frameFlags = asynceh + localBP + paramBP;
        this.addSymbolRecord(new CVSymbolSubrecord.CVSymbolFrameProcRecord(this.cvDebugInfo, compiledEntry.getFrameSize(), frameFlags));
        this.addSymbolRecord(new CVSymbolSubrecord.CVSymbolEndRecord(this.cvDebugInfo));
        this.addLineNumberRecords(compiledEntry);
    }

    private void addLineNumberRecords(CompiledMethodEntry compiledEntry) {
        CVLineRecord record = this.lineRecordBuilder.build(compiledEntry);
        if (!record.isEmpty()) {
            this.cvDebugInfo.getCVSymbolSection().addRecord(record);
        }
    }

    private void addSymbolRecord(CVSymbolSubrecord record) {
        this.cvSymbolSubsection.addRecord(record);
    }

    private void addTypeRecords(TypeEntry typeEntry) {
        int typeIdx = this.cvDebugInfo.getCVTypeSection().addTypeRecords(typeEntry).getSequenceNumber();
        if (typeIdx > 4095) {
            CVSymbolSubrecord.CVSymbolUDTRecord udtRecord = new CVSymbolSubrecord.CVSymbolUDTRecord(this.cvDebugInfo, typeIdx, CVNames.typeNameToCodeViewName(typeEntry.getTypeName()));
            this.addSymbolRecord(udtRecord);
        }
    }

    private int addTypeRecords(CompiledMethodEntry entry) {
        return this.cvDebugInfo.getCVTypeSection().addTypeRecords(entry).getSequenceNumber();
    }
}

