/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.pecoff.PECoffMachine;
import com.oracle.objectfile.pecoff.cv.CVSymbolSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVTypeSectionImpl;
import java.nio.ByteOrder;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;

public final class CVDebugInfo
extends DebugInfoBase {
    private final CVSymbolSectionImpl cvSymbolSection = new CVSymbolSectionImpl(this);
    private final CVTypeSectionImpl cvTypeSection = new CVTypeSectionImpl(this);
    private DebugContext debugContext;
    public static final byte RHEAPBASE_X86 = 14;
    public static final byte RTHREAD_X86 = 15;
    private final byte heapbaseRegister;
    private final byte threadRegister;

    public CVDebugInfo(PECoffMachine machine, ByteOrder byteOrder) {
        super(byteOrder);
        if (machine != PECoffMachine.X86_64) {
            throw GraalError.shouldNotReachHere((String)"Unsupported architecture on Windows");
        }
        this.heapbaseRegister = (byte)14;
        this.threadRegister = (byte)15;
    }

    public CVSymbolSectionImpl getCVSymbolSection() {
        return this.cvSymbolSection;
    }

    public CVTypeSectionImpl getCVTypeSection() {
        return this.cvTypeSection;
    }

    public byte getHeapbaseRegister() {
        return this.heapbaseRegister;
    }

    public byte getThreadRegister() {
        return this.threadRegister;
    }

    public DebugContext getDebugContext() {
        return this.debugContext;
    }

    void setDebugContext(DebugContext debugContext) {
        this.debugContext = debugContext;
    }
}

