/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class StructureTypeEntry
extends TypeEntry {
    protected final List<FieldEntry> fields = new ArrayList<FieldEntry>();
    protected long layoutTypeSignature = 0L;

    public StructureTypeEntry(String typeName, int size) {
        super(typeName, size);
    }

    public long getLayoutTypeSignature() {
        return this.layoutTypeSignature;
    }

    public Stream<FieldEntry> fields() {
        return this.fields.stream();
    }

    public int fieldCount() {
        return this.fields.size();
    }

    protected void processField(DebugInfoProvider.DebugFieldInfo debugFieldInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        FieldEntry fieldEntry = this.createField(debugFieldInfo, debugInfoBase, debugContext);
        this.fields.add(fieldEntry);
    }

    protected FieldEntry createField(DebugInfoProvider.DebugFieldInfo debugFieldInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        String fieldName = debugInfoBase.uniqueDebugString(debugFieldInfo.name());
        ResolvedJavaType valueType = debugFieldInfo.valueType();
        String valueTypeName = valueType.toJavaName();
        int fieldSize = debugFieldInfo.size();
        int fieldoffset = debugFieldInfo.offset();
        boolean fieldIsEmbedded = debugFieldInfo.isEmbedded();
        int fieldModifiers = debugFieldInfo.modifiers();
        if (debugContext.isLogEnabled()) {
            debugContext.log("typename %s adding %s field %s type %s%s size %s at offset 0x%x%n", (Object)this.typeName, (Object)this.memberModifiers(fieldModifiers), (Object)fieldName, (Object)valueTypeName, (Object)(fieldIsEmbedded ? "(embedded)" : ""), (Object)fieldSize, (Object)fieldoffset);
        }
        TypeEntry valueTypeEntry = debugInfoBase.lookupTypeEntry(valueType);
        FileEntry fileEntry = debugInfoBase.ensureFileEntry(debugFieldInfo);
        return new FieldEntry(fileEntry, fieldName, this, valueTypeEntry, fieldSize, fieldoffset, fieldIsEmbedded, fieldModifiers);
    }

    String memberModifiers(int modifiers) {
        StringBuilder builder = new StringBuilder();
        if (Modifier.isPublic(modifiers)) {
            builder.append("public ");
        } else if (Modifier.isProtected(modifiers)) {
            builder.append("protected ");
        } else if (Modifier.isPrivate(modifiers)) {
            builder.append("private ");
        }
        if (Modifier.isFinal(modifiers)) {
            builder.append("final ");
        }
        if (Modifier.isAbstract(modifiers)) {
            builder.append("abstract ");
        } else if (Modifier.isVolatile(modifiers)) {
            builder.append("volatile ");
        } else if (Modifier.isTransient(modifiers)) {
            builder.append("transient ");
        } else if (Modifier.isSynchronized(modifiers)) {
            builder.append("synchronized ");
        }
        if (Modifier.isNative(modifiers)) {
            builder.append("native ");
        }
        if (Modifier.isStatic(modifiers)) {
            builder.append("static");
        } else {
            builder.append("instance");
        }
        return builder.toString();
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        super.addDebugInfo(debugInfoBase, debugTypeInfo, debugContext);
        this.layoutTypeSignature = this instanceof HeaderTypeEntry ? this.typeSignature : debugTypeInfo.typeSignature("_layout_.");
    }
}

