/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.io;

import com.oracle.objectfile.io.InputDisassembler;
import com.oracle.objectfile.io.OutputAssembler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public class AssemblyBuffer
implements InputDisassembler,
OutputAssembler {
    private static final double GROWTH_FACTOR = 2.0;
    public static final int INITIAL_STRING_SIZE = 64;
    ByteBuffer buf;
    private Deque<Long> seekStack = new ArrayDeque<Long>();

    public static InputDisassembler createInputDisassembler(ByteBuffer in) {
        return new AssemblyBuffer(in);
    }

    public static AssemblyBuffer createOutputAssembler(ByteBuffer out) {
        return new AssemblyBuffer(out);
    }

    public static AssemblyBuffer createOutputAssembler(ByteOrder order) {
        return new AssemblyBuffer(order);
    }

    public static AssemblyBuffer createOutputAssembler() {
        return new AssemblyBuffer();
    }

    public AssemblyBuffer(ByteBuffer in) {
        this.buf = in;
    }

    public AssemblyBuffer(ByteOrder order) {
        this(ByteBuffer.allocate(16).order(order));
    }

    public AssemblyBuffer() {
        this(ByteOrder.nativeOrder());
    }

    @Override
    public boolean eof() {
        return !this.buf.hasRemaining();
    }

    @Override
    public void seek(long pos) {
        if (pos > (long)this.pos()) {
            this.ensure((int)(pos - (long)this.pos()));
        }
        this.buf.position((int)pos);
    }

    @Override
    public void skip(long diff) {
        this.seek((long)this.pos() + diff);
    }

    @Override
    public void pushSeek(long pos) {
        this.seekStack.push(Long.valueOf(this.pos()));
        this.seek(pos);
    }

    @Override
    public void pushSkip(long diff) {
        this.seekStack.push(Long.valueOf(this.pos()));
        this.seek((long)this.pos() + diff);
    }

    @Override
    public void pushPos() {
        this.seekStack.push(Long.valueOf(this.pos()));
    }

    @Override
    public void pop() {
        this.seek(this.seekStack.pop());
    }

    @Override
    public int pos() {
        return this.buf.position();
    }

    @Override
    public void align(int alignment) {
        while (this.pos() % alignment != 0) {
            this.ensure(1);
            this.skip(1);
        }
    }

    @Override
    public void even() {
        this.align(2);
    }

    @Override
    public void writeZero(int n) {
        for (int i = 0; i < n; ++i) {
            this.writeByte((byte)0);
        }
    }

    @Override
    public void writeLEB128(long v) {
        long vv = v;
        if (vv == 0L) {
            this.writeByte((byte)0);
            return;
        }
        do {
            byte b = (byte)(vv & 0x7FL);
            if ((vv >>= 7) != 0L) {
                b = (byte)(b | 0xFFFFFF80);
            }
            this.writeByte(b);
        } while (vv != 0L);
    }

    @Override
    public void writeSLEB128(long v) {
        long vv = v;
        boolean more = true;
        while (more) {
            byte b = (byte)(vv & 0x7FL);
            if ((vv >>= 7) == 0L && (b & 0x40) == 0 || vv == -1L && (b & 0x40) == 64) {
                more = false;
            } else {
                b = (byte)(b | 0xFFFFFF80);
            }
            this.writeByte(b);
        }
    }

    @Override
    public void writeBCD(double f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeFloat(float f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDouble(double f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeByte(byte b) {
        this.ensure(1);
        this.buf.put(b);
    }

    @Override
    public void write4Byte(int w) {
        this.ensure(4);
        this.buf.putInt(w);
    }

    @Override
    public void writeBlob(byte[] blob) {
        this.ensure(blob.length);
        this.buf.put(blob);
    }

    @Override
    public void write2Byte(short i) {
        this.ensure(2);
        this.buf.putShort(i);
    }

    @Override
    public void writeValue(short i) {
        this.write2Byte(i);
    }

    @Override
    public void write8Byte(long w) {
        this.ensure(8);
        this.buf.putLong(w);
    }

    @Override
    public void writeQuad(long w) {
        this.write8Byte(w);
    }

    @Override
    public void writeString(String s) {
        if (s != null) {
            this.writeBlob(s.getBytes());
        }
        this.writeByte((byte)0);
    }

    @Override
    public void writeStringPadded(String s, int nBytes) {
        this.ensure(nBytes);
        assert (s == null || s.length() < nBytes) : "string oversize: " + s;
        this.writeString(s);
        int pad = nBytes - (s == null ? 0 : s.length()) - 1;
        for (int i = 0; i < pad; ++i) {
            this.writeByte((byte)0);
        }
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buf;
    }

    private void ensure(int n) {
        if (this.buf.remaining() < n) {
            int cap = this.buf.capacity();
            int pos = this.buf.position();
            int req = pos + n;
            int newCap = (int)((double)cap * 2.0);
            while (newCap < req) {
                newCap = (int)((double)newCap * 2.0);
            }
            this.buf = ByteBuffer.wrap(Arrays.copyOf(this.buf.array(), newCap));
            this.buf.order(ByteOrder.nativeOrder());
            this.buf.position(pos);
        }
    }

    @Override
    public byte[] getBlob() {
        return this.getBlob(false);
    }

    public byte[] getBlob(boolean consume) {
        byte[] array = this.buf.array();
        int position = this.buf.position();
        if (consume) {
            this.buf = null;
        }
        return Arrays.copyOf(array, position);
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
    }

    @Override
    public void skip(int n) {
        this.ensure(n);
        this.seek(this.pos() + n);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buf.order();
    }

    @Override
    public void alignRead(int alignment) {
        while (this.pos() % alignment != 0) {
            this.buf.get();
        }
    }

    @Override
    public int read4Byte() {
        return this.buf.getInt();
    }

    @Override
    public byte readByte() {
        return this.buf.get();
    }

    @Override
    public char readUbyte() {
        return (char)(this.buf.get() & 0xFF);
    }

    @Override
    public short read2Byte() {
        return this.buf.getShort();
    }

    @Override
    public short readValue() {
        return this.read2Byte();
    }

    @Override
    public long read8Byte() {
        return this.buf.getLong();
    }

    @Override
    public long readQuad() {
        return this.read8Byte();
    }

    @Override
    public void writeTruncatedLong(long value, int truncateTo) {
        switch (truncateTo) {
            case 8: {
                this.write8Byte(value);
                break;
            }
            case 4: {
                this.write4Byte((int)value);
                break;
            }
            case 2: {
                this.write2Byte((short)value);
                break;
            }
            case 1: {
                this.writeByte((byte)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only truncate to powers-of-two <= 8");
            }
        }
    }

    @Override
    public long readTruncatedLong(int truncateTo) {
        switch (truncateTo) {
            case 8: {
                return this.read8Byte();
            }
            case 4: {
                return this.read4Byte();
            }
            case 2: {
                return this.read2Byte();
            }
            case 1: {
                return this.readUbyte();
            }
        }
        throw new IllegalArgumentException("Can only truncate to powers-of-two <= 8");
    }

    @Override
    public String readZeroTerminatedString() {
        char[] buffer = new char[64];
        int w = 1;
        buffer[0] = (char)this.buf.get();
        if (buffer[0] == '\u0000') {
            return "";
        }
        do {
            if (w == buffer.length) {
                buffer = Arrays.copyOf(buffer, 2 * buffer.length);
            }
            buffer[w] = (char)this.buf.get();
        } while (buffer[w++] != '\u0000');
        return String.valueOf(buffer, 0, w - 1);
    }

    @Override
    public long readLEB128() {
        long b = this.buf.get();
        if (b == 0L) {
            return 0L;
        }
        long r = 0L;
        int shift = 0;
        while ((b & 0x80L) != 0L) {
            r |= (b & 0x7FL) << shift;
            shift += 7;
            b = this.buf.get();
        }
        return r |= b << shift;
    }

    @Override
    public long readSLEB128() {
        byte b;
        long r = 0L;
        int shift = 0;
        do {
            b = this.buf.get();
            r |= (long)((b & 0x7F) << shift);
            shift += 7;
        } while ((b & 0x80) != 0);
        if (shift < 64 && (b & 0x40) == 64) {
            r |= (long)(-(1 << shift));
        }
        return r;
    }

    @Override
    public byte[] readBlob(int length) {
        byte[] blob = new byte[length];
        this.buf.get(blob);
        return blob;
    }
}

