/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.ELFMachine;
import com.oracle.objectfile.elf.dwarf.DwarfARangesSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfAbbrevSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImplAArch64;
import com.oracle.objectfile.elf.dwarf.DwarfFrameSectionImplX86_64;
import com.oracle.objectfile.elf.dwarf.DwarfInfoSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfLineSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfLocSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfRangesSectionImpl;
import com.oracle.objectfile.elf.dwarf.DwarfStrSectionImpl;
import com.oracle.objectfile.elf.dwarf.constants.DwarfLanguage;
import java.nio.ByteOrder;
import org.graalvm.collections.EconomicMap;

public class DwarfDebugInfo
extends DebugInfoBase {
    public static final String HEAP_BEGIN_NAME = "__svm_heap_begin";
    public static final DwarfLanguage LANG_ENCODING = DwarfLanguage.DW_LANG_Java;
    public static final byte rheapbase_aarch64 = 27;
    public static final byte rthread_aarch64 = 28;
    public static final byte rheapbase_x86 = 14;
    public static final byte rthread_x86 = 15;
    public static final String INDIRECT_PREFIX = "_z_.";
    public static final String HUB_TYPE_NAME = "java.lang.Class";
    private final DwarfStrSectionImpl dwarfStrSection;
    private final DwarfAbbrevSectionImpl dwarfAbbrevSection;
    private final DwarfInfoSectionImpl dwarfInfoSection;
    private final DwarfLocSectionImpl dwarfLocSection;
    private final DwarfARangesSectionImpl dwarfARangesSection;
    private final DwarfRangesSectionImpl dwarfRangesSection;
    private final DwarfLineSectionImpl dwarfLineSection;
    private final DwarfFrameSectionImpl dwarfFameSection;
    public final ELFMachine elfMachine;
    private final byte heapbaseRegister;
    private final byte threadRegister;
    private final EconomicMap<TypeEntry, DwarfTypeProperties> typePropertiesIndex = EconomicMap.create();
    private final EconomicMap<MethodEntry, DwarfMethodProperties> methodPropertiesIndex = EconomicMap.create();
    private final EconomicMap<Range, DwarfLocalProperties> rangeLocalPropertiesIndex = EconomicMap.create();

    public DwarfDebugInfo(ELFMachine elfMachine, ByteOrder byteOrder) {
        super(byteOrder);
        this.elfMachine = elfMachine;
        this.dwarfStrSection = new DwarfStrSectionImpl(this);
        this.dwarfAbbrevSection = new DwarfAbbrevSectionImpl(this);
        this.dwarfInfoSection = new DwarfInfoSectionImpl(this);
        this.dwarfLocSection = new DwarfLocSectionImpl(this);
        this.dwarfARangesSection = new DwarfARangesSectionImpl(this);
        this.dwarfRangesSection = new DwarfRangesSectionImpl(this);
        this.dwarfLineSection = new DwarfLineSectionImpl(this);
        if (elfMachine == ELFMachine.AArch64) {
            this.dwarfFameSection = new DwarfFrameSectionImplAArch64(this);
            this.heapbaseRegister = (byte)27;
            this.threadRegister = (byte)28;
        } else {
            this.dwarfFameSection = new DwarfFrameSectionImplX86_64(this);
            this.heapbaseRegister = (byte)14;
            this.threadRegister = (byte)15;
        }
    }

    public DwarfStrSectionImpl getStrSectionImpl() {
        return this.dwarfStrSection;
    }

    public DwarfAbbrevSectionImpl getAbbrevSectionImpl() {
        return this.dwarfAbbrevSection;
    }

    public DwarfFrameSectionImpl getFrameSectionImpl() {
        return this.dwarfFameSection;
    }

    public DwarfInfoSectionImpl getInfoSectionImpl() {
        return this.dwarfInfoSection;
    }

    public DwarfLocSectionImpl getLocSectionImpl() {
        return this.dwarfLocSection;
    }

    public DwarfARangesSectionImpl getARangesSectionImpl() {
        return this.dwarfARangesSection;
    }

    public DwarfRangesSectionImpl getRangesSectionImpl() {
        return this.dwarfRangesSection;
    }

    public DwarfLineSectionImpl getLineSectionImpl() {
        return this.dwarfLineSection;
    }

    public byte getHeapbaseRegister() {
        return this.heapbaseRegister;
    }

    public byte getThreadRegister() {
        return this.threadRegister;
    }

    private DwarfTypeProperties addTypeProperties(TypeEntry typeEntry) {
        assert (typeEntry != null);
        assert (!typeEntry.isClass());
        assert (this.typePropertiesIndex.get((Object)typeEntry) == null);
        DwarfTypeProperties typeProperties = new DwarfTypeProperties(typeEntry);
        this.typePropertiesIndex.put((Object)typeEntry, (Object)typeProperties);
        return typeProperties;
    }

    private DwarfClassProperties addClassProperties(StructureTypeEntry entry) {
        assert (this.typePropertiesIndex.get((Object)entry) == null);
        DwarfClassProperties classProperties = new DwarfClassProperties(entry);
        this.typePropertiesIndex.put((Object)entry, (Object)classProperties);
        return classProperties;
    }

    private DwarfMethodProperties addMethodProperties(MethodEntry methodEntry) {
        assert (this.methodPropertiesIndex.get((Object)methodEntry) == null);
        DwarfMethodProperties methodProperties = new DwarfMethodProperties();
        this.methodPropertiesIndex.put((Object)methodEntry, (Object)methodProperties);
        return methodProperties;
    }

    private DwarfTypeProperties lookupTypeProperties(TypeEntry typeEntry) {
        if (typeEntry instanceof ClassEntry) {
            return this.lookupClassProperties((ClassEntry)typeEntry);
        }
        DwarfTypeProperties typeProperties = (DwarfTypeProperties)this.typePropertiesIndex.get((Object)typeEntry);
        if (typeProperties == null) {
            typeProperties = this.addTypeProperties(typeEntry);
        }
        return typeProperties;
    }

    private DwarfClassProperties lookupClassProperties(StructureTypeEntry entry) {
        DwarfTypeProperties typeProperties = (DwarfTypeProperties)this.typePropertiesIndex.get((Object)entry);
        assert (typeProperties == null || typeProperties instanceof DwarfClassProperties);
        DwarfClassProperties classProperties = (DwarfClassProperties)typeProperties;
        if (classProperties == null) {
            classProperties = this.addClassProperties(entry);
        }
        return classProperties;
    }

    private DwarfMethodProperties lookupMethodProperties(MethodEntry methodEntry) {
        DwarfMethodProperties methodProperties = (DwarfMethodProperties)this.methodPropertiesIndex.get((Object)methodEntry);
        if (methodProperties == null) {
            methodProperties = this.addMethodProperties(methodEntry);
        }
        return methodProperties;
    }

    void setTypeIndex(TypeEntry typeEntry, int idx) {
        assert (idx >= 0);
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        assert (typeProperties.getTypeInfoIndex() == -1 || typeProperties.getTypeInfoIndex() == idx);
        typeProperties.setTypeInfoIndex(idx);
    }

    int getTypeIndex(TypeEntry typeEntry) {
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        return this.getTypeIndex(typeProperties);
    }

    int getTypeIndex(DwarfTypeProperties typeProperties) {
        assert (typeProperties.getTypeInfoIndex() >= 0);
        return typeProperties.getTypeInfoIndex();
    }

    void setIndirectTypeIndex(TypeEntry typeEntry, int idx) {
        assert (idx >= 0);
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        assert (typeProperties.getIndirectTypeInfoIndex() == -1 || typeProperties.getIndirectTypeInfoIndex() == idx);
        typeProperties.setIndirectTypeInfoIndex(idx);
    }

    int getIndirectTypeIndex(TypeEntry typeEntry) {
        DwarfTypeProperties typeProperties = this.lookupTypeProperties(typeEntry);
        return this.getIndirectTypeIndex(typeProperties);
    }

    int getIndirectTypeIndex(DwarfTypeProperties typeProperties) {
        assert (typeProperties.getIndirectTypeInfoIndex() >= 0);
        return typeProperties.getIndirectTypeInfoIndex();
    }

    public void setCUIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.cuIndex == -1 || classProperties.cuIndex == idx);
        classProperties.cuIndex = idx;
    }

    public int getCUIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.cuIndex >= 0);
        return classProperties.cuIndex;
    }

    void setLayoutIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0 || idx == -1);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.layoutIndex == -1 || classProperties.layoutIndex == idx);
        classProperties.layoutIndex = idx;
    }

    int getLayoutIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.layoutIndex >= 0);
        return classProperties.layoutIndex;
    }

    void setIndirectLayoutIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0 || idx == -1);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.indirectLayoutIndex == -1 || classProperties.indirectLayoutIndex == idx);
        classProperties.indirectLayoutIndex = idx;
    }

    int getIndirectLayoutIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.indirectLayoutIndex >= 0);
        return classProperties.indirectLayoutIndex;
    }

    public void setCodeRangesIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.codeRangesIndex == -1 || classProperties.codeRangesIndex == idx);
        classProperties.codeRangesIndex = idx;
    }

    public int getCodeRangesIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.codeRangesIndex >= 0);
        return classProperties.codeRangesIndex;
    }

    public void setLineIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineIndex == -1 || classProperties.lineIndex == idx);
        classProperties.lineIndex = idx;
    }

    public int getLineIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineIndex >= 0);
        return classProperties.lineIndex;
    }

    public void setLinePrologueSize(ClassEntry classEntry, int size) {
        assert (size >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.linePrologueSize == -1 || classProperties.linePrologueSize == size);
        classProperties.linePrologueSize = size;
    }

    public int getLinePrologueSize(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.linePrologueSize >= 0);
        return classProperties.linePrologueSize;
    }

    public void setFieldDeclarationIndex(StructureTypeEntry entry, String fieldName, int pos) {
        DwarfClassProperties classProperties = this.lookupClassProperties(entry);
        assert (classProperties.getTypeEntry() == entry);
        EconomicMap fieldDeclarationIndex = classProperties.fieldDeclarationIndex;
        if (fieldDeclarationIndex == null) {
            classProperties.fieldDeclarationIndex = fieldDeclarationIndex = EconomicMap.create();
        }
        if (fieldDeclarationIndex.get((Object)fieldName) != null) {
            assert ((Integer)fieldDeclarationIndex.get((Object)fieldName) == pos) : entry.getTypeName() + fieldName;
        } else {
            fieldDeclarationIndex.put((Object)fieldName, (Object)pos);
        }
    }

    public int getFieldDeclarationIndex(StructureTypeEntry entry, String fieldName) {
        DwarfClassProperties classProperties = this.lookupClassProperties(entry);
        assert (classProperties.getTypeEntry() == entry);
        EconomicMap<String, Integer> fieldDeclarationIndex = classProperties.fieldDeclarationIndex;
        assert (fieldDeclarationIndex != null) : fieldName;
        assert (fieldDeclarationIndex.get((Object)fieldName) != null) : entry.getTypeName() + fieldName;
        return (Integer)fieldDeclarationIndex.get((Object)fieldName);
    }

    public void setMethodDeclarationIndex(MethodEntry methodEntry, int pos) {
        DwarfMethodProperties methodProperties = this.lookupMethodProperties(methodEntry);
        methodProperties.setMethodDeclarationIndex(pos);
    }

    public int getMethodDeclarationIndex(MethodEntry methodEntry) {
        DwarfMethodProperties methodProperties = this.lookupMethodProperties(methodEntry);
        return methodProperties.getMethodDeclarationIndex();
    }

    public void setAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry, int pos) {
        this.lookupMethodProperties(methodEntry).setAbstractInlineMethodIndex(classEntry, pos);
    }

    public int getAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry) {
        return this.lookupMethodProperties(methodEntry).getAbstractInlineMethodIndex(classEntry);
    }

    private DwarfLocalProperties addRangeLocalProperties(Range range) {
        DwarfLocalProperties localProperties = new DwarfLocalProperties();
        this.rangeLocalPropertiesIndex.put((Object)range, (Object)localProperties);
        return localProperties;
    }

    public DwarfLocalProperties lookupLocalProperties(ClassEntry classEntry, MethodEntry methodEntry) {
        return this.lookupMethodProperties(methodEntry).getLocalProperties(classEntry);
    }

    public void setMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        DwarfLocalProperties localProperties = this.lookupLocalProperties(classEntry, methodEntry);
        localProperties.setIndex(localInfo, index);
    }

    public int getMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localInfo) {
        DwarfLocalProperties localProperties = this.lookupLocalProperties(classEntry, methodEntry);
        assert (localProperties != null) : "get of non-existent local index";
        int index = localProperties.getIndex(localInfo);
        assert (index >= 0) : "get of local index before it was set";
        return index;
    }

    public void setRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        DwarfLocalProperties rangeProperties = (DwarfLocalProperties)this.rangeLocalPropertiesIndex.get((Object)range);
        if (rangeProperties == null) {
            rangeProperties = this.addRangeLocalProperties(range);
        }
        rangeProperties.setIndex(localInfo, index);
    }

    public int getRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localinfo) {
        DwarfLocalProperties rangeProperties = (DwarfLocalProperties)this.rangeLocalPropertiesIndex.get((Object)range);
        assert (rangeProperties != null) : "get of non-existent local index";
        int index = rangeProperties.getIndex(localinfo);
        assert (index >= 0) : "get of local index before it was set";
        return index;
    }

    static class DwarfTypeProperties {
        private int typeInfoIndex;
        private int indirectTypeInfoIndex;
        private final TypeEntry typeEntry;

        public int getTypeInfoIndex() {
            return this.typeInfoIndex;
        }

        public void setTypeInfoIndex(int typeInfoIndex) {
            this.typeInfoIndex = typeInfoIndex;
        }

        public int getIndirectTypeInfoIndex() {
            return this.indirectTypeInfoIndex;
        }

        public void setIndirectTypeInfoIndex(int typeInfoIndex) {
            this.indirectTypeInfoIndex = typeInfoIndex;
        }

        public TypeEntry getTypeEntry() {
            return this.typeEntry;
        }

        DwarfTypeProperties(TypeEntry typeEntry) {
            this.typeEntry = typeEntry;
            this.typeInfoIndex = -1;
            this.indirectTypeInfoIndex = -1;
        }
    }

    static class DwarfClassProperties
    extends DwarfTypeProperties {
        private int cuIndex = -1;
        private int layoutIndex = -1;
        private int indirectLayoutIndex = -1;
        private int codeRangesIndex = -1;
        private int lineIndex = -1;
        private int linePrologueSize = -1;
        private EconomicMap<String, Integer> fieldDeclarationIndex = null;

        DwarfClassProperties(StructureTypeEntry entry) {
            super(entry);
        }
    }

    static class DwarfMethodProperties {
        private int methodDeclarationIndex = -1;
        private EconomicMap<ClassEntry, DwarfLocalProperties> localPropertiesMap = null;
        private EconomicMap<ClassEntry, Integer> abstractInlineMethodIndex = null;

        DwarfMethodProperties() {
        }

        public int getMethodDeclarationIndex() {
            assert (this.methodDeclarationIndex >= 0) : "unset declaration index";
            return this.methodDeclarationIndex;
        }

        public void setMethodDeclarationIndex(int pos) {
            assert (this.methodDeclarationIndex == -1 || this.methodDeclarationIndex == pos) : "bad declaration index";
            this.methodDeclarationIndex = pos;
        }

        public DwarfLocalProperties getLocalProperties(ClassEntry classEntry) {
            DwarfLocalProperties localProperties;
            if (this.localPropertiesMap == null) {
                this.localPropertiesMap = EconomicMap.create();
            }
            if ((localProperties = (DwarfLocalProperties)this.localPropertiesMap.get((Object)classEntry)) == null) {
                localProperties = new DwarfLocalProperties();
                this.localPropertiesMap.put((Object)classEntry, (Object)localProperties);
            }
            return localProperties;
        }

        public void setAbstractInlineMethodIndex(ClassEntry classEntry, int pos) {
            if (this.abstractInlineMethodIndex == null) {
                this.abstractInlineMethodIndex = EconomicMap.create();
            }
            Integer val = (Integer)this.abstractInlineMethodIndex.put((Object)classEntry, (Object)pos);
            assert (val == null || val == pos);
        }

        public int getAbstractInlineMethodIndex(ClassEntry classEntry) {
            return (Integer)this.abstractInlineMethodIndex.get((Object)classEntry);
        }
    }

    static final class DwarfLocalProperties {
        private EconomicMap<DebugInfoProvider.DebugLocalInfo, Integer> locals = EconomicMap.create();

        private DwarfLocalProperties() {
        }

        int getIndex(DebugInfoProvider.DebugLocalInfo localInfo) {
            return (Integer)this.locals.get((Object)localInfo);
        }

        void setIndex(DebugInfoProvider.DebugLocalInfo localInfo, int index) {
            if (this.locals.get((Object)localInfo) != null) {
                assert ((Integer)this.locals.get((Object)localInfo) == index);
            } else {
                this.locals.put((Object)localInfo, (Object)index);
            }
        }
    }

    static enum AbbrevCode {
        NULL,
        BUILTIN_UNIT,
        CLASS_UNIT_1,
        CLASS_UNIT_2,
        PRIMITIVE_TYPE,
        VOID_TYPE,
        OBJECT_HEADER,
        NAMESPACE,
        CLASS_LAYOUT_1,
        CLASS_LAYOUT_2,
        CLASS_POINTER,
        FOREIGN_POINTER,
        FOREIGN_TYPEDEF,
        FOREIGN_STRUCT,
        METHOD_LOCATION,
        STATIC_FIELD_LOCATION,
        ARRAY_LAYOUT,
        ARRAY_POINTER,
        INTERFACE_LAYOUT,
        INTERFACE_POINTER,
        INDIRECT_LAYOUT,
        INDIRECT_POINTER,
        METHOD_DECLARATION,
        METHOD_DECLARATION_STATIC,
        FIELD_DECLARATION_1,
        FIELD_DECLARATION_2,
        FIELD_DECLARATION_3,
        FIELD_DECLARATION_4,
        CLASS_CONSTANT,
        HEADER_FIELD,
        ARRAY_DATA_TYPE_1,
        ARRAY_DATA_TYPE_2,
        ARRAY_SUBRANGE,
        SUPER_REFERENCE,
        INTERFACE_IMPLEMENTOR,
        INLINED_SUBROUTINE,
        INLINED_SUBROUTINE_WITH_CHILDREN,
        ABSTRACT_INLINE_METHOD,
        METHOD_PARAMETER_DECLARATION_1,
        METHOD_PARAMETER_DECLARATION_2,
        METHOD_PARAMETER_DECLARATION_3,
        METHOD_LOCAL_DECLARATION_1,
        METHOD_LOCAL_DECLARATION_2,
        METHOD_PARAMETER_LOCATION_1,
        METHOD_PARAMETER_LOCATION_2,
        METHOD_LOCAL_LOCATION_1,
        METHOD_LOCAL_LOCATION_2;

    }
}

