/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;

public class ForeignTypeEntry
extends ClassEntry {
    private static final int FLAG_WORD = 1;
    private static final int FLAG_STRUCT = 2;
    private static final int FLAG_POINTER = 4;
    private static final int FLAG_INTEGRAL = 8;
    private static final int FLAG_SIGNED = 16;
    private static final int FLAG_FLOAT = 32;
    private String typedefName = null;
    private ForeignTypeEntry parent = null;
    private TypeEntry pointerTo = null;
    private int flags = 0;

    public ForeignTypeEntry(String className, FileEntry fileEntry, int size) {
        super(className, fileEntry, size);
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.FOREIGN;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        assert (debugTypeInfo instanceof DebugInfoProvider.DebugForeignTypeInfo);
        super.addDebugInfo(debugInfoBase, debugTypeInfo, debugContext);
        DebugInfoProvider.DebugForeignTypeInfo debugForeignTypeInfo = (DebugInfoProvider.DebugForeignTypeInfo)debugTypeInfo;
        this.typedefName = debugForeignTypeInfo.typedefName();
        if (debugForeignTypeInfo.isWord()) {
            this.flags = 1;
        } else if (debugForeignTypeInfo.isStruct()) {
            this.flags = 2;
            ResolvedJavaType parentIdType = debugForeignTypeInfo.parent();
            if (parentIdType != null) {
                ClassEntry parentTypeEntry = debugInfoBase.lookupClassEntry(parentIdType);
                assert (parentTypeEntry instanceof ForeignTypeEntry);
                this.parent = (ForeignTypeEntry)parentTypeEntry;
            }
        } else if (debugForeignTypeInfo.isPointer()) {
            this.flags = 4;
            ResolvedJavaType referent = debugForeignTypeInfo.pointerTo();
            if (referent != null) {
                this.pointerTo = debugInfoBase.lookupTypeEntry(referent);
            }
        } else if (debugForeignTypeInfo.isIntegral()) {
            this.flags = 8;
        } else if (debugForeignTypeInfo.isFloat()) {
            this.flags = 32;
        }
        if (debugForeignTypeInfo.isSigned()) {
            this.flags |= 0x10;
        }
        if (debugContext.isLogEnabled()) {
            if (this.isPointer() && this.pointerTo != null) {
                debugContext.log("foreign type %s flags 0x%x referent %s ", (Object)this.typeName, (Object)this.flags, (Object)this.pointerTo.getTypeName());
            } else {
                debugContext.log("foreign type %s flags 0x%x", (Object)this.typeName, this.flags);
            }
        }
    }

    public String getTypedefName() {
        return this.typedefName;
    }

    public ForeignTypeEntry getParent() {
        return this.parent;
    }

    public TypeEntry getPointerTo() {
        return this.pointerTo;
    }

    public boolean isWord() {
        return (this.flags & 1) != 0;
    }

    public boolean isStruct() {
        return (this.flags & 2) != 0;
    }

    public boolean isPointer() {
        return (this.flags & 4) != 0;
    }

    public boolean isIntegral() {
        return (this.flags & 8) != 0;
    }

    public boolean isSigned() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFloat() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    protected void processInterface(ResolvedJavaType interfaceType, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        ClassEntry parentEntry = debugInfoBase.lookupClassEntry(interfaceType);
        if (parentEntry instanceof InterfaceClassEntry) {
            super.processInterface(interfaceType, debugInfoBase, debugContext);
        } else assert (parentEntry instanceof ForeignTypeEntry) : "was only expecting an interface or a foreign type";
    }
}

