/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.pecoff.cv.CVNames;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.ArrayList;
import org.graalvm.compiler.debug.GraalError;

abstract class CVTypeRecord {
    static final int FIRST_TYPE_INDEX = 4096;
    static final int CV_TYPE_RECORD_MAX_SIZE = 65535;
    protected final short type;
    private int startPosition;
    private int sequenceNumber;

    CVTypeRecord(short type) {
        this.type = type;
        this.startPosition = -1;
        this.sequenceNumber = -1;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    int computeFullSize(int initialPos) {
        assert (this.sequenceNumber >= 4096);
        this.startPosition = initialPos;
        int pos = initialPos + 4;
        pos = this.computeSize(pos);
        pos = CVTypeRecord.alignPadded4(null, pos);
        return pos;
    }

    int computeFullContents(byte[] buffer, int initialPos) {
        assert (this.sequenceNumber >= 4096);
        int pos = initialPos + 2;
        pos = CVUtil.putShort(this.type, buffer, pos);
        pos = this.computeContents(buffer, pos);
        int length = (pos = CVTypeRecord.alignPadded4(buffer, pos)) - initialPos - 2;
        if (length > 65535) {
            throw GraalError.shouldNotReachHere((String)String.format("Type record too large: %d (maximum %d) bytes: %s", length, 65535, this));
        }
        CVUtil.putShort((short)length, buffer, initialPos);
        return pos;
    }

    public int computeSize(int initialPos) {
        return this.computeContents(null, initialPos);
    }

    protected abstract int computeContents(byte[] var1, int var2);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.type == ((CVTypeRecord)obj).type;
    }

    public abstract int hashCode();

    public String toString() {
        return String.format("CVTypeRecord seq=0x%04x type=0x%04x pos=0x%04x ", this.sequenceNumber, this.type, this.startPosition);
    }

    private static int alignPadded4(byte[] buffer, int originalpos) {
        int pos = originalpos;
        int align = pos & 3;
        if (align == 1) {
            byte[] p3 = new byte[]{-13, -14, -15};
            pos = CVUtil.putBytes(p3, buffer, pos);
        } else if (align == 2) {
            pos = CVUtil.putByte((byte)-14, buffer, pos);
            pos = CVUtil.putByte((byte)-15, buffer, pos);
        } else if (align == 3) {
            pos = CVUtil.putByte((byte)-15, buffer, pos);
        }
        return pos;
    }

    static String attrString(short attrs) {
        StringBuilder sb = new StringBuilder();
        if ((attrs & 3) != 0) {
            String[] aStr = new String[]{"", "private", "protected", "public"};
            sb.append(aStr[attrs & 3]);
        }
        if ((attrs & 0x1C) != 0) {
            int p = (attrs & 0x1C) >> 2;
            String[] pStr = new String[]{"", " virtual", " static", " friend", " intro", " pure", " intro-pure", " (*7*)"};
            sb.append(pStr[p]);
        }
        if ((attrs & 0x20) != 0) {
            sb.append(" pseudo");
        }
        if ((attrs & 0x40) != 0) {
            sb.append(" final-class");
        }
        if ((attrs & 0x80) != 0) {
            sb.append(" abstract");
        }
        if ((attrs & 0x100) != 0) {
            sb.append(" compgenx");
        }
        if ((attrs & 0x200) != 0) {
            sb.append(" final-method");
        }
        return sb.toString();
    }

    static String propertyString(int properties) {
        StringBuilder sb = new StringBuilder();
        if ((properties & 1) != 0) {
            sb.append(" packed");
        }
        if ((properties & 2) != 0) {
            sb.append(" ctor");
        }
        if ((properties & 4) != 0) {
            sb.append(" ovlops");
        }
        if ((properties & 8) != 0) {
            sb.append(" isnested");
        }
        if ((properties & 0x10) != 0) {
            sb.append(" cnested");
        }
        if ((properties & 0x20) != 0) {
            sb.append(" opassign");
        }
        if ((properties & 0x40) != 0) {
            sb.append(" opcast");
        }
        if ((properties & 0x80) != 0) {
            sb.append(" forwardref");
        }
        if ((properties & 0x100) != 0) {
            sb.append(" scope");
        }
        if ((properties & 0x200) != 0) {
            sb.append(" hasuniquename");
        }
        if ((properties & 0x400) != 0) {
            sb.append(" sealed");
        }
        if ((properties & 0x1800) != 0) {
            sb.append(" hfa...");
        }
        if ((properties & 0x2000) != 0) {
            sb.append(" intrinsic");
        }
        if ((properties & 0xC000) != 0) {
            sb.append(" macom...");
        }
        return sb.toString();
    }

    static final class CVTypeArrayRecord
    extends CVTypeRecord {
        private final int elementTypeIndex;
        private final int indexType;
        private final int length;
        private final String name;

        CVTypeArrayRecord(int elementTypeIndex, int indexType, int length, String name) {
            super((short)5379);
            this.elementTypeIndex = elementTypeIndex;
            this.indexType = indexType;
            this.length = length;
            this.name = name;
        }

        CVTypeArrayRecord(int elementTypeIndex, int indexType, int length) {
            this(elementTypeIndex, indexType, length, "");
        }

        CVTypeArrayRecord(int elementTypeIndex, int length) {
            this(elementTypeIndex, 119, length);
        }

        CVTypeArrayRecord(CVTypeRecord elementType, int length) {
            this(elementType.getSequenceNumber(), 119, length);
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.elementTypeIndex, buffer, initialPos);
            pos = CVUtil.putInt(this.indexType, buffer, pos);
            pos = CVUtil.putLfNumeric(this.length, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.name, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("LF_ARRAY 0x%04x type=0x%04x len=%d indexType=0x%04x%s", this.getSequenceNumber(), this.elementTypeIndex, this.length, this.indexType, this.name.isEmpty() ? "" : "name=" + this.name);
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.elementTypeIndex;
            h = 31 * h + this.indexType;
            h = 31 * h + this.length;
            h = 31 * h + this.name.hashCode();
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypeArrayRecord other = (CVTypeArrayRecord)obj;
            return this.elementTypeIndex == other.elementTypeIndex && this.indexType == other.indexType && this.length == other.length && this.name.equals(other.name);
        }
    }

    static final class CVFieldListRecord
    extends CVTypeRecord {
        static final int INITIAL_CAPACITY = 10;
        private int estimatedSize = CVUtil.align4(2);
        private final ArrayList<FieldRecord> members = new ArrayList(10);

        CVFieldListRecord() {
            super((short)4611);
        }

        void add(FieldRecord m) {
            this.estimatedSize += CVUtil.align4(m.computeSize());
            this.members.add(m);
        }

        int getEstimatedSize() {
            return this.estimatedSize;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = initialPos;
            for (FieldRecord field : this.members) {
                pos = field.computeContents(buffer, pos);
                pos = CVTypeRecord.alignPadded4(buffer, pos);
            }
            return pos;
        }

        @Override
        public int hashCode() {
            int hash = this.type;
            hash = 31 * hash + this.members.hashCode();
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVFieldListRecord other = (CVFieldListRecord)obj;
            return this.members.equals(other.members);
        }

        @Override
        public String toString() {
            return String.format("LF_FIELDLIST idx=0x%x count=%d", this.getSequenceNumber(), this.members.size());
        }
    }

    static class CVClassRecord
    extends CVTypeRecord {
        static final int ATTR_FORWARD_REF = 128;
        static final int ATTR_HAS_UNIQUENAME = 512;
        private final short count;
        private final short propertyAttributes;
        private final int fieldIndex;
        private final int derivedFromIndex;
        private final int vshapeIndex;
        private final long size;
        private final String className;
        private final String uniqueName;

        CVClassRecord(short recType, short count, short attrs, int fieldIndex, int derivedFromIndex, int vshapeIndex, long size, String className, String uniqueName) {
            super(recType);
            this.count = count;
            this.propertyAttributes = (short)(attrs | (short)(uniqueName != null ? 512 : 0));
            this.fieldIndex = fieldIndex;
            this.derivedFromIndex = derivedFromIndex;
            this.vshapeIndex = vshapeIndex;
            this.size = size;
            this.className = className;
            this.uniqueName = uniqueName;
        }

        CVClassRecord(short count, short attrs, int fieldIndex, int derivedFromIndex, int vshapeIndex, long size, String className, String uniqueName) {
            this(5380, count, attrs, fieldIndex, derivedFromIndex, vshapeIndex, size, className, uniqueName);
        }

        CVClassRecord(short attrs, String className, String uniqueName) {
            this(5380, 0, attrs, 0, 0, 0, 0L, className, uniqueName);
        }

        String getClassName() {
            return this.className;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putShort(this.count, buffer, initialPos);
            pos = CVUtil.putShort(this.propertyAttributes, buffer, pos);
            pos = CVUtil.putInt(this.fieldIndex, buffer, pos);
            pos = CVUtil.putInt(this.derivedFromIndex, buffer, pos);
            pos = CVUtil.putInt(this.vshapeIndex, buffer, pos);
            pos = CVUtil.putLfNumeric(this.size, buffer, pos);
            String fixedName = CVNames.typeNameToCodeViewName(this.className);
            pos = CVUtil.putUTF8StringBytes(fixedName, buffer, pos);
            if (this.hasUniqueName()) {
                assert (this.uniqueName != null);
                pos = CVUtil.putUTF8StringBytes(this.uniqueName, buffer, pos);
            }
            return pos;
        }

        boolean isForwardRef() {
            return (this.propertyAttributes & 0x80) != 0;
        }

        public boolean hasUniqueName() {
            return (this.propertyAttributes & 0x200) != 0;
        }

        protected String toString(String lfTypeStr) {
            return String.format("%s 0x%04x count=%d attr=0x%x(%s) fld=0x%x super=0x%x vshape=0x%x size=%d %s%s", lfTypeStr, this.getSequenceNumber(), this.count, this.propertyAttributes, CVClassRecord.propertyString(this.propertyAttributes), this.fieldIndex, this.derivedFromIndex, this.vshapeIndex, this.size, this.className, this.uniqueName != null ? " (" + this.uniqueName + ")" : "");
        }

        @Override
        public String toString() {
            return this.toString("LF_CLASS");
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.count;
            h = 31 * h + this.propertyAttributes;
            h = 31 * h + this.fieldIndex;
            h = 31 * h + this.derivedFromIndex;
            h = 31 * h + (int)this.size;
            h = 31 * h + this.className.hashCode();
            if (this.uniqueName != null) {
                h = 31 * h + this.uniqueName.hashCode();
            }
            h = 31 * h + this.vshapeIndex;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVClassRecord other = (CVClassRecord)obj;
            return this.count == other.count && this.propertyAttributes == other.propertyAttributes && this.fieldIndex == other.fieldIndex && this.derivedFromIndex == other.derivedFromIndex && this.size == other.size && this.className.equals(other.className) && (this.uniqueName != null ? this.uniqueName.equals(other.uniqueName) : other.uniqueName == null) && this.vshapeIndex == other.vshapeIndex;
        }
    }

    static class CVBaseMemberRecord
    extends FieldRecord {
        private final int basetypeIndex;
        private final int offset;

        CVBaseMemberRecord(short attrs, int basetypeIndex, int offset) {
            super((short)5120, attrs, "");
            this.basetypeIndex = basetypeIndex;
            this.offset = offset;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putShort(this.type, buffer, initialPos);
            pos = CVUtil.putShort(this.attrs, buffer, pos);
            pos = CVUtil.putInt(this.basetypeIndex, buffer, pos);
            pos = CVUtil.putLfNumeric(this.offset, buffer, pos);
            return pos;
        }

        public String toString() {
            return String.format("LF_BCLASS(0x%04x) attr=0x%04x(%s ?) baseIdx=0x%04x offset=0x%x", (short)5120, this.attrs, CVTypeRecord.attrString(this.attrs), this.basetypeIndex, this.offset);
        }

        @Override
        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + this.basetypeIndex;
            h = 31 * h + this.offset;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVBaseMemberRecord other = (CVBaseMemberRecord)obj;
            return this.basetypeIndex == other.basetypeIndex && this.offset == other.offset;
        }
    }

    static class CVOneMethodRecord
    extends FieldRecord {
        protected final int funcIdx;
        protected final int vtbleOffset;

        CVOneMethodRecord(short attrs, int funcIdx, int vtbleOffset, String name) {
            super((short)5393, attrs, name);
            this.funcIdx = funcIdx;
            this.vtbleOffset = vtbleOffset;
        }

        boolean hasVtableOffset() {
            return (this.attrs & 0x1C) == 16 || (this.attrs & 0x1C) == 24;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putShort(this.type, buffer, initialPos);
            pos = CVUtil.putShort(this.attrs, buffer, pos);
            pos = CVUtil.putInt(this.funcIdx, buffer, pos);
            if (this.hasVtableOffset()) {
                assert (this.vtbleOffset >= 0);
                pos = CVUtil.putInt(this.vtbleOffset, buffer, pos);
            }
            pos = CVUtil.putUTF8StringBytes(this.name, buffer, pos);
            return pos;
        }

        public String toString() {
            return String.format("LF_ONEMETHOD(0x%04x) attr=0x%x(%s) funcIdx=0x%x vtbloffet=0x%x %s", this.type, this.attrs, CVTypeRecord.attrString(this.attrs), this.funcIdx, this.vtbleOffset, this.name);
        }

        @Override
        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + this.funcIdx;
            h = 31 * h + this.vtbleOffset;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVOneMethodRecord other = (CVOneMethodRecord)obj;
            return this.vtbleOffset == other.vtbleOffset && this.funcIdx == other.funcIdx;
        }
    }

    static final class CVStaticMemberRecord
    extends FieldRecord {
        private final int underlyingTypeIndex;

        CVStaticMemberRecord(short attrs, int underlyingTypeIndex, String name) {
            super((short)5390, attrs, name);
            this.underlyingTypeIndex = underlyingTypeIndex;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putShort(this.type, buffer, initialPos);
            pos = CVUtil.putShort(this.attrs, buffer, pos);
            pos = CVUtil.putInt(this.underlyingTypeIndex, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.name, buffer, pos);
            return pos;
        }

        public String toString() {
            return String.format("LF_STMEMBER(0x%04x) attr=0x%x(%s) t=0x%x %s", this.type, this.attrs, CVTypeRecord.attrString(this.attrs), this.underlyingTypeIndex, this.name);
        }

        @Override
        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + this.underlyingTypeIndex;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVStaticMemberRecord other = (CVStaticMemberRecord)obj;
            return this.underlyingTypeIndex == other.underlyingTypeIndex;
        }
    }

    static final class CVMemberRecord
    extends FieldRecord {
        private final int underlyingTypeIndex;
        private int offset;

        CVMemberRecord(short attrs, int underlyingTypeIndex, int offset, String name) {
            super((short)5389, attrs, name);
            this.underlyingTypeIndex = underlyingTypeIndex;
            this.offset = offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putShort(this.type, buffer, initialPos);
            pos = CVUtil.putShort(this.attrs, buffer, pos);
            pos = CVUtil.putInt(this.underlyingTypeIndex, buffer, pos);
            pos = CVUtil.putLfNumeric(this.offset, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.name, buffer, pos);
            return pos;
        }

        public String toString() {
            return String.format("LF_MEMBER(0x%04x) attr=0x%x(%s) t=0x%x off=%d 0x%x %s", this.type, this.attrs, CVTypeRecord.attrString(this.attrs), this.underlyingTypeIndex, this.offset, this.offset & 0xFFFF, this.name);
        }

        @Override
        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + this.underlyingTypeIndex;
            h = 31 * h + this.offset;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVMemberRecord other = (CVMemberRecord)obj;
            return this.offset == other.offset && this.underlyingTypeIndex == other.underlyingTypeIndex;
        }
    }

    static final class CVIndexRecord
    extends FieldRecord {
        private final int index;

        CVIndexRecord(int index) {
            super((short)5124);
            this.index = index;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putShort(this.type, buffer, initialPos);
            pos = CVUtil.putShort((short)0, buffer, pos);
            pos = CVUtil.putInt(this.index, buffer, pos);
            return pos;
        }

        public String toString() {
            return String.format("LF_INDEX(0x%04x) index=0x%04x", this.type, this.index);
        }

        @Override
        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + this.index;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVIndexRecord other = (CVIndexRecord)obj;
            return this.index == other.index;
        }
    }

    static final class CVOverloadedMethodRecord
    extends FieldRecord {
        private final int methodListIndex;
        private final short count;

        CVOverloadedMethodRecord(short count, int methodListIndex, String methodName) {
            super((short)5391, (short)0, methodName);
            this.methodListIndex = methodListIndex;
            this.count = count;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putShort(this.type, buffer, initialPos);
            pos = CVUtil.putShort(this.count, buffer, pos);
            pos = CVUtil.putInt(this.methodListIndex, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.name, buffer, pos);
            return pos;
        }

        public String toString() {
            return String.format("LF_METHOD(0x%04x) count=0x%x listIdx=0x%04x %s", this.type, this.count, this.methodListIndex, this.name);
        }

        @Override
        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + this.methodListIndex;
            h = 31 + h + this.count;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVOverloadedMethodRecord other = (CVOverloadedMethodRecord)obj;
            return this.methodListIndex == other.methodListIndex && this.count == other.count;
        }
    }

    static abstract class FieldRecord {
        protected final short type;
        protected final short attrs;
        protected final String name;

        protected FieldRecord(short leafType, short attrs, String name) {
            assert (name != null);
            this.type = leafType;
            this.attrs = attrs;
            this.name = name;
        }

        protected FieldRecord(short leafType) {
            this(leafType, 0, "");
        }

        public int computeSize() {
            return this.computeContents(null, 0);
        }

        public abstract int computeContents(byte[] var1, int var2);

        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.attrs;
            h = 31 * h + this.name.hashCode();
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FieldRecord other = (FieldRecord)obj;
            return this.type == other.type && this.attrs == other.attrs && this.name.equals(other.name);
        }
    }

    static final class CVTypeMethodListRecord
    extends CVTypeRecord {
        static final int INITIAL_CAPACITY = 10;
        private final ArrayList<MDef> methods = new ArrayList(10);

        CVTypeMethodListRecord() {
            super((short)4614);
        }

        public void add(short attrs, int idx, int offset, String name) {
            this.methods.add(new MDef(attrs, idx, offset, name));
        }

        public int count() {
            return this.methods.size();
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = initialPos;
            for (MDef f : this.methods) {
                pos = f.computeContents(buffer, pos);
            }
            return pos;
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.methods.hashCode();
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypeMethodListRecord other = (CVTypeMethodListRecord)obj;
            return this.methods.equals(other.methods);
        }

        @Override
        public String toString() {
            return String.format("LF_METHODLIST idx=0x%04x count=%d", this.getSequenceNumber(), this.methods.size());
        }

        static class MDef
        extends CVOneMethodRecord {
            MDef(short attrs, int funcIdx, int vtbleOffset, String name) {
                super(attrs, funcIdx, vtbleOffset, name);
            }

            @Override
            public int computeContents(byte[] buffer, int initialPos) {
                int pos = initialPos;
                pos = CVUtil.putShort(this.attrs, buffer, pos);
                pos = CVUtil.putShort((short)0, buffer, pos);
                pos = CVUtil.putInt(this.funcIdx, buffer, pos);
                if (this.hasVtableOffset()) {
                    assert (this.vtbleOffset >= 0);
                    pos = CVUtil.putInt(this.vtbleOffset, buffer, pos);
                }
                return pos;
            }
        }
    }

    static final class CVTypeMFunctionRecord
    extends CVTypeRecord {
        private int returnType = -1;
        private int classType = -1;
        private int thisType = -1;
        private byte callType = 0;
        private byte funcAttr = 0;
        private int thisAdjust = 0;
        private CVTypeArglistRecord argList = null;

        CVTypeMFunctionRecord() {
            super((short)4105);
        }

        void setReturnType(int returnType) {
            this.returnType = returnType;
        }

        void setClassType(int classType) {
            this.classType = classType;
        }

        void setThisType(int thisType) {
            this.thisType = thisType;
        }

        void setCallType(byte callType) {
            this.callType = callType;
        }

        void setFuncAttr(byte funcAttr) {
            this.funcAttr = funcAttr;
        }

        void setThisAdjust(int thisAdjust) {
            this.thisAdjust = thisAdjust;
        }

        void setArgList(CVTypeArglistRecord argList) {
            this.argList = argList;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.returnType, buffer, initialPos);
            pos = CVUtil.putInt(this.classType, buffer, pos);
            pos = CVUtil.putInt(this.thisType, buffer, pos);
            pos = CVUtil.putByte(this.callType, buffer, pos);
            pos = CVUtil.putByte(this.funcAttr, buffer, pos);
            pos = CVUtil.putShort((short)this.argList.getSize(), buffer, pos);
            pos = CVUtil.putInt(this.argList.getSequenceNumber(), buffer, pos);
            pos = CVUtil.putInt(this.thisAdjust, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            String attrString = (this.funcAttr & 2) == 2 ? "(ctor)" : "";
            return String.format("LF_MFUNCTION 0x%04x ret=0x%04x this=0x%04x *this=0x%04x+%d calltype=0x%x attr=0x%x%s, argcount=0x%04x ", this.getSequenceNumber(), this.returnType, this.classType, this.thisType, this.thisAdjust, this.callType, this.funcAttr, attrString, this.argList.getSequenceNumber());
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.returnType;
            h = 31 * h + this.classType;
            h = 31 * h + this.thisType;
            h = 31 * h + this.callType;
            h = 31 * h + this.funcAttr;
            h = 31 * h + this.thisAdjust;
            h = 31 * h + this.argList.getSequenceNumber();
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypeMFunctionRecord other = (CVTypeMFunctionRecord)obj;
            return this.returnType == other.returnType && this.classType == other.classType && this.thisType == other.thisType && this.callType == other.callType && this.funcAttr == other.funcAttr && this.thisAdjust == other.thisAdjust && this.argList.getSequenceNumber() == other.argList.getSequenceNumber();
        }
    }

    static final class CVTypeArglistRecord
    extends CVTypeRecord {
        private final ArrayList<Integer> args = new ArrayList();

        CVTypeArglistRecord() {
            super((short)4609);
        }

        void add(int argType) {
            this.args.add(argType);
        }

        @Override
        public int computeSize(int initialPos) {
            return initialPos + 4 + 4 * this.args.size();
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.args.size(), buffer, initialPos);
            for (Integer at : this.args) {
                pos = CVUtil.putInt(at, buffer, pos);
            }
            return pos;
        }

        int getSize() {
            return this.args.size();
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder(String.format("LF_ARGLIST 0x%04x [", this.getSequenceNumber()));
            for (Integer at : this.args) {
                s.append(String.format(" 0x%04x", at));
            }
            s.append("])");
            return s.toString();
        }

        @Override
        public int hashCode() {
            return this.type * 31 + this.args.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypeArglistRecord other = (CVTypeArglistRecord)obj;
            return this.args.equals(other.args);
        }
    }

    static final class CVTypeStringIdRecord
    extends CVTypeRecord {
        String string;
        int substringListIndex;

        CVTypeStringIdRecord(int substringListIndex, String string) {
            super((short)5637);
            this.substringListIndex = substringListIndex;
            this.string = string;
        }

        CVTypeStringIdRecord(String string) {
            this(0, string);
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.substringListIndex, buffer, initialPos);
            return CVUtil.putUTF8StringBytes(this.string, buffer, pos);
        }

        @Override
        public String toString() {
            return String.format("LF_STRING_ID 0x%04x substringListIdx=0x%x %s", this.getSequenceNumber(), this.substringListIndex, this.string);
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.substringListIndex;
            h = 31 * h + this.string.hashCode();
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypeStringIdRecord other = (CVTypeStringIdRecord)obj;
            return this.string.equals(other.string) && this.substringListIndex == other.substringListIndex;
        }
    }

    static class CVUdtTypeLineRecord
    extends CVTypeRecord {
        final int typeIndex;
        int fileIndex;
        int line;

        CVUdtTypeLineRecord(int typeIndex, int fileIndex, int line) {
            this(5638, typeIndex, fileIndex, line);
        }

        CVUdtTypeLineRecord(short t, int typeIndex, int fileIndex, int line) {
            super(t);
            this.typeIndex = typeIndex;
            this.fileIndex = fileIndex;
            this.line = line;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.typeIndex, buffer, initialPos);
            pos = CVUtil.putInt(this.fileIndex, buffer, pos);
            return CVUtil.putInt(this.line, buffer, pos);
        }

        @Override
        public String toString() {
            return String.format("LF_UDT_SRC_LINE 0x%04x typeIdx=0x%x fileIdx=0x%x line=%d", this.getSequenceNumber(), this.typeIndex, this.fileIndex, this.line);
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.typeIndex;
            h = 31 * h + this.fileIndex;
            h = 31 * h + this.line;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVUdtTypeLineRecord other = (CVUdtTypeLineRecord)obj;
            return this.typeIndex == other.typeIndex && this.fileIndex == other.fileIndex && this.line == other.line;
        }
    }

    static final class CVTypePointerRecord
    extends CVTypeRecord {
        static final int KIND_64 = 12;
        static final int SIZE_8 = 65536;
        static final int NORMAL_64 = 65548;
        private final int pointsTo;
        private final int attrs;
        static String[] ptrType = new String[]{"near16", "far16", "huge", "base-seg", "base-val", "base-segval", "base-addr", "base-segaddr", "base-type", "base-self", "near32", "far32", "64"};
        static String[] modeStrs = new String[]{"normal", "lvalref", "datamem", "memfunc", "rvalref"};

        CVTypePointerRecord(int pointTo, int attrs) {
            super((short)4098);
            this.pointsTo = pointTo;
            this.attrs = attrs;
        }

        int getPointsTo() {
            return this.pointsTo;
        }

        @Override
        public int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.pointsTo, buffer, initialPos);
            return CVUtil.putInt(this.attrs, buffer, pos);
        }

        @Override
        public String toString() {
            int kind = this.attrs & 0x1F;
            int mode = (this.attrs & 0xE0) >> 5;
            int flags1 = (this.attrs & 0x1F00) >> 8;
            int size = (this.attrs & 0x7E000) >> 13;
            int flags2 = (this.attrs & 0x380000) >> 19;
            StringBuilder sb = new StringBuilder();
            sb.append((flags1 & 1) != 0 ? "flat32" : "");
            sb.append((flags1 & 2) != 0 ? " volatile" : "");
            sb.append((flags1 & 4) != 0 ? " const" : "");
            sb.append((flags1 & 8) != 0 ? " unaligned" : "");
            sb.append((flags1 & 0x10) != 0 ? " restricted" : "");
            return String.format("LF_POINTER 0x%04x attrs=0x%x(kind=%d(%s) mode=%d(%s) flags1=0x%x(%s) size=%d flags2=0x%x) pointTo=0x%04x", this.getSequenceNumber(), this.attrs, kind, ptrType[kind], mode, modeStrs[mode], flags1, sb, size, flags2, this.pointsTo);
        }

        @Override
        public int hashCode() {
            int h = this.type;
            h = 31 * h + this.pointsTo;
            h = 31 * h + this.attrs;
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CVTypePointerRecord other = (CVTypePointerRecord)obj;
            return this.pointsTo == other.pointsTo && this.attrs == other.attrs;
        }
    }

    static final class CVTypePrimitive
    extends CVTypeRecord {
        private final int length;

        CVTypePrimitive(short cvtype, int length) {
            super(cvtype);
            assert (cvtype < 4096);
            this.length = length;
            this.setSequenceNumber(cvtype);
        }

        @Override
        public int computeSize(int initialPos) {
            throw GraalError.shouldNotReachHere();
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public int hashCode() {
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public String toString() {
            return String.format("PRIMITIVE 0x%04x (len=%d)", this.getSequenceNumber(), this.length);
        }
    }
}

