/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.BasicElementImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.StringTable;
import com.oracle.objectfile.io.AssemblyBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;

public abstract class StringSectionImpl
extends BasicElementImpl
implements ObjectFile.ProgbitsSectionImpl,
Iterable<String> {
    private List<Iterable<String>> contentProviders = new ArrayList<Iterable<String>>();

    private byte[] encode() {
        StringTable t = new StringTable();
        if (this.contentProviders == null) {
            throw new IllegalStateException("no content provider assigned");
        }
        t.add("");
        for (String s : this) {
            assert (s != null);
            t.add(s);
        }
        AssemblyBuffer oa = AssemblyBuffer.createOutputAssembler(this.getElement().getOwner().getByteOrder());
        t.write(oa);
        return oa.getBlob();
    }

    @Override
    public Iterator<String> iterator() {
        return StreamSupport.stream(this.contentProviders.spliterator(), false).flatMap(stringIterable -> StreamSupport.stream(stringIterable.spliterator(), false)).iterator();
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        return this.encode();
    }

    @Override
    public Iterable<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        return ObjectFile.defaultDependencies(decisions, this.getElement());
    }

    public Iterator<Iterable<String>> contentProvidersIterator() {
        return this.contentProviders.iterator();
    }

    public void addContentProvider(Iterable<String> contentProvider) {
        this.contentProviders.add(contentProvider);
    }

    public StringSectionImpl(ObjectFile.Element e) {
        super(e);
    }

    public StringSectionImpl() {
    }

    @Override
    public ObjectFile.Element getOrCreateRelocationElement(long addend) {
        throw new UnsupportedOperationException("can't mark relocaction sites in string section");
    }

    @Override
    public void markRelocationSite(int offset, ObjectFile.RelocationKind k, String symbolName, long addend) {
        throw new UnsupportedOperationException("can't mark relocaction sites in string section");
    }

    @Override
    public void markRelocationSite(int offset, ByteBuffer bb, ObjectFile.RelocationKind k, String symbolName, long addend) {
        throw new UnsupportedOperationException("can't mark relocaction sites in string section");
    }

    @Override
    public byte[] getContent() {
        return this.encode();
    }

    @Override
    public void setContent(byte[] c) {
        this.addContentProvider(new StringTable((byte[])c).stringMap.values());
    }
}

