/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.MemberEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.pecoff.cv.CVTypeRecord;
import com.oracle.objectfile.pecoff.cv.CVTypeSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.debug.GraalError;

class CVTypeSectionBuilder {
    private final int objectHeaderRecordIndex;
    private final CVTypeSectionImpl typeSection;
    private final TypeTable types;

    CVTypeSectionBuilder(CVTypeSectionImpl typeSection) {
        this.typeSection = typeSection;
        this.types = new TypeTable(typeSection);
        this.objectHeaderRecordIndex = this.types.getIndexForForwardRef("_objhdr");
    }

    void verifyAllClassesDefined() {
        this.types.testForUndefinedClasses();
    }

    CVTypeRecord buildType(TypeEntry typeEntry) {
        CVTypeRecord typeRecord = this.types.getExistingType(typeEntry);
        if (typeRecord != null && typeRecord.type == 5380 && !((CVTypeRecord.CVClassRecord)typeRecord).isForwardRef()) {
            this.log("buildType() type %s(%s) is known %s", typeEntry.getTypeName(), typeEntry.typeKind().name(), typeRecord);
        } else {
            this.log("buildType() %s %s size=%d - begin", typeEntry.typeKind().name(), typeEntry.getTypeName(), typeEntry.getSize());
            switch (typeEntry.typeKind()) {
                case PRIMITIVE: {
                    typeRecord = this.types.getExistingType(typeEntry);
                    break;
                }
                case ARRAY: 
                case ENUM: 
                case INSTANCE: 
                case INTERFACE: {
                    typeRecord = this.buildStructureTypeEntry((StructureTypeEntry)typeEntry);
                    break;
                }
                case HEADER: {
                    assert (typeEntry.getTypeName().equals("_objhdr"));
                    typeRecord = this.buildStructureTypeEntry((HeaderTypeEntry)typeEntry);
                }
            }
        }
        assert (typeRecord != null);
        this.log("buildType end: %s", typeRecord);
        return typeRecord;
    }

    CVTypeRecord buildFunction(CompiledMethodEntry entry) {
        return this.buildMemberFunction(entry.getClassEntry(), entry.getPrimary().getMethodEntry());
    }

    private CVTypeRecord buildStructureTypeEntry(StructureTypeEntry typeEntry) {
        int superTypeIndex;
        this.log("buildStructureTypeEntry size=%d kind=%s %s", typeEntry.getSize(), typeEntry.typeKind().name(), typeEntry.getTypeName());
        ClassEntry superType = typeEntry.isClass() ? ((ClassEntry)typeEntry).getSuperClass() : null;
        int n = superTypeIndex = superType != null ? this.types.getIndexForForwardRef(superType) : 0;
        if (superTypeIndex == 0 && typeEntry.isArray()) {
            superTypeIndex = this.types.getIndexForForwardRef("java.lang.Object");
        }
        if (superTypeIndex == 0 && (typeEntry.getTypeName().equals("java.lang.Object") || typeEntry.isInterface())) {
            superTypeIndex = this.objectHeaderRecordIndex;
        }
        List<MethodEntry> methods = typeEntry.isClass() ? ((ClassEntry)typeEntry).getMethods() : Collections.emptyList();
        FieldListBuilder fieldListBuilder = new FieldListBuilder();
        this.log("building field list", new Object[0]);
        if (superTypeIndex != 0) {
            CVTypeRecord.CVBaseMemberRecord btype = new CVTypeRecord.CVBaseMemberRecord(3, superTypeIndex, 0);
            this.log("basetype %s", btype);
            fieldListBuilder.addField(btype);
        }
        typeEntry.fields().filter(CVTypeSectionBuilder::isManifestedField).forEach(f -> {
            this.log("field %s attr=(%s) offset=%d size=%d valuetype=%s", f.fieldName(), f.getModifiersString(), f.getOffset(), f.getSize(), f.getValueType().getTypeName());
            CVTypeRecord.FieldRecord fieldRecord = this.buildField((FieldEntry)f);
            this.log("field %s", fieldRecord);
            fieldListBuilder.addField(fieldRecord);
        });
        if (typeEntry.isArray()) {
            assert (typeEntry instanceof ArrayTypeEntry);
            ArrayTypeEntry arrayEntry = (ArrayTypeEntry)typeEntry;
            TypeEntry elementType = arrayEntry.getElementType();
            int elementTypeIndex = this.types.getIndexForPointerOrPrimitive(elementType);
            CVTypeRecord.CVTypeArrayRecord array0record = this.addTypeRecord(new CVTypeRecord.CVTypeArrayRecord(elementTypeIndex, 117, 0));
            CVTypeRecord.CVMemberRecord dm = new CVTypeRecord.CVMemberRecord(3, array0record.getSequenceNumber(), typeEntry.getSize(), "data");
            this.log("field %s", dm);
            fieldListBuilder.addField(dm);
        }
        if (methods.size() > 0) {
            this.log("building methods", new Object[0]);
            HashSet overloaded = new HashSet(methods.size());
            HashSet allFunctions = new HashSet(methods.size());
            methods.forEach(m -> {
                if (allFunctions.contains(m.methodName())) {
                    overloaded.add(m.methodName());
                } else {
                    allFunctions.add(m.methodName());
                }
            });
            overloaded.forEach(mname -> {
                CVTypeRecord.CVTypeMethodListRecord mlist = new CVTypeRecord.CVTypeMethodListRecord();
                methods.stream().filter(methodEntry -> methodEntry.methodName().equals(mname)).forEach(m -> {
                    this.log("overloaded method %s attr=(%s) valuetype=%s", m.methodName(), m.getModifiersString(), m.getValueType().getTypeName());
                    CVTypeRecord.CVTypeMFunctionRecord mFunctionRecord = this.buildMemberFunction((ClassEntry)typeEntry, (MethodEntry)m);
                    short attr = CVTypeSectionBuilder.modifiersToAttr(m);
                    this.log("    overloaded method %s", mFunctionRecord);
                    mlist.add(attr, mFunctionRecord.getSequenceNumber(), m.getVtableOffset(), m.methodName());
                });
                CVTypeRecord.CVTypeMethodListRecord nmlist = this.addTypeRecord(mlist);
                CVTypeRecord.CVOverloadedMethodRecord methodRecord = new CVTypeRecord.CVOverloadedMethodRecord((short)nmlist.count(), nmlist.getSequenceNumber(), (String)mname);
                fieldListBuilder.addField(methodRecord);
            });
            methods.stream().filter(methodEntry -> !overloaded.contains(methodEntry.methodName())).forEach(m -> {
                this.log("`unique method %s %s(...)", m.methodName(), m.getModifiersString(), m.getValueType().getTypeName(), m.methodName());
                CVTypeRecord.CVOneMethodRecord method = this.buildMethod((ClassEntry)typeEntry, (MethodEntry)m);
                this.log("    unique method %s", method);
                fieldListBuilder.addField(method);
            });
        }
        CVTypeRecord.CVFieldListRecord fieldListRecord = fieldListBuilder.buildFieldListRecords(this);
        int fieldListIdx = fieldListRecord.getSequenceNumber();
        int fieldCount = fieldListBuilder.getFieldCount();
        this.log("finished building fieldlist %s", fieldListRecord);
        short attrs = 0;
        CVTypeRecord.CVClassRecord typeRecord = new CVTypeRecord.CVClassRecord(5380, (short)fieldCount, attrs, fieldListIdx, 0, 0, typeEntry.getSize(), typeEntry.getTypeName(), null);
        typeRecord = this.addTypeRecord(typeRecord);
        if (typeEntry.isClass()) {
            int line;
            ClassEntry classEntry = (ClassEntry)typeEntry;
            int n2 = line = classEntry.getMethods().isEmpty() ? 0 : classEntry.getMethods().get(0).getLine();
            if (line > 0) {
                int idIdx = this.typeSection.getStringId(classEntry.getFullFileName()).getSequenceNumber();
                CVTypeRecord.CVUdtTypeLineRecord udt = new CVTypeRecord.CVUdtTypeLineRecord(typeRecord.getSequenceNumber(), idIdx, line);
                this.addTypeRecord(udt);
            }
        }
        this.types.typeNameMap.put(typeEntry.getTypeName(), typeRecord);
        this.log("  finished class %s", typeRecord);
        return typeRecord;
    }

    private static boolean isManifestedField(FieldEntry fieldEntry) {
        return fieldEntry.getOffset() >= 0;
    }

    private CVTypeRecord.FieldRecord buildField(FieldEntry fieldEntry) {
        TypeEntry valueType = fieldEntry.getValueType();
        int valueTypeIndex = this.types.getIndexForPointerOrPrimitive(valueType);
        short attr = CVTypeSectionBuilder.modifiersToAttr(fieldEntry);
        if (Modifier.isStatic(fieldEntry.getModifiers())) {
            return new CVTypeRecord.CVStaticMemberRecord(attr, valueTypeIndex, fieldEntry.fieldName());
        }
        return new CVTypeRecord.CVMemberRecord(attr, valueTypeIndex, fieldEntry.getOffset(), fieldEntry.fieldName());
    }

    private static short modifiersToAttr(MethodEntry member) {
        short attr = CVTypeSectionBuilder.accessToAttr(member);
        boolean isStatic = Modifier.isStatic(member.getModifiers());
        attr = isStatic ? (short)(attr + 8) : (!member.isVirtual() ? (short)(attr + 0) : (Modifier.isAbstract(member.getModifiers()) ? (short)(attr + (member.isOverride() ? 20 : 24)) : (short)(attr + (member.isOverride() ? 4 : 16))));
        return attr;
    }

    private static short modifiersToAttr(FieldEntry member) {
        return CVTypeSectionBuilder.accessToAttr(member);
    }

    private CVTypeRecord.CVOneMethodRecord buildMethod(ClassEntry classEntry, MethodEntry methodEntry) {
        CVTypeRecord.CVTypeMFunctionRecord funcRecord = this.buildMemberFunction(classEntry, methodEntry);
        short attr = CVTypeSectionBuilder.modifiersToAttr(methodEntry);
        return new CVTypeRecord.CVOneMethodRecord(attr, funcRecord.getSequenceNumber(), methodEntry.getVtableOffset(), methodEntry.methodName());
    }

    private static short accessToAttr(MemberEntry member) {
        int modifiers = member.getModifiers();
        int attr = Modifier.isPublic(modifiers) ? 3 : (Modifier.isPrivate(modifiers) ? 1 : (Modifier.isProtected(modifiers) ? 2 : 0));
        return (short)attr;
    }

    CVTypeRecord.CVTypeMFunctionRecord buildMemberFunction(ClassEntry classEntry, MethodEntry methodEntry) {
        CVTypeRecord.CVTypeMFunctionRecord mFunctionRecord = new CVTypeRecord.CVTypeMFunctionRecord();
        mFunctionRecord.setClassType(this.types.getIndexForForwardRef(classEntry));
        mFunctionRecord.setCallType((byte)0);
        mFunctionRecord.setThisType(Modifier.isStatic(methodEntry.getModifiers()) ? 0 : this.types.getIndexForPointerOrPrimitive(classEntry));
        byte attr = methodEntry.isConstructor() ? (byte)2 : 0;
        mFunctionRecord.setFuncAttr(attr);
        mFunctionRecord.setReturnType(this.types.getIndexForPointerOrPrimitive(methodEntry.getValueType()));
        CVTypeRecord.CVTypeArglistRecord argListType = new CVTypeRecord.CVTypeArglistRecord();
        for (int i = 0; i < methodEntry.getParamCount(); ++i) {
            argListType.add(this.types.getIndexForPointerOrPrimitive(methodEntry.getParamType(i)));
        }
        argListType = this.addTypeRecord(argListType);
        mFunctionRecord.setArgList(argListType);
        return this.addTypeRecord(mFunctionRecord);
    }

    private <T extends CVTypeRecord> T addTypeRecord(T record) {
        return this.types.addTypeRecord(record);
    }

    int getIndexForPointerOrPrimitive(TypeEntry entry) {
        return this.types.getIndexForPointerOrPrimitive(entry);
    }

    private void log(String fmt, Object ... args) {
        this.typeSection.log(fmt, args);
    }

    static class TypeTable {
        private static final int CV_TYPENAME_INITIAL_CAPACITY = 20000;
        private final Map<String, CVTypeRecord> typeNameMap = new HashMap<String, CVTypeRecord>(20000);
        private final Map<Integer, CVTypeRecord> typePointerMap = new HashMap<Integer, CVTypeRecord>(20000);
        private final Map<String, CVTypeRecord> forwardRefMap = new HashMap<String, CVTypeRecord>(20000);
        private final CVTypeSectionImpl typeSection;

        TypeTable(CVTypeSectionImpl typeSection) {
            this.typeSection = typeSection;
            this.addPrimitiveTypes();
        }

        void testForUndefinedClasses() {
            for (CVTypeRecord record : this.forwardRefMap.values()) {
                CVTypeRecord.CVClassRecord classRecord = (CVTypeRecord.CVClassRecord)record;
                if (this.typeNameMap.containsKey(classRecord.getClassName())) continue;
                GraalError.shouldNotReachHere((String)("no typeentry for " + classRecord.getClassName() + "; type remains incomplete"));
            }
        }

        private <T extends CVTypeRecord> T addTypeRecord(T record) {
            return this.typeSection.addOrReference(record);
        }

        int getIndexForPointerOrPrimitive(TypeEntry entry) {
            CVTypeRecord ptrRecord;
            if (entry.isPrimitive()) {
                CVTypeRecord record = this.getExistingType(entry);
                assert (record != null);
                return record.getSequenceNumber();
            }
            CVTypeRecord forwardRefRecord = this.getExistingForwardReference(entry);
            if (forwardRefRecord == null) {
                forwardRefRecord = this.addTypeRecord(new CVTypeRecord.CVClassRecord(128, entry.getTypeName(), null));
                this.forwardRefMap.put(entry.getTypeName(), forwardRefRecord);
            }
            if ((ptrRecord = this.typePointerMap.get(forwardRefRecord.getSequenceNumber())) == null) {
                ptrRecord = this.addTypeRecord(new CVTypeRecord.CVTypePointerRecord(forwardRefRecord.getSequenceNumber(), 65548));
                this.typePointerMap.put(forwardRefRecord.getSequenceNumber(), ptrRecord);
            }
            return ptrRecord.getSequenceNumber();
        }

        private int getIndexForForwardRef(ClassEntry entry) {
            return this.getIndexForForwardRef(entry.getTypeName());
        }

        int getIndexForForwardRef(String className) {
            CVTypeRecord clsRecord = this.forwardRefMap.get(className);
            if (clsRecord == null) {
                clsRecord = this.addTypeRecord(new CVTypeRecord.CVClassRecord(128, className, null));
                this.forwardRefMap.put(className, clsRecord);
            }
            return clsRecord.getSequenceNumber();
        }

        CVTypeRecord getExistingType(TypeEntry typeEntry) {
            return this.typeNameMap.get(typeEntry.getTypeName());
        }

        CVTypeRecord getExistingForwardReference(TypeEntry typeEntry) {
            return this.forwardRefMap.get(typeEntry.getTypeName());
        }

        void definePrimitiveType(String typename, short typeId, int length, short pointerTypeId) {
            CVTypeRecord.CVTypePrimitive record = new CVTypeRecord.CVTypePrimitive(typeId, length);
            this.typeNameMap.put(typename, record);
            if (pointerTypeId != 0) {
                CVTypeRecord.CVTypePrimitive pointerRecord = new CVTypeRecord.CVTypePrimitive(pointerTypeId, 64);
                this.typePointerMap.put(Integer.valueOf(typeId), pointerRecord);
            }
        }

        private void addPrimitiveTypes() {
            this.definePrimitiveType("void", (short)3, 0, (short)1539);
            this.definePrimitiveType("byte", (short)104, 1, (short)1640);
            this.definePrimitiveType("boolean", (short)48, 1, (short)1584);
            this.definePrimitiveType("char", (short)113, 2, (short)1649);
            this.definePrimitiveType("short", (short)114, 2, (short)1650);
            this.definePrimitiveType("int", (short)116, 4, (short)1652);
            this.definePrimitiveType("long", (short)118, 8, (short)1654);
            this.definePrimitiveType("float", (short)64, 4, (short)1600);
            this.definePrimitiveType("double", (short)65, 8, (short)1601);
        }
    }

    static class FieldListBuilder {
        static final int CV_INDEX_RECORD_SIZE = CVUtil.align4(new CVTypeRecord.CVIndexRecord(0).computeSize());
        final List<CVTypeRecord.FieldRecord> fields = new ArrayList<CVTypeRecord.FieldRecord>();

        FieldListBuilder() {
        }

        void addField(CVTypeRecord.FieldRecord field) {
            this.fields.add(field);
        }

        int getFieldCount() {
            return this.fields.size();
        }

        CVTypeRecord.CVFieldListRecord buildFieldListRecords(CVTypeSectionBuilder builder) {
            CVTypeRecord.CVFieldListRecord currentFieldList = new CVTypeRecord.CVFieldListRecord();
            LinkedList<CVTypeRecord.CVFieldListRecord> fl = new LinkedList<CVTypeRecord.CVFieldListRecord>();
            fl.add(currentFieldList);
            for (CVTypeRecord.FieldRecord fieldRecord : this.fields) {
                int sizeOfExpandedFieldList = currentFieldList.getEstimatedSize() + CVUtil.align4(fieldRecord.computeSize()) + CV_INDEX_RECORD_SIZE;
                if (sizeOfExpandedFieldList >= 65535) {
                    currentFieldList = new CVTypeRecord.CVFieldListRecord();
                    fl.add(currentFieldList);
                }
                currentFieldList.add(fieldRecord);
            }
            CVTypeRecord.CVFieldListRecord fieldListRecord = null;
            int idx = 0;
            while (!fl.isEmpty()) {
                fieldListRecord = (CVTypeRecord.CVFieldListRecord)fl.removeLast();
                fieldListRecord = builder.addTypeRecord(fieldListRecord);
                if (idx != 0) {
                    fieldListRecord.add(new CVTypeRecord.CVIndexRecord(idx));
                }
                idx = fieldListRecord.getSequenceNumber();
            }
            return fieldListRecord;
        }
    }
}

