/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.ELFMachine;
import com.oracle.objectfile.elf.ELFObjectFile;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.debug.DebugContext;

public class DwarfLocSectionImpl
extends DwarfSectionImpl {
    private int[] dwarfRegMap;
    private int dwarfStackRegister;
    protected static final String TARGET_SECTION_NAME = ".text";
    private final LayoutDecision.Kind[] targetSectionKinds = new LayoutDecision.Kind[]{LayoutDecision.Kind.CONTENT, LayoutDecision.Kind.SIZE, LayoutDecision.Kind.VADDR};
    private static final int[] GRAAL_AARCH64_TO_DWARF_REG_MAP = Arrays.stream(DwarfRegEncodingAArch64.values()).sorted(DwarfRegEncodingAArch64::graalOrder).mapToInt(DwarfRegEncodingAArch64::getDwarfEncoding).toArray();
    private static final int[] GRAAL_X86_64_TO_DWARF_REG_MAP = Arrays.stream(DwarfRegEncodingAMD64.values()).sorted(DwarfRegEncodingAMD64::graalOrder).mapToInt(DwarfRegEncodingAMD64::getDwarfEncoding).toArray();

    public DwarfLocSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections);
        this.initDwarfRegMap();
    }

    @Override
    public String getSectionName() {
        return ".debug_loc";
    }

    @Override
    public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        Iterable deps = super.getDependencies((Map)decisions);
        LayoutDecision ourContent = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.CONTENT);
        String abbrevSectionName = this.dwarfSections.getAbbrevSectionImpl().getSectionName();
        ELFObjectFile.ELFSection abbrevSection = (ELFObjectFile.ELFSection)this.getElement().getOwner().elementForName(abbrevSectionName);
        LayoutDecision sizeDecision = decisions.get(abbrevSection).getDecision(LayoutDecision.Kind.SIZE);
        deps.add(BuildDependency.createOrGet(ourContent, sizeDecision));
        return deps;
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        byte[] buffer = null;
        int len = this.generateContent(null, buffer);
        buffer = new byte[len];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_LOC", pos);
        this.log(context, "  [0x%08x] size = 0x%08x", pos, size);
        pos = this.generateContent(context, buffer);
        assert (pos == size);
    }

    private int generateContent(DebugContext context, byte[] buffer) {
        int pos = 0;
        pos = this.writeNormalClassLocations(context, buffer, pos);
        pos = this.writeDeoptClassLocations(context, buffer, pos);
        return pos;
    }

    private int writeNormalClassLocations(DebugContext context, byte[] buffer, int pos) {
        this.log(context, "  [0x%08x] normal class locations", pos);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(pos);
        this.instanceClassStream().filter(ClassEntry::hasCompiledEntries).forEach(classEntry -> cursor.set(this.writeMethodLocations(context, (ClassEntry)classEntry, false, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeDeoptClassLocations(DebugContext context, byte[] buffer, int pos) {
        this.log(context, "  [0x%08x] deopt class locations", pos);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(pos);
        this.instanceClassStream().filter(ClassEntry::hasDeoptCompiledEntries).forEach(classEntry -> cursor.set(this.writeMethodLocations(context, (ClassEntry)classEntry, true, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeMethodLocations(DebugContext context, ClassEntry classEntry, boolean isDeopt, byte[] buffer, int p) {
        int pos = p;
        if (!isDeopt || classEntry.hasDeoptCompiledEntries()) {
            Stream<CompiledMethodEntry> entries = isDeopt ? classEntry.deoptCompiledEntries() : classEntry.normalCompiledEntries();
            pos = entries.reduce(pos, (p1, entry) -> this.writeCompiledMethodLocations(context, (CompiledMethodEntry)entry, buffer, (int)p1), (oldPos, newPos) -> newPos);
        }
        return pos;
    }

    private int writeCompiledMethodLocations(DebugContext context, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeTopLevelLocations(context, compiledEntry, buffer, pos);
        pos = this.writeInlineLocations(context, compiledEntry, buffer, pos);
        return pos;
    }

    private int writeTopLevelLocations(DebugContext context, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        int pos = p;
        Range primary = compiledEntry.getPrimary();
        long base = primary.getLo();
        this.log(context, "  [0x%08x] top level locations [0x%x,0x%x] %s", pos, primary.getLo(), primary.getHi(), primary.getFullMethodNameWithParams());
        HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap = primary.getVarRangeMap();
        for (DebugInfoProvider.DebugLocalInfo local : varRangeMap.keySet()) {
            List<Range> rangeList = varRangeMap.get(local);
            if (rangeList.isEmpty()) continue;
            this.setRangeLocalIndex(primary, local, pos);
            pos = this.writeVarLocations(context, local, base, rangeList, buffer, pos);
        }
        return pos;
    }

    private int writeInlineLocations(DebugContext context, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        int pos = p;
        Range primary = compiledEntry.getPrimary();
        if (primary.isLeaf()) {
            return p;
        }
        long base = primary.getLo();
        this.log(context, "  [0x%08x] inline locations [0x%x,0x%x] %s", pos, primary.getLo(), primary.getHi(), primary.getFullMethodNameWithParams());
        Iterator<Range> iterator = compiledEntry.topDownRangeIterator();
        while (iterator.hasNext()) {
            Range subrange = iterator.next();
            if (subrange.isLeaf()) continue;
            HashMap<DebugInfoProvider.DebugLocalInfo, List<Range>> varRangeMap = subrange.getVarRangeMap();
            for (DebugInfoProvider.DebugLocalInfo local : varRangeMap.keySet()) {
                List<Range> rangeList = varRangeMap.get(local);
                if (rangeList.isEmpty()) continue;
                this.setRangeLocalIndex(subrange, local, pos);
                pos = this.writeVarLocations(context, local, base, rangeList, buffer, pos);
            }
        }
        return pos;
    }

    private int writeVarLocations(DebugContext context, DebugInfoProvider.DebugLocalInfo local, long base, List<Range> rangeList, byte[] buffer, int p) {
        assert (!rangeList.isEmpty());
        int pos = p;
        List<LocalValueExtent> extents = LocalValueExtent.coalesce(local, rangeList);
        pos = this.writeAttrData8(-1L, buffer, pos);
        pos = this.writeAttrAddress(base, buffer, pos);
        block5: for (LocalValueExtent extent : extents) {
            DebugInfoProvider.DebugLocalValueInfo value = extent.value;
            assert (value != null);
            this.log(context, "  [0x%08x]     local  %s:%s [0x%x, 0x%x] = %s", pos, value.name(), value.typeName(), extent.getLo(), extent.getHi(), DwarfLocSectionImpl.formatValue(value));
            pos = this.writeAttrData8(extent.getLo() - base, buffer, pos);
            pos = this.writeAttrData8(extent.getHi() - base, buffer, pos);
            switch (value.localKind()) {
                case REGISTER: {
                    pos = this.writeRegisterLocation(context, value.regIndex(), buffer, pos);
                    continue block5;
                }
                case STACKSLOT: {
                    pos = this.writeStackLocation(context, value.stackSlot(), buffer, pos);
                    continue block5;
                }
                case CONSTANT: {
                    JavaConstant constant = value.constantValue();
                    if (constant instanceof PrimitiveConstant) {
                        pos = this.writePrimitiveConstantLocation(context, value.constantValue(), buffer, pos);
                        continue block5;
                    }
                    if (constant.isNull()) {
                        pos = this.writeNullConstantLocation(context, value.constantValue(), buffer, pos);
                        continue block5;
                    }
                    pos = this.writeObjectConstantLocation(context, value.constantValue(), value.heapOffset(), buffer, pos);
                    continue block5;
                }
            }
            assert (false) : "Should not reach here!";
        }
        pos = this.writeAttrData8(0L, buffer, pos);
        pos = this.writeAttrData8(0L, buffer, pos);
        return pos;
    }

    private int writeRegisterLocation(DebugContext context, int regIndex, byte[] buffer, int p) {
        int targetIdx = this.mapToDwarfReg(regIndex);
        int pos = p;
        if (targetIdx < 32) {
            short byteCount = 1;
            byte regOp = (byte)(80 + targetIdx);
            pos = this.writeShort(byteCount, buffer, pos);
            pos = this.writeByte(regOp, buffer, pos);
            this.verboseLog(context, "  [0x%08x]     REGOP count %d op 0x%x", pos, byteCount, regOp);
        } else {
            assert (targetIdx < 128) : "unexpectedly high reg index!";
            short byteCount = 2;
            byte regOp = -112;
            pos = this.writeShort(byteCount, buffer, pos);
            pos = this.writeByte(regOp, buffer, pos);
            pos = this.writeULEB(targetIdx, buffer, pos);
            this.verboseLog(context, "  [0x%08x]     REGOP count %d op 0x%x reg %d", pos, byteCount, regOp, targetIdx);
            assert (pos == p + 4) : "wrote the wrong number of bytes!";
        }
        return pos;
    }

    private int writeStackLocation(DebugContext context, int offset, byte[] buffer, int p) {
        byte stackOp;
        int pos = p;
        short byteCount = 0;
        int sp = this.getDwarfStackRegister();
        if (sp < 32) {
            stackOp = 112;
            stackOp = (byte)(stackOp + sp);
        } else {
            stackOp = -110;
        }
        int patchPos = pos;
        int zeroPos = pos = this.writeShort(byteCount, buffer, pos);
        pos = this.writeByte(stackOp, buffer, pos);
        if (stackOp == -110) {
            pos = this.writeULEB(sp, buffer, pos);
        }
        pos = this.writeSLEB(offset, buffer, pos);
        byteCount = (byte)(pos - zeroPos);
        this.writeShort(byteCount, buffer, patchPos);
        if (stackOp == -110) {
            this.verboseLog(context, "  [0x%08x]     STACKOP count %d op 0x%x offset %d", pos, byteCount, stackOp, 0 - offset);
        } else {
            this.verboseLog(context, "  [0x%08x]     STACKOP count %d op 0x%x reg %d offset %d", pos, byteCount, stackOp, sp, 0 - offset);
        }
        return pos;
    }

    private int writePrimitiveConstantLocation(DebugContext context, JavaConstant constant, byte[] buffer, int p) {
        assert (constant instanceof PrimitiveConstant);
        int pos = p;
        byte op = -98;
        JavaKind kind = constant.getJavaKind();
        int dataByteCount = kind.getByteCount();
        int byteCount = 2 + dataByteCount;
        pos = this.writeShort((short)byteCount, buffer, pos);
        pos = this.writeByte(op, buffer, pos);
        pos = this.writeULEB(dataByteCount, buffer, pos);
        if (dataByteCount == 1) {
            pos = kind == JavaKind.Boolean ? this.writeByte((byte)(constant.asBoolean() ? 1 : 0), buffer, pos) : this.writeByte((byte)constant.asInt(), buffer, pos);
        } else if (dataByteCount == 2) {
            pos = this.writeShort((short)constant.asInt(), buffer, pos);
        } else if (dataByteCount == 4) {
            int i = kind == JavaKind.Int ? constant.asInt() : Float.floatToRawIntBits(constant.asFloat());
            pos = this.writeInt(i, buffer, pos);
        } else {
            long l = kind == JavaKind.Long ? constant.asLong() : Double.doubleToRawLongBits(constant.asDouble());
            pos = this.writeLong(l, buffer, pos);
        }
        this.verboseLog(context, "  [0x%08x]     CONSTANT (primitive) %s", pos, constant.toValueString());
        return pos;
    }

    private int writeNullConstantLocation(DebugContext context, JavaConstant constant, byte[] buffer, int p) {
        assert (constant.isNull());
        int pos = p;
        byte op = -98;
        int dataByteCount = 8;
        int byteCount = 2 + dataByteCount;
        pos = this.writeShort((short)byteCount, buffer, pos);
        pos = this.writeByte(op, buffer, pos);
        pos = this.writeULEB(dataByteCount, buffer, pos);
        pos = this.writeAttrData8(0L, buffer, pos);
        this.verboseLog(context, "  [0x%08x]     CONSTANT (null) %s", pos, constant.toValueString());
        return pos;
    }

    private int writeObjectConstantLocation(DebugContext context, JavaConstant constant, long heapOffset, byte[] buffer, int p) {
        assert (constant.getJavaKind() == JavaKind.Object && !constant.isNull());
        int pos = p;
        pos = this.writeHeapLocationLocList(heapOffset, buffer, pos);
        this.verboseLog(context, "  [0x%08x]     CONSTANT (object) %s", pos, constant.toValueString());
        return pos;
    }

    @Override
    public String targetSectionName() {
        return TARGET_SECTION_NAME;
    }

    @Override
    public LayoutDecision.Kind[] targetSectionKinds() {
        return this.targetSectionKinds;
    }

    private int getDwarfStackRegister() {
        return this.dwarfStackRegister;
    }

    private int mapToDwarfReg(int regIdx) {
        assert (regIdx >= 0) : "negative register index!";
        assert (regIdx < this.dwarfRegMap.length) : String.format("register index %d exceeds map range %d", regIdx, this.dwarfRegMap.length);
        return this.dwarfRegMap[regIdx];
    }

    private void initDwarfRegMap() {
        if (this.dwarfSections.elfMachine == ELFMachine.AArch64) {
            this.dwarfRegMap = GRAAL_AARCH64_TO_DWARF_REG_MAP;
            this.dwarfStackRegister = DwarfRegEncodingAArch64.SP.getDwarfEncoding();
        } else {
            assert (this.dwarfSections.elfMachine == ELFMachine.X86_64) : "must be";
            this.dwarfRegMap = GRAAL_X86_64_TO_DWARF_REG_MAP;
            this.dwarfStackRegister = DwarfRegEncodingAMD64.RSP.getDwarfEncoding();
        }
    }

    public static enum DwarfRegEncodingAMD64 {
        RAX(0, AMD64.rax.number),
        RDX(1, AMD64.rdx.number),
        RCX(2, AMD64.rcx.number),
        RBX(3, AMD64.rbx.number),
        RSI(4, AMD64.rsi.number),
        RDI(5, AMD64.rdi.number),
        RBP(6, AMD64.rbp.number),
        RSP(7, AMD64.rsp.number),
        R8(8, AMD64.r8.number),
        R9(9, AMD64.r9.number),
        R10(10, AMD64.r10.number),
        R11(11, AMD64.r11.number),
        R12(12, AMD64.r12.number),
        R13(13, AMD64.r13.number),
        R14(14, AMD64.r14.number),
        R15(15, AMD64.r15.number),
        XMM0(17, AMD64.xmm0.number),
        XMM1(18, AMD64.xmm1.number),
        XMM2(19, AMD64.xmm2.number),
        XMM3(20, AMD64.xmm3.number),
        XMM4(21, AMD64.xmm4.number),
        XMM5(22, AMD64.xmm5.number),
        XMM6(23, AMD64.xmm6.number),
        XMM7(24, AMD64.xmm7.number),
        XMM8(25, AMD64.xmm8.number),
        XMM9(26, AMD64.xmm9.number),
        XMM10(27, AMD64.xmm10.number),
        XMM11(28, AMD64.xmm11.number),
        XMM12(29, AMD64.xmm12.number),
        XMM13(30, AMD64.xmm13.number),
        XMM14(31, AMD64.xmm14.number),
        XMM15(32, AMD64.xmm15.number),
        XMM16(60, AMD64.xmm16.number),
        XMM17(61, AMD64.xmm17.number),
        XMM18(62, AMD64.xmm18.number),
        XMM19(63, AMD64.xmm19.number),
        XMM20(64, AMD64.xmm20.number),
        XMM21(65, AMD64.xmm21.number),
        XMM22(66, AMD64.xmm22.number),
        XMM23(67, AMD64.xmm23.number),
        XMM24(68, AMD64.xmm24.number),
        XMM25(69, AMD64.xmm25.number),
        XMM26(70, AMD64.xmm26.number),
        XMM27(71, AMD64.xmm27.number),
        XMM28(72, AMD64.xmm28.number),
        XMM29(73, AMD64.xmm29.number),
        XMM30(74, AMD64.xmm30.number),
        XMM31(75, AMD64.xmm31.number),
        K0(118, AMD64.k0.number),
        K1(119, AMD64.k1.number),
        K2(120, AMD64.k2.number),
        K3(121, AMD64.k3.number),
        K4(122, AMD64.k4.number),
        K5(123, AMD64.k5.number),
        K6(124, AMD64.k6.number),
        K7(125, AMD64.k7.number);

        private final int dwarfEncoding;
        private final int graalEncoding;

        private DwarfRegEncodingAMD64(int dwarfEncoding, int graalEncoding) {
            this.dwarfEncoding = dwarfEncoding;
            this.graalEncoding = graalEncoding;
        }

        public static int graalOrder(DwarfRegEncodingAMD64 e1, DwarfRegEncodingAMD64 e2) {
            return Integer.compare(e1.graalEncoding, e2.graalEncoding);
        }

        public int getDwarfEncoding() {
            return this.dwarfEncoding;
        }
    }

    public static enum DwarfRegEncodingAArch64 {
        R0(0, AArch64.r0.number),
        R1(1, AArch64.r1.number),
        R2(2, AArch64.r2.number),
        R3(3, AArch64.r3.number),
        R4(4, AArch64.r4.number),
        R5(5, AArch64.r5.number),
        R6(6, AArch64.r6.number),
        R7(7, AArch64.r7.number),
        R8(8, AArch64.r8.number),
        R9(9, AArch64.r9.number),
        R10(10, AArch64.r10.number),
        R11(11, AArch64.r11.number),
        R12(12, AArch64.r12.number),
        R13(13, AArch64.r13.number),
        R14(14, AArch64.r14.number),
        R15(15, AArch64.r15.number),
        R16(16, AArch64.r16.number),
        R17(17, AArch64.r17.number),
        R18(18, AArch64.r18.number),
        R19(19, AArch64.r19.number),
        R20(20, AArch64.r20.number),
        R21(21, AArch64.r21.number),
        R22(22, AArch64.r22.number),
        R23(23, AArch64.r23.number),
        R24(24, AArch64.r24.number),
        R25(25, AArch64.r25.number),
        R26(26, AArch64.r26.number),
        R27(27, AArch64.r27.number),
        R28(28, AArch64.r28.number),
        R29(29, AArch64.r29.number),
        R30(30, AArch64.r30.number),
        R31(31, AArch64.r31.number),
        ZR(31, AArch64.zr.number),
        SP(31, AArch64.sp.number),
        V0(64, AArch64.v0.number),
        V1(65, AArch64.v1.number),
        V2(66, AArch64.v2.number),
        V3(67, AArch64.v3.number),
        V4(68, AArch64.v4.number),
        V5(69, AArch64.v5.number),
        V6(70, AArch64.v6.number),
        V7(71, AArch64.v7.number),
        V8(72, AArch64.v8.number),
        V9(73, AArch64.v9.number),
        V10(74, AArch64.v10.number),
        V11(75, AArch64.v11.number),
        V12(76, AArch64.v12.number),
        V13(77, AArch64.v13.number),
        V14(78, AArch64.v14.number),
        V15(79, AArch64.v15.number),
        V16(80, AArch64.v16.number),
        V17(81, AArch64.v17.number),
        V18(82, AArch64.v18.number),
        V19(83, AArch64.v19.number),
        V20(84, AArch64.v20.number),
        V21(85, AArch64.v21.number),
        V22(86, AArch64.v22.number),
        V23(87, AArch64.v23.number),
        V24(88, AArch64.v24.number),
        V25(89, AArch64.v25.number),
        V26(90, AArch64.v26.number),
        V27(91, AArch64.v27.number),
        V28(92, AArch64.v28.number),
        V29(93, AArch64.v29.number),
        V30(94, AArch64.v30.number),
        V31(95, AArch64.v31.number);

        private final int dwarfEncoding;
        private final int graalEncoding;

        private DwarfRegEncodingAArch64(int dwarfEncoding, int graalEncoding) {
            this.dwarfEncoding = dwarfEncoding;
            this.graalEncoding = graalEncoding;
        }

        public static int graalOrder(DwarfRegEncodingAArch64 e1, DwarfRegEncodingAArch64 e2) {
            return Integer.compare(e1.graalEncoding, e2.graalEncoding);
        }

        public int getDwarfEncoding() {
            return this.dwarfEncoding;
        }
    }

    static class LocalValueExtent {
        long lo;
        long hi;
        DebugInfoProvider.DebugLocalValueInfo value;

        LocalValueExtent(long lo, long hi, DebugInfoProvider.DebugLocalValueInfo value) {
            this.lo = lo;
            this.hi = hi;
            this.value = value;
        }

        boolean shouldMerge(int otherLo, int otherHi, DebugInfoProvider.DebugLocalValueInfo otherValue) {
            if (this.hi != (long)otherLo) {
                return false;
            }
            return this.value.equals(otherValue);
        }

        private LocalValueExtent maybeMerge(int otherLo, int otherHi, DebugInfoProvider.DebugLocalValueInfo otherValue) {
            if (this.shouldMerge(otherLo, otherHi, otherValue)) {
                this.hi = otherHi;
                return null;
            }
            return new LocalValueExtent(otherLo, otherHi, otherValue);
        }

        public long getLo() {
            return this.lo;
        }

        public long getHi() {
            return this.hi;
        }

        public DebugInfoProvider.DebugLocalValueInfo getValue() {
            return this.value;
        }

        public static List<LocalValueExtent> coalesce(DebugInfoProvider.DebugLocalInfo local, List<Range> rangeList) {
            ArrayList<LocalValueExtent> extents = new ArrayList<LocalValueExtent>();
            LocalValueExtent current = null;
            for (Range range : rangeList) {
                if (current == null) {
                    current = new LocalValueExtent(range.getLo(), range.getHi(), range.lookupValue(local));
                    extents.add(current);
                    continue;
                }
                LocalValueExtent toAdd = current.maybeMerge(range.getLo(), range.getHi(), range.lookupValue(local));
                if (toAdd == null) continue;
                extents.add(toAdd);
                current = toAdd;
            }
            return extents;
        }
    }
}

