/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.EnumClassEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimitiveTypeEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;

public abstract class DebugInfoBase {
    protected ByteOrder byteOrder;
    private StringTable stringTable = new StringTable();
    private Map<Path, DirEntry> dirsIndex = new HashMap<Path, DirEntry>();
    private List<TypeEntry> types = new ArrayList<TypeEntry>();
    private Map<ResolvedJavaType, TypeEntry> typesIndex = new HashMap<ResolvedJavaType, TypeEntry>();
    private List<ClassEntry> instanceClasses = new ArrayList<ClassEntry>();
    private Map<ResolvedJavaType, ClassEntry> instanceClassesIndex = new HashMap<ResolvedJavaType, ClassEntry>();
    private ClassEntry objectClass;
    private List<FileEntry> files = new ArrayList<FileEntry>();
    private Map<Path, FileEntry> filesIndex = new HashMap<Path, FileEntry>();
    private boolean useHeapBase;
    private int oopCompressShift;
    private int oopTagsCount;
    private int oopReferenceSize;
    private int pointerSize;
    private int oopAlignment;
    private int oopAlignShift;

    public DebugInfoBase(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.useHeapBase = true;
        this.oopTagsCount = 0;
        this.oopCompressShift = 0;
        this.oopReferenceSize = 0;
        this.pointerSize = 0;
        this.oopAlignment = 0;
        this.oopAlignShift = 0;
    }

    public void installDebugInfo(DebugInfoProvider debugInfoProvider) {
        this.useHeapBase = debugInfoProvider.useHeapBase();
        int oopTagsMask = debugInfoProvider.oopTagsMask();
        assert (oopTagsMask > 0 && oopTagsMask < 32);
        assert ((oopTagsMask + 1 & oopTagsMask) == 0);
        this.oopTagsCount = Integer.bitCount(oopTagsMask);
        this.oopCompressShift = debugInfoProvider.oopCompressShift();
        assert (this.oopCompressShift == 0 || this.oopCompressShift == 3);
        this.oopReferenceSize = debugInfoProvider.oopReferenceSize();
        this.pointerSize = debugInfoProvider.pointerSize();
        this.oopAlignment = debugInfoProvider.oopAlignment();
        this.oopAlignShift = Integer.bitCount(this.oopAlignment - 1);
        assert (this.oopAlignment == 8);
        this.stringTable.uniqueDebugString("");
        debugInfoProvider.typeInfoProvider().forEach(debugTypeInfo -> debugTypeInfo.debugContext(debugContext -> {
            ResolvedJavaType idType = debugTypeInfo.idType();
            String typeName = debugTypeInfo.typeName();
            typeName = this.stringTable.uniqueDebugString(typeName);
            DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind = debugTypeInfo.typeKind();
            int byteSize = debugTypeInfo.size();
            debugContext.log(2, "Register %s type %s ", (Object)typeKind.toString(), (Object)typeName);
            String fileName = debugTypeInfo.fileName();
            Path filePath = debugTypeInfo.filePath();
            Path cachePath = debugTypeInfo.cachePath();
            this.addTypeEntry(idType, typeName, fileName, filePath, cachePath, byteSize, typeKind);
        }));
        debugInfoProvider.typeInfoProvider().forEach(debugTypeInfo -> debugTypeInfo.debugContext(debugContext -> {
            ResolvedJavaType idType = debugTypeInfo.idType();
            String typeName = debugTypeInfo.typeName();
            DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind = debugTypeInfo.typeKind();
            debugContext.log(2, "Process %s type %s ", (Object)typeKind.toString(), (Object)typeName);
            TypeEntry typeEntry = this.lookupTypeEntry(idType);
            typeEntry.addDebugInfo(this, (DebugInfoProvider.DebugTypeInfo)debugTypeInfo, (DebugContext)debugContext);
        }));
        debugInfoProvider.codeInfoProvider().forEach(debugCodeInfo -> debugCodeInfo.debugContext(debugContext -> {
            String fileName = debugCodeInfo.fileName();
            Path filePath = debugCodeInfo.filePath();
            ResolvedJavaType ownerType = debugCodeInfo.ownerType();
            String methodName = debugCodeInfo.name();
            int lo = debugCodeInfo.addressLo();
            int hi = debugCodeInfo.addressHi();
            int primaryLine = debugCodeInfo.line();
            ClassEntry classEntry = this.lookupClassEntry(ownerType);
            MethodEntry methodEntry = classEntry.ensureMethodEntryForDebugRangeInfo((DebugInfoProvider.DebugRangeInfo)debugCodeInfo, this, (DebugContext)debugContext);
            Range primaryRange = new Range(this.stringTable, methodEntry, lo, hi, primaryLine);
            debugContext.log(2, "PrimaryRange %s.%s %s %s:%d [0x%x, 0x%x]", (Object)ownerType.toJavaName(), (Object)methodName, (Object)filePath, (Object)fileName, (Object)primaryLine, (Object)lo, (Object)hi);
            classEntry.indexPrimary(primaryRange, debugCodeInfo.getFrameSizeChanges(), debugCodeInfo.getFrameSize());
            HashMap subRangeIndex = new HashMap();
            debugCodeInfo.locationInfoProvider().forEach(debugLocationInfo -> this.addSubrange((DebugInfoProvider.DebugLocationInfo)debugLocationInfo, primaryRange, classEntry, subRangeIndex, (DebugContext)debugContext));
        }));
        debugInfoProvider.dataInfoProvider().forEach(debugDataInfo -> debugDataInfo.debugContext(debugContext -> {
            String provenance = debugDataInfo.getProvenance();
            String typeName = debugDataInfo.getTypeName();
            String partitionName = debugDataInfo.getPartition();
            long address = debugDataInfo.getAddress();
            long size = debugDataInfo.getSize();
            debugContext.log(2, "Data: address 0x%x size 0x%x type %s partition %s provenance %s ", (Object)address, (Object)size, (Object)typeName, (Object)partitionName, (Object)provenance);
        }));
    }

    private TypeEntry createTypeEntry(String typeName, String fileName, Path filePath, Path cachePath, int size, DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind) {
        TypeEntry typeEntry = null;
        switch (typeKind) {
            case INSTANCE: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath, cachePath);
                typeEntry = new ClassEntry(typeName, fileEntry, size);
                break;
            }
            case INTERFACE: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath, cachePath);
                typeEntry = new InterfaceClassEntry(typeName, fileEntry, size);
                break;
            }
            case ENUM: {
                FileEntry fileEntry = this.addFileEntry(fileName, filePath, cachePath);
                typeEntry = new EnumClassEntry(typeName, fileEntry, size);
                break;
            }
            case PRIMITIVE: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new PrimitiveTypeEntry(typeName, size);
                break;
            }
            case ARRAY: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new ArrayTypeEntry(typeName, size);
                break;
            }
            case HEADER: {
                assert (fileName.length() == 0);
                assert (filePath == null);
                typeEntry = new HeaderTypeEntry(typeName, size);
            }
        }
        return typeEntry;
    }

    private TypeEntry addTypeEntry(ResolvedJavaType idType, String typeName, String fileName, Path filePath, Path cachePath, int size, DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind) {
        TypeEntry typeEntry = this.typesIndex.get(idType);
        if (typeEntry == null) {
            typeEntry = this.createTypeEntry(typeName, fileName, filePath, cachePath, size, typeKind);
            this.types.add(typeEntry);
            this.typesIndex.put(idType, typeEntry);
            if (typeName.equals("java.lang.Object")) {
                this.objectClass = (ClassEntry)typeEntry;
            }
            if (typeEntry instanceof ClassEntry) {
                this.indexInstanceClass(idType, (ClassEntry)typeEntry);
            }
        } else if (!typeEntry.isClass()) assert (((ClassEntry)typeEntry).getFileName().equals(fileName));
        return typeEntry;
    }

    public TypeEntry lookupTypeEntry(ResolvedJavaType type) {
        TypeEntry typeEntry = this.typesIndex.get(type);
        if (typeEntry == null) {
            throw new RuntimeException("type entry not found " + type.getName());
        }
        return typeEntry;
    }

    ClassEntry lookupClassEntry(ResolvedJavaType type) {
        assert (type.isInstanceClass() || type.isInterface());
        ClassEntry classEntry = this.instanceClassesIndex.get(type);
        if (classEntry == null || !classEntry.isClass()) {
            throw new RuntimeException("class entry not found " + type.getName());
        }
        assert (this.typesIndex.get(type) != null);
        return classEntry;
    }

    public ClassEntry lookupObjectClass() {
        assert (this.objectClass != null);
        return this.objectClass;
    }

    private Range addSubrange(DebugInfoProvider.DebugLocationInfo locationInfo, Range primaryRange, ClassEntry classEntry, HashMap<DebugInfoProvider.DebugLocationInfo, Range> subRangeIndex, DebugContext debugContext) {
        Range caller;
        boolean isTopLevel;
        DebugInfoProvider.DebugLocationInfo callerLocationInfo = locationInfo.getCaller();
        boolean bl = isTopLevel = callerLocationInfo == null;
        assert (!isTopLevel || locationInfo.name().equals(primaryRange.getMethodName()) && locationInfo.ownerType().toJavaName().equals(primaryRange.getClassName()));
        Range range = caller = isTopLevel ? primaryRange : subRangeIndex.get(callerLocationInfo);
        assert (caller != null);
        String fileName = locationInfo.fileName();
        Path filePath = locationInfo.filePath();
        String fullPath = (String)(filePath == null ? "" : filePath.toString() + "/") + fileName;
        ResolvedJavaType ownerType = locationInfo.ownerType();
        String methodName = locationInfo.name();
        int loOff = locationInfo.addressLo();
        int hiOff = locationInfo.addressHi() - 1;
        int lo = primaryRange.getLo() + locationInfo.addressLo();
        int hi = primaryRange.getLo() + locationInfo.addressHi();
        int line = locationInfo.line();
        ClassEntry subRangeClassEntry = this.lookupClassEntry(ownerType);
        MethodEntry subRangeMethodEntry = subRangeClassEntry.ensureMethodEntryForDebugRangeInfo(locationInfo, this, debugContext);
        Range subRange = new Range(this.stringTable, subRangeMethodEntry, lo, hi, line, primaryRange, isTopLevel, caller);
        classEntry.indexSubRange(subRange);
        subRangeIndex.put(locationInfo, subRange);
        debugContext.log(4, "SubRange %s.%s %d %s:%d [0x%x, 0x%x] (%d, %d)", (Object)ownerType.toJavaName(), (Object)methodName, (Object)subRange.getDepth(), (Object)fullPath, (Object)line, (Object)lo, (Object)hi, (Object)loOff, (Object)hiOff);
        assert (callerLocationInfo == null || callerLocationInfo.addressLo() <= loOff && callerLocationInfo.addressHi() >= hiOff) : "parent range should enclose subrange!";
        DebugInfoProvider.DebugLocalValueInfo[] localValueInfos = locationInfo.getLocalValueInfo();
        for (int i = 0; i < localValueInfos.length; ++i) {
            DebugInfoProvider.DebugLocalValueInfo localValueInfo = localValueInfos[i];
            debugContext.log(4, "  locals[%d] %s:%s = %s", (Object)localValueInfo.slot(), (Object)localValueInfo.name(), (Object)localValueInfo.typeName(), (Object)localValueInfo);
        }
        subRange.setLocalValueInfo(localValueInfos);
        return subRange;
    }

    private void indexInstanceClass(ResolvedJavaType idType, ClassEntry classEntry) {
        this.instanceClasses.add(classEntry);
        this.instanceClassesIndex.put(idType, classEntry);
    }

    private FileEntry addFileEntry(String fileName, Path filePath, Path cachePath) {
        assert (fileName != null);
        Path fileAsPath = filePath != null ? filePath.resolve(fileName) : Paths.get(fileName, new String[0]);
        FileEntry fileEntry = this.filesIndex.get(fileAsPath);
        if (fileEntry == null) {
            DirEntry dirEntry = this.ensureDirEntry(filePath);
            this.uniqueDebugString(fileName);
            this.uniqueDebugString(cachePath.toString());
            fileEntry = new FileEntry(fileName, dirEntry, cachePath);
            this.files.add(fileEntry);
            this.filesIndex.put(fileAsPath, fileEntry);
        } else assert (filePath == null || fileEntry.getDirEntry().getPath().equals(filePath));
        return fileEntry;
    }

    protected FileEntry ensureFileEntry(DebugInfoProvider.DebugFileInfo debugFileInfo) {
        String fileName = debugFileInfo.fileName();
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        Path filePath = debugFileInfo.filePath();
        Path fileAsPath = filePath == null ? Paths.get(fileName, new String[0]) : filePath.resolve(fileName);
        FileEntry fileEntry = this.findFile(fileAsPath);
        if (fileEntry == null) {
            fileEntry = this.addFileEntry(fileName, filePath, debugFileInfo.cachePath());
        }
        return fileEntry;
    }

    private DirEntry ensureDirEntry(Path filePath) {
        if (filePath == null) {
            return null;
        }
        DirEntry dirEntry = this.dirsIndex.get(filePath);
        if (dirEntry == null) {
            this.uniqueDebugString(filePath.toString());
            dirEntry = new DirEntry(filePath);
            this.dirsIndex.put(filePath, dirEntry);
        }
        return dirEntry;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public List<TypeEntry> getTypes() {
        return this.types;
    }

    public List<ClassEntry> getInstanceClasses() {
        return this.instanceClasses;
    }

    public List<FileEntry> getFiles() {
        return this.files;
    }

    public FileEntry findFile(Path fullFileName) {
        return this.filesIndex.get(fullFileName);
    }

    public StringTable getStringTable() {
        return this.stringTable;
    }

    public String uniqueDebugString(String string) {
        return this.stringTable.uniqueDebugString(string);
    }

    public int debugStringIndex(String string) {
        return this.stringTable.debugStringIndex(string);
    }

    public boolean useHeapBase() {
        return this.useHeapBase;
    }

    public byte oopTagsMask() {
        return (byte)((1 << this.oopTagsCount) - 1);
    }

    public byte oopTagsShift() {
        return (byte)this.oopTagsCount;
    }

    public int oopCompressShift() {
        return this.oopCompressShift;
    }

    public int oopReferenceSize() {
        return this.oopReferenceSize;
    }

    public int pointerSize() {
        return this.pointerSize;
    }

    public int oopAlignment() {
        return this.oopAlignment;
    }

    public int oopAlignShift() {
        return this.oopAlignShift;
    }

    public boolean isHubClassEntry(ClassEntry classEntry) {
        return classEntry.getTypeName().equals("java.lang.Class");
    }

    public int classLayoutAbbrevCode(ClassEntry classEntry) {
        if (this.useHeapBase & this.isHubClassEntry(classEntry)) {
            return 9;
        }
        return 8;
    }
}

