/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.util.IllformedLocaleException;
import java.util.Locale;

public class LocaleUtil {
    public static Locale parseLocaleFromTag(String tag) {
        try {
            return new Locale.Builder().setLanguageTag(tag).build();
        }
        catch (IllformedLocaleException ex) {
            String[] parts = tag.split("-");
            switch (parts.length) {
                case 1: {
                    return new Locale(parts[0]);
                }
                case 2: {
                    return new Locale(parts[0], parts[1]);
                }
                case 3: {
                    return new Locale(parts[0], parts[1], parts[2]);
                }
            }
            return null;
        }
    }
}

