/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.common.option;

public final class LocatableOption {
    public final String name;
    public final String origin;

    public static LocatableOption from(String rawOptionName) {
        return new LocatableOption(rawOptionName);
    }

    private LocatableOption(String rawOptionName) {
        int annotationIndex = rawOptionName.indexOf(64);
        if (annotationIndex != -1) {
            this.name = rawOptionName.substring(0, annotationIndex);
            this.origin = rawOptionName.substring(annotationIndex + 1);
        } else {
            this.name = rawOptionName;
            this.origin = null;
        }
    }

    public String toString() {
        String result = "'" + this.name + "'";
        if (this.origin == null) {
            return result;
        }
        return result + " from '" + this.origin + "'";
    }

    public String rawName() {
        return this.origin == null ? this.name : this.name + "@" + this.origin;
    }

    public static Object value(Object value, String origin) {
        return new LocatableOptionValue(value, origin);
    }

    public static Object value(Object value) {
        return LocatableOption.value(value, null);
    }

    public static Object rawValue(Object value) {
        if (value instanceof LocatableOptionValue) {
            return ((LocatableOptionValue)value).value;
        }
        return value;
    }

    public static String valueOrigin(Object value) {
        if (value instanceof LocatableOptionValue) {
            return ((LocatableOptionValue)value).origin;
        }
        return null;
    }

    private static final class LocatableOptionValue {
        private final Object value;
        private final String origin;

        private LocatableOptionValue(Object value, String origin) {
            this.value = value;
            this.origin = origin;
        }

        public String toString() {
            return "LocatableOptionValue(" + String.valueOf(this.value) + ", " + this.origin + ")";
        }
    }
}

