/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.LogUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.debug.GraalError;

public class FileDumpingUtil {
    @SuppressFBWarnings(value={""}, justification="FB reports null pointer dereferencing although it is not possible in this case.")
    public static void dumpFile(Path path, String name, String suffix, Consumer<PrintWriter> writerConsumer) {
        long start = System.nanoTime();
        String filePrefix = String.format(name + "-%d", start);
        try {
            Path tempPath = Files.createTempFile(path.getParent(), filePrefix, suffix, new FileAttribute[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempPath.toFile());){
                try (PrintWriter writer = new PrintWriter(fileOutputStream);){
                    writerConsumer.accept(writer);
                }
                FileDumpingUtil.tryAtomicMove(tempPath, path);
            }
        }
        catch (Exception e) {
            throw GraalError.shouldNotReachHere((Throwable)e, (String)"Error during file dumping.");
        }
    }

    private static void tryAtomicMove(Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            LogUtils.warning("Could not move temporary file (" + String.valueOf(source.toAbsolutePath()) + ") to (" + String.valueOf(target.toAbsolutePath()) + ") atomically. This might result in inconsistencies while reading the file.");
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

