/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.common.meta;

import java.util.Collection;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public interface MultiMethod {
    public static final String MULTI_METHOD_KEY_SEPARATOR = "%%";
    public static final MultiMethodKey ORIGINAL_METHOD = new MultiMethodKey(){

        public String toString() {
            return "Original_Method_Key";
        }
    };
    public static final MultiMethodKey DEOPT_TARGET_METHOD = new MultiMethodKey(){

        public String toString() {
            return "Deopt_Target_Method_Key";
        }
    };

    public static boolean isDeoptTarget(ResolvedJavaMethod method) {
        if (method instanceof MultiMethod) {
            return ((MultiMethod)method).isDeoptTarget();
        }
        return false;
    }

    public MultiMethodKey getMultiMethodKey();

    public MultiMethod getOrCreateMultiMethod(MultiMethodKey var1);

    public MultiMethod getMultiMethod(MultiMethodKey var1);

    public Collection<MultiMethod> getAllMultiMethods();

    default public boolean isOriginalMethod() {
        return this.getMultiMethodKey() == ORIGINAL_METHOD;
    }

    default public boolean isDeoptTarget() {
        return this.getMultiMethodKey() == DEOPT_TARGET_METHOD;
    }

    public static interface MultiMethodKey {
    }
}

