/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface AnnotationWrapper
extends AnnotatedElement {
    public AnnotatedElement getAnnotationRoot();

    default public AnnotatedElement getSecondaryAnnotationRoot() {
        return null;
    }

    default public Annotation[] getInjectedAnnotations() {
        return null;
    }

    default public Class<? extends Annotation>[] getIgnoredAnnotations() {
        return null;
    }

    @Override
    default public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (this.getIgnoredAnnotations() != null) {
            for (Class<? extends Annotation> ignoredAnnotation : this.getIgnoredAnnotations()) {
                if (ignoredAnnotation != annotationClass) continue;
                return false;
            }
        }
        if (this.getInjectedAnnotations() != null) {
            for (Annotation injectedAnnotation : this.getInjectedAnnotations()) {
                if (injectedAnnotation.annotationType() != annotationClass) continue;
                return true;
            }
        }
        if (this.getAnnotationRoot() != null && GuardedAnnotationAccess.isAnnotationPresent(this.getAnnotationRoot(), annotationClass)) {
            return true;
        }
        if (this.getSecondaryAnnotationRoot() != null) {
            return GuardedAnnotationAccess.isAnnotationPresent(this.getSecondaryAnnotationRoot(), annotationClass);
        }
        return false;
    }

    @Override
    default public Annotation[] getAnnotations() {
        return AnnotationWrapper.getAnnotations(this, false);
    }

    @Override
    default public Annotation[] getDeclaredAnnotations() {
        return AnnotationWrapper.getAnnotations(this, true);
    }

    private static Annotation[] getAnnotations(AnnotationWrapper element, boolean declaredOnly) {
        List ignoredAnnotations;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        List<Object> list = ignoredAnnotations = element.getIgnoredAnnotations() == null ? Collections.emptyList() : Arrays.asList(element.getIgnoredAnnotations());
        if (element.getInjectedAnnotations() != null) {
            annotations.addAll(Arrays.asList(element.getInjectedAnnotations()));
        }
        if (element.getAnnotationRoot() != null) {
            Annotation[] rootAnnotations;
            for (Annotation rootAnnotation : rootAnnotations = declaredOnly ? GuardedAnnotationAccess.getDeclaredAnnotations(element.getAnnotationRoot()) : GuardedAnnotationAccess.getAnnotations(element.getAnnotationRoot())) {
                if (ignoredAnnotations.contains(rootAnnotation.annotationType())) continue;
                annotations.add(rootAnnotation);
            }
        }
        if (element.getSecondaryAnnotationRoot() != null) {
            Annotation[] secondaryRootAnnotations;
            for (Annotation secondaryRootAnnotation : secondaryRootAnnotations = declaredOnly ? GuardedAnnotationAccess.getDeclaredAnnotations(element.getSecondaryAnnotationRoot()) : GuardedAnnotationAccess.getAnnotations(element.getSecondaryAnnotationRoot())) {
                if (ignoredAnnotations.contains(secondaryRootAnnotation.annotationType())) continue;
                annotations.add(secondaryRootAnnotation);
            }
        }
        return annotations.toArray(new Annotation[0]);
    }

    @Override
    default public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return AnnotationWrapper.getAnnotation(this, annotationClass, false);
    }

    @Override
    default public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return AnnotationWrapper.getAnnotation(this, annotationClass, true);
    }

    private static <T extends Annotation> T getAnnotation(AnnotationWrapper element, Class<T> annotationClass, boolean declaredOnly) {
        if (element.getIgnoredAnnotations() != null) {
            for (Class<? extends Annotation> ignoredAnnotation : element.getIgnoredAnnotations()) {
                if (ignoredAnnotation != annotationClass) continue;
                return null;
            }
        }
        if (element.getInjectedAnnotations() != null) {
            for (Annotation injectedAnnotation : element.getInjectedAnnotations()) {
                if (injectedAnnotation.annotationType() != annotationClass) continue;
                return (T)((Annotation)annotationClass.cast(injectedAnnotation));
            }
        }
        if (element.getAnnotationRoot() != null) {
            T rootAnnotation;
            T t = rootAnnotation = declaredOnly ? GuardedAnnotationAccess.getDeclaredAnnotation(element.getAnnotationRoot(), annotationClass) : GuardedAnnotationAccess.getAnnotation(element.getAnnotationRoot(), annotationClass);
            if (rootAnnotation != null) {
                return rootAnnotation;
            }
        }
        if (element.getSecondaryAnnotationRoot() != null) {
            return declaredOnly ? GuardedAnnotationAccess.getDeclaredAnnotation(element.getSecondaryAnnotationRoot(), annotationClass) : GuardedAnnotationAccess.getAnnotation(element.getSecondaryAnnotationRoot(), annotationClass);
        }
        return null;
    }
}

