/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalFeature;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.libgraal.jni.LibGraalUtil;
import org.graalvm.word.WordFactory;

@TargetClass(className="org.graalvm.compiler.hotspot.HotSpotGraalCompiler", onlyWith={LibGraalFeature.IsEnabled.class})
final class Target_org_graalvm_compiler_hotspot_HotSpotGraalCompiler {
    Target_org_graalvm_compiler_hotspot_HotSpotGraalCompiler() {
    }

    @Substitute
    private static CompilationRequestResult compileMethod(HotSpotGraalCompiler compiler, CompilationRequest request) {
        long offset = compiler.getGraalRuntime().getVMConfig().jniEnvironmentOffset;
        long javaThreadAddr = HotSpotJVMCIRuntime.runtime().getCurrentJavaThread();
        JNI.JNIEnv env = (JNI.JNIEnv)WordFactory.unsigned((long)javaThreadAddr).add(WordFactory.unsigned((long)offset));
        try (JNIMethodScope scope = LibGraalUtil.openScope((String)"<called from VM>", (JNI.JNIEnv)env);){
            CompilationRequestResult compilationRequestResult = compiler.compileMethod(request, true, compiler.getGraalRuntime().getOptions());
            return compilationRequestResult;
        }
    }
}

