/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalFeature;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.debug.GlobalMetrics;
import org.graalvm.compiler.hotspot.CompilationContext;
import org.graalvm.compiler.hotspot.CompilationTask;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.util.OptionsEncoder;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;
import sun.misc.Unsafe;

public final class LibGraalEntryPoints {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    static final CGlobalData<Pointer> LOG_FILE_BARRIER = CGlobalDataFactory.createWord((WordBase)((Pointer)WordFactory.zero()));
    static final CGlobalData<Pointer> MANAGEMENT_BARRIER = CGlobalDataFactory.createWord((WordBase)((Pointer)WordFactory.zero()));
    private static final ThreadLocal<CachedOptions> cachedOptions = new ThreadLocal();
    private static boolean hasLibGraalIsolatePeer;

    @CEntryPoint(builtin=CEntryPoint.Builtin.GET_CURRENT_THREAD, name="Java_org_graalvm_libgraal_LibGraalScope_getIsolateThreadIn")
    private static native IsolateThread getIsolateThreadIn(PointerBase var0, PointerBase var1, @CEntryPoint.IsolateContext Isolate var2);

    @CEntryPoint(name="Java_org_graalvm_libgraal_LibGraalScope_attachThreadTo", builtin=CEntryPoint.Builtin.ATTACH_THREAD)
    static native long attachThreadTo(PointerBase var0, PointerBase var1, @CEntryPoint.IsolateContext long var2);

    @CEntryPoint(name="Java_org_graalvm_libgraal_LibGraalScope_detachThreadFrom", builtin=CEntryPoint.Builtin.DETACH_THREAD)
    static native void detachThreadFrom(PointerBase var0, PointerBase var1, @CEntryPoint.IsolateThreadContext long var2);

    public static boolean hasLibGraalIsolatePeer() {
        return hasLibGraalIsolatePeer;
    }

    private static OptionValues decodeOptions(long address, int size, int hash) {
        CachedOptions options = cachedOptions.get();
        if (options == null || options.hash != (long)hash) {
            byte[] buffer = new byte[size];
            UNSAFE.copyMemory(null, address, buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, size);
            int actualHash = Arrays.hashCode(buffer);
            if (actualHash != hash) {
                throw new IllegalArgumentException(actualHash + " != " + hash);
            }
            Map srcMap = OptionsEncoder.decode((byte[])buffer);
            EconomicMap dstMap = OptionValues.newOptionMap();
            Iterable loader = OptionsParser.getOptionsLoader();
            for (Map.Entry e : srcMap.entrySet()) {
                String optionName = (String)e.getKey();
                Object optionValue = e.getValue();
                OptionsParser.parseOption((String)optionName, optionValue, (EconomicMap)dstMap, (Iterable)loader);
            }
            options = new CachedOptions(new OptionValues((UnmodifiableEconomicMap)dstMap), hash);
            cachedOptions.set(options);
        }
        return options.options;
    }

    @CEntryPoint(name="Java_org_graalvm_libgraal_LibGraalObject_releaseHandle")
    public static boolean releaseHandle(PointerBase jniEnv, PointerBase jclass, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        try {
            ObjectHandles.getGlobal().destroy((ObjectHandle)WordFactory.pointer((long)handle));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @CEntryPoint(name="Java_org_graalvm_libgraal_LibGraalScope_getIsolateId")
    public static long getIsolateId(PointerBase jniEnv, PointerBase jclass, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        try {
            hasLibGraalIsolatePeer = true;
            return IsolateUtil.getIsolateID();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_test_CompileTheWorld_compileMethodInLibgraal", include=LibGraalFeature.IsEnabled.class)
    private static long compileMethod(PointerBase jniEnv, PointerBase jclass, @CEntryPoint.IsolateThreadContext long isolateThread, long methodHandle, boolean useProfilingInfo, boolean installAsDefault, boolean printMetrics, long optionsAddress, int optionsSize, int optionsHash, long stackTraceAddress, int stackTraceCapacity) {
        try {
            HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
            HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)runtime.getCompiler();
            if (methodHandle == 0L) {
                return 0L;
            }
            HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)LibGraal.unhand(HotSpotResolvedJavaMethod.class, (long)methodHandle);
            int entryBCI = -1;
            HotSpotCompilationRequest request = new HotSpotCompilationRequest(method, entryBCI, 0L);
            try (CompilationContext scope = HotSpotGraalServices.openLocalCompilationContext((Object)request);){
                OptionValues options = LibGraalEntryPoints.decodeOptions(optionsAddress, optionsSize, optionsHash);
                CompilationTask task = new CompilationTask(runtime, compiler, request, useProfilingInfo, installAsDefault);
                task.runCompilation(options);
                HotSpotInstalledCode installedCode = task.getInstalledCode();
                if (printMetrics) {
                    GlobalMetrics metricValues = ((HotSpotGraalRuntime)compiler.getGraalRuntime()).getMetricValues();
                    metricValues.print(options);
                    metricValues.clear();
                }
                long l = LibGraal.translate((Object)installedCode);
                return l;
            }
        }
        catch (Throwable t) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            byte[] stackTrace = baos.toByteArray();
            int length = Math.min(stackTraceCapacity - 4, stackTrace.length);
            UNSAFE.putInt(stackTraceAddress, length);
            UNSAFE.copyMemory(stackTrace, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, stackTraceAddress + 4L, length);
            return 0L;
        }
    }

    static class CachedOptions {
        final OptionValues options;
        final long hash;

        CachedOptions(OptionValues options, long hash) {
            this.options = options;
            this.hash = hash;
        }
    }
}

