/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.XOptions;
import java.util.Map;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;

final class HotSpotGraalOptionValuesUtil {
    private static final String LIBGRAAL_PREFIX = "libgraal.";
    private static final String LIBGRAAL_XOPTION_PREFIX = "libgraal.X";

    HotSpotGraalOptionValuesUtil() {
    }

    static OptionValues initializeOptions() {
        RuntimeOptionValues options = RuntimeOptionValues.singleton();
        options.update((UnmodifiableEconomicMap)HotSpotGraalOptionValues.parseOptions());
        Map savedProps = Services.getSavedProperties();
        EconomicMap optionSettings = EconomicMap.create();
        for (Map.Entry e : savedProps.entrySet()) {
            String xarg;
            String name = (String)e.getKey();
            if (!name.startsWith(LIBGRAAL_PREFIX) || name.startsWith(LIBGRAAL_XOPTION_PREFIX) && XOptions.setOption((String)(xarg = HotSpotGraalOptionValuesUtil.removePrefix(name, LIBGRAAL_XOPTION_PREFIX) + (String)e.getValue()))) continue;
            String value = (String)e.getValue();
            optionSettings.put((Object)HotSpotGraalOptionValuesUtil.removePrefix(name, LIBGRAAL_PREFIX), (Object)value);
        }
        if (!optionSettings.isEmpty()) {
            EconomicMap values = OptionValues.newOptionMap();
            Iterable loader = OptionsParser.getOptionsLoader();
            OptionsParser.parseOptions((EconomicMap)optionSettings, (EconomicMap)values, (Iterable)loader);
            options.update((UnmodifiableEconomicMap)values);
        }
        return options;
    }

    private static String removePrefix(String value, String prefix) {
        assert (value.startsWith(prefix));
        return value.substring(prefix.length());
    }
}

